/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.http.client.fluent;

import io.hops.hudi.org.apache.http.HttpHost;
import io.hops.hudi.org.apache.http.auth.AuthScope;
import io.hops.hudi.org.apache.http.auth.Credentials;
import io.hops.hudi.org.apache.http.auth.MalformedChallengeException;
import io.hops.hudi.org.apache.http.auth.NTCredentials;
import io.hops.hudi.org.apache.http.auth.UsernamePasswordCredentials;
import io.hops.hudi.org.apache.http.client.AuthCache;
import io.hops.hudi.org.apache.http.client.ClientProtocolException;
import io.hops.hudi.org.apache.http.client.CookieStore;
import io.hops.hudi.org.apache.http.client.CredentialsProvider;
import io.hops.hudi.org.apache.http.client.HttpClient;
import io.hops.hudi.org.apache.http.client.fluent.Request;
import io.hops.hudi.org.apache.http.client.fluent.Response;
import io.hops.hudi.org.apache.http.client.protocol.HttpClientContext;
import io.hops.hudi.org.apache.http.config.Registry;
import io.hops.hudi.org.apache.http.config.RegistryBuilder;
import io.hops.hudi.org.apache.http.conn.scheme.Scheme;
import io.hops.hudi.org.apache.http.conn.socket.ConnectionSocketFactory;
import io.hops.hudi.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import io.hops.hudi.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import io.hops.hudi.org.apache.http.conn.ssl.SSLInitializationException;
import io.hops.hudi.org.apache.http.impl.auth.BasicScheme;
import io.hops.hudi.org.apache.http.impl.client.BasicAuthCache;
import io.hops.hudi.org.apache.http.impl.client.BasicCredentialsProvider;
import io.hops.hudi.org.apache.http.impl.client.HttpClientBuilder;
import io.hops.hudi.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import io.hops.hudi.org.apache.http.message.BasicHeader;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;

public class Executor {
    static final PoolingHttpClientConnectionManager CONNMGR;
    static final HttpClient CLIENT;
    private final HttpClient httpclient;
    private volatile AuthCache authCache;
    private volatile CredentialsProvider credentialsProvider;
    private volatile CookieStore cookieStore;

    public static Executor newInstance() {
        return new Executor(CLIENT);
    }

    public static Executor newInstance(HttpClient httpclient) {
        return new Executor(httpclient != null ? httpclient : CLIENT);
    }

    Executor(HttpClient httpclient) {
        this.httpclient = httpclient;
        this.authCache = new BasicAuthCache();
    }

    public Executor use(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public Executor auth(AuthScope authScope, Credentials creds) {
        if (this.credentialsProvider == null) {
            this.credentialsProvider = new BasicCredentialsProvider();
        }
        this.credentialsProvider.setCredentials(authScope, creds);
        return this;
    }

    public Executor auth(HttpHost host2, Credentials creds) {
        AuthScope authScope = host2 != null ? new AuthScope(host2.getHostName(), host2.getPort()) : AuthScope.ANY;
        return this.auth(authScope, creds);
    }

    public Executor auth(String host2, Credentials creds) {
        return this.auth(HttpHost.create(host2), creds);
    }

    public Executor authPreemptive(HttpHost host2) {
        BasicScheme basicScheme = new BasicScheme();
        try {
            basicScheme.processChallenge(new BasicHeader("WWW-Authenticate", "BASIC "));
        }
        catch (MalformedChallengeException malformedChallengeException) {
            // empty catch block
        }
        this.authCache.put(host2, basicScheme);
        return this;
    }

    public Executor authPreemptive(String host2) {
        return this.authPreemptive(HttpHost.create(host2));
    }

    public Executor authPreemptiveProxy(HttpHost proxy) {
        BasicScheme basicScheme = new BasicScheme();
        try {
            basicScheme.processChallenge(new BasicHeader("Proxy-Authenticate", "BASIC "));
        }
        catch (MalformedChallengeException malformedChallengeException) {
            // empty catch block
        }
        this.authCache.put(proxy, basicScheme);
        return this;
    }

    public Executor authPreemptiveProxy(String proxy) {
        return this.authPreemptiveProxy(HttpHost.create(proxy));
    }

    public Executor auth(Credentials cred) {
        return this.auth(AuthScope.ANY, cred);
    }

    public Executor auth(String username, String password) {
        return this.auth(new UsernamePasswordCredentials(username, password));
    }

    public Executor auth(String username, String password, String workstation, String domain) {
        return this.auth(new NTCredentials(username, password, workstation, domain));
    }

    public Executor auth(HttpHost host2, String username, String password) {
        return this.auth(host2, (Credentials)new UsernamePasswordCredentials(username, password));
    }

    public Executor auth(HttpHost host2, String username, String password, String workstation, String domain) {
        return this.auth(host2, (Credentials)new NTCredentials(username, password, workstation, domain));
    }

    public Executor clearAuth() {
        if (this.credentialsProvider != null) {
            this.credentialsProvider.clear();
        }
        return this;
    }

    @Deprecated
    public Executor cookieStore(CookieStore cookieStore2) {
        this.cookieStore = cookieStore2;
        return this;
    }

    public Executor use(CookieStore cookieStore2) {
        this.cookieStore = cookieStore2;
        return this;
    }

    public Executor clearCookies() {
        if (this.cookieStore != null) {
            this.cookieStore.clear();
        }
        return this;
    }

    public Response execute(Request request) throws ClientProtocolException, IOException {
        HttpClientContext localContext = HttpClientContext.create();
        if (this.credentialsProvider != null) {
            localContext.setAttribute("http.auth.credentials-provider", this.credentialsProvider);
        }
        if (this.authCache != null) {
            localContext.setAttribute("http.auth.auth-cache", this.authCache);
        }
        if (this.cookieStore != null) {
            localContext.setAttribute("http.cookie-store", this.cookieStore);
        }
        return new Response(request.internalExecute(this.httpclient, localContext));
    }

    @Deprecated
    public static void registerScheme(Scheme scheme2) {
    }

    @Deprecated
    public static void unregisterScheme(String name2) {
    }

    public static void closeIdleConnections() {
        CONNMGR.closeIdleConnections(0L, TimeUnit.MICROSECONDS);
    }

    static {
        SSLConnectionSocketFactory ssl = null;
        try {
            ssl = SSLConnectionSocketFactory.getSystemSocketFactory();
        }
        catch (SSLInitializationException ex) {
            try {
                SSLContext sslcontext = SSLContext.getInstance("TLS");
                sslcontext.init(null, null, null);
                ssl = new SSLConnectionSocketFactory(sslcontext);
            }
            catch (SecurityException securityException) {
            }
            catch (KeyManagementException keyManagementException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        Registry<ConnectionSocketFactory> sfr = RegistryBuilder.create().register("http", PlainConnectionSocketFactory.getSocketFactory()).register("https", (PlainConnectionSocketFactory)((Object)(ssl != null ? ssl : SSLConnectionSocketFactory.getSocketFactory()))).build();
        CONNMGR = new PoolingHttpClientConnectionManager(sfr);
        CONNMGR.setDefaultMaxPerRoute(100);
        CONNMGR.setMaxTotal(200);
        CONNMGR.setValidateAfterInactivity(1000);
        CLIENT = HttpClientBuilder.create().setConnectionManager(CONNMGR).build();
    }
}

