/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.http.impl.cookie;

import io.hops.hudi.org.apache.http.annotation.Contract;
import io.hops.hudi.org.apache.http.annotation.ThreadingBehavior;
import io.hops.hudi.org.apache.http.cookie.CommonCookieAttributeHandler;
import io.hops.hudi.org.apache.http.cookie.CookieAttributeHandler;
import io.hops.hudi.org.apache.http.cookie.CookieSpec;
import io.hops.hudi.org.apache.http.util.Args;
import io.hops.hudi.org.apache.http.util.Asserts;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Contract(threading=ThreadingBehavior.SAFE)
public abstract class AbstractCookieSpec
implements CookieSpec {
    private final Map<String, CookieAttributeHandler> attribHandlerMap;

    public AbstractCookieSpec() {
        this.attribHandlerMap = new ConcurrentHashMap<String, CookieAttributeHandler>(10);
    }

    protected AbstractCookieSpec(HashMap<String, CookieAttributeHandler> map2) {
        Asserts.notNull(map2, "Attribute handler map");
        this.attribHandlerMap = new ConcurrentHashMap<String, CookieAttributeHandler>(map2);
    }

    protected AbstractCookieSpec(CommonCookieAttributeHandler ... handlers) {
        this.attribHandlerMap = new ConcurrentHashMap<String, CookieAttributeHandler>(handlers.length);
        for (CommonCookieAttributeHandler handler : handlers) {
            this.attribHandlerMap.put(handler.getAttributeName(), handler);
        }
    }

    @Deprecated
    public void registerAttribHandler(String name2, CookieAttributeHandler handler) {
        Args.notNull(name2, "Attribute name");
        Args.notNull(handler, "Attribute handler");
        this.attribHandlerMap.put(name2, handler);
    }

    protected CookieAttributeHandler findAttribHandler(String name2) {
        return this.attribHandlerMap.get(name2);
    }

    protected CookieAttributeHandler getAttribHandler(String name2) {
        CookieAttributeHandler handler = this.findAttribHandler(name2);
        Asserts.check(handler != null, "Handler not registered for " + name2 + " attribute");
        return handler;
    }

    protected Collection<CookieAttributeHandler> getAttribHandlers() {
        return this.attribHandlerMap.values();
    }
}

