/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.client;

import io.hops.hudi.org.eclipse.jetty.client.HttpClient;
import io.hops.hudi.org.eclipse.jetty.client.HttpRedirector;
import io.hops.hudi.org.eclipse.jetty.client.ProtocolHandler;
import io.hops.hudi.org.eclipse.jetty.client.api.Request;
import io.hops.hudi.org.eclipse.jetty.client.api.Response;
import io.hops.hudi.org.eclipse.jetty.client.api.Result;
import io.hops.hudi.org.eclipse.jetty.http.HttpField;
import io.hops.hudi.org.eclipse.jetty.http.HttpHeader;

public class RedirectProtocolHandler
extends Response.Listener.Adapter
implements ProtocolHandler {
    public static final String NAME = "redirect";
    private final HttpRedirector redirector;

    public RedirectProtocolHandler(HttpClient client) {
        this.redirector = new HttpRedirector(client);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean accept(Request request, Response response) {
        return this.redirector.isRedirect(response) && request.isFollowRedirects();
    }

    @Override
    public Response.Listener getResponseListener() {
        return this;
    }

    @Override
    public boolean onHeader(Response response, HttpField field2) {
        return field2.getHeader() != HttpHeader.CONTENT_ENCODING;
    }

    @Override
    public void onComplete(Result result2) {
        Request request = result2.getRequest();
        Response response = result2.getResponse();
        if (result2.isSucceeded()) {
            this.redirector.redirect(request, response, null);
        } else {
            this.redirector.fail(request, response, result2.getFailure());
        }
    }
}

