/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.server.handler;

import io.hops.hudi.org.eclipse.jetty.server.HttpChannel;
import io.hops.hudi.org.eclipse.jetty.server.HttpConfiguration;
import io.hops.hudi.org.eclipse.jetty.server.Request;
import io.hops.hudi.org.eclipse.jetty.server.handler.AbstractHandler;
import io.hops.hudi.org.eclipse.jetty.util.URIUtil;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SecuredRedirectHandler
extends AbstractHandler {
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpChannel channel = baseRequest.getHttpChannel();
        if (baseRequest.isSecure() || channel == null) {
            return;
        }
        HttpConfiguration httpConfig = channel.getHttpConfiguration();
        if (httpConfig == null) {
            response.sendError(403, "No http configuration available");
            return;
        }
        if (httpConfig.getSecurePort() > 0) {
            String scheme2 = httpConfig.getSecureScheme();
            int port = httpConfig.getSecurePort();
            String url2 = URIUtil.newURI(scheme2, baseRequest.getServerName(), port, baseRequest.getRequestURI(), baseRequest.getQueryString());
            response.setContentLength(0);
            baseRequest.getResponse().sendRedirect(302, url2, true);
        } else {
            response.sendError(403, "Not Secure");
        }
        baseRequest.setHandled(true);
    }
}

