/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.servlet;

import io.hops.hudi.org.eclipse.jetty.servlet.BaseHolder;
import io.hops.hudi.org.eclipse.jetty.servlet.Source;
import io.hops.hudi.org.eclipse.jetty.util.annotation.ManagedAttribute;
import io.hops.hudi.org.eclipse.jetty.util.annotation.ManagedObject;
import io.hops.hudi.org.eclipse.jetty.util.log.Log;
import io.hops.hudi.org.eclipse.jetty.util.log.Logger;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Registration;
import javax.servlet.ServletContext;

@ManagedObject(value="Holder - a container for servlets and the like")
public abstract class Holder<T>
extends BaseHolder<T> {
    private static final Logger LOG = Log.getLogger(Holder.class);
    private final Map<String, String> _initParams = new HashMap<String, String>(3);
    private String _displayName;
    private boolean _asyncSupported;
    private String _name;

    protected Holder(Source source) {
        super(source);
        switch (this.getSource().getOrigin()) {
            case JAVAX_API: 
            case DESCRIPTOR: 
            case ANNOTATION: {
                this._asyncSupported = false;
                break;
            }
            default: {
                this._asyncSupported = true;
            }
        }
    }

    @ManagedAttribute(value="Display Name", readonly=true)
    public String getDisplayName() {
        return this._displayName;
    }

    public String getInitParameter(String param2) {
        if (this._initParams == null) {
            return null;
        }
        return this._initParams.get(param2);
    }

    public Enumeration<String> getInitParameterNames() {
        if (this._initParams == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return Collections.enumeration(this._initParams.keySet());
    }

    @ManagedAttribute(value="Initial Parameters", readonly=true)
    public Map<String, String> getInitParameters() {
        return this._initParams;
    }

    @ManagedAttribute(value="Name", readonly=true)
    public String getName() {
        return this._name;
    }

    @Override
    protected synchronized void setInstance(T instance) {
        super.setInstance(instance);
        if (this.getName() == null) {
            this.setName(String.format("%s@%x", instance.getClass().getName(), instance.hashCode()));
        }
    }

    public void destroyInstance(Object instance) throws Exception {
    }

    @Override
    public void setClassName(String className) {
        super.setClassName(className);
        if (this._name == null) {
            this._name = className + "-" + Integer.toHexString(this.hashCode());
        }
    }

    @Override
    public void setHeldClass(Class<? extends T> held) {
        super.setHeldClass(held);
        if (held != null && this._name == null) {
            this._name = held.getName() + "-" + Integer.toHexString(this.hashCode());
        }
    }

    public void setDisplayName(String name2) {
        this._displayName = name2;
    }

    public void setInitParameter(String param2, String value) {
        this._initParams.put(param2, value);
    }

    public void setInitParameters(Map<String, String> map2) {
        this._initParams.clear();
        this._initParams.putAll(map2);
    }

    public void setName(String name2) {
        this._name = name2;
    }

    public void setAsyncSupported(boolean suspendable) {
        this._asyncSupported = suspendable;
    }

    public boolean isAsyncSupported() {
        return this._asyncSupported;
    }

    @Override
    public String dump() {
        return super.dump();
    }

    @Override
    public String toString() {
        return String.format("%s@%x==%s", this._name, this.hashCode(), this.getClassName());
    }

    protected class HolderRegistration
    implements Registration.Dynamic {
        protected HolderRegistration() {
        }

        public void setAsyncSupported(boolean isAsyncSupported) {
            Holder.this.illegalStateIfContextStarted();
            Holder.this.setAsyncSupported(isAsyncSupported);
        }

        public void setDescription(String description2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this + " is " + description2, new Object[0]);
            }
        }

        public String getClassName() {
            return Holder.this.getClassName();
        }

        public String getInitParameter(String name2) {
            return Holder.this.getInitParameter(name2);
        }

        public Map<String, String> getInitParameters() {
            return Holder.this.getInitParameters();
        }

        public String getName() {
            return Holder.this.getName();
        }

        public boolean setInitParameter(String name2, String value) {
            Holder.this.illegalStateIfContextStarted();
            if (name2 == null) {
                throw new IllegalArgumentException("init parameter name required");
            }
            if (value == null) {
                throw new IllegalArgumentException("non-null value required for init parameter " + name2);
            }
            if (Holder.this.getInitParameter(name2) != null) {
                return false;
            }
            Holder.this.setInitParameter(name2, value);
            return true;
        }

        public Set<String> setInitParameters(Map<String, String> initParameters) {
            Holder.this.illegalStateIfContextStarted();
            HashSet<String> clash = null;
            for (Map.Entry<String, String> entry : initParameters.entrySet()) {
                if (entry.getKey() == null) {
                    throw new IllegalArgumentException("init parameter name required");
                }
                if (entry.getValue() == null) {
                    throw new IllegalArgumentException("non-null value required for init parameter " + entry.getKey());
                }
                if (Holder.this.getInitParameter(entry.getKey()) == null) continue;
                if (clash == null) {
                    clash = new HashSet<String>();
                }
                clash.add(entry.getKey());
            }
            if (clash != null) {
                return clash;
            }
            Holder.this.getInitParameters().putAll(initParameters);
            return Collections.emptySet();
        }
    }

    protected class HolderConfig {
        protected HolderConfig() {
        }

        public ServletContext getServletContext() {
            return Holder.this.getServletHandler().getServletContext();
        }

        public String getInitParameter(String param2) {
            return Holder.this.getInitParameter(param2);
        }

        public Enumeration<String> getInitParameterNames() {
            return Holder.this.getInitParameterNames();
        }
    }
}

