/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.util;

import io.hops.hudi.org.eclipse.jetty.util.Promise;
import io.hops.hudi.org.eclipse.jetty.util.annotation.ManagedAttribute;
import io.hops.hudi.org.eclipse.jetty.util.annotation.ManagedObject;
import io.hops.hudi.org.eclipse.jetty.util.log.Log;
import io.hops.hudi.org.eclipse.jetty.util.log.Logger;
import io.hops.hudi.org.eclipse.jetty.util.thread.Scheduler;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public interface SocketAddressResolver {
    public void resolve(String var1, int var2, Promise<List<InetSocketAddress>> var3);

    @ManagedObject(value="The asynchronous address resolver")
    public static class Async
    implements SocketAddressResolver {
        private static final Logger LOG = Log.getLogger(SocketAddressResolver.class);
        private final Executor executor;
        private final Scheduler scheduler;
        private final long timeout;

        public Async(Executor executor, Scheduler scheduler, long timeout) {
            this.executor = executor;
            this.scheduler = scheduler;
            this.timeout = timeout;
        }

        public Executor getExecutor() {
            return this.executor;
        }

        public Scheduler getScheduler() {
            return this.scheduler;
        }

        @ManagedAttribute(value="The timeout, in milliseconds, to resolve an address", readonly=true)
        public long getTimeout() {
            return this.timeout;
        }

        @Override
        public void resolve(String host2, int port, Promise<List<InetSocketAddress>> promise) {
            this.executor.execute(() -> {
                Scheduler.Task task = null;
                AtomicBoolean complete = new AtomicBoolean();
                if (this.timeout > 0L) {
                    Thread thread2 = Thread.currentThread();
                    task = this.scheduler.schedule(() -> {
                        if (complete.compareAndSet(false, true)) {
                            promise.failed(new TimeoutException("DNS timeout " + this.getTimeout() + " ms"));
                            thread2.interrupt();
                        }
                    }, this.timeout, TimeUnit.MILLISECONDS);
                }
                try {
                    long start2 = System.nanoTime();
                    InetAddress[] addresses = InetAddress.getAllByName(host2);
                    long elapsed = System.nanoTime() - start2;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Resolved {} in {} ms", host2, TimeUnit.NANOSECONDS.toMillis(elapsed));
                    }
                    ArrayList<InetSocketAddress> result2 = new ArrayList<InetSocketAddress>(addresses.length);
                    for (InetAddress address : addresses) {
                        result2.add(new InetSocketAddress(address, port));
                    }
                    if (complete.compareAndSet(false, true)) {
                        if (result2.isEmpty()) {
                            promise.failed(new UnknownHostException());
                        } else {
                            promise.succeeded(result2);
                        }
                    }
                }
                catch (Throwable x) {
                    if (complete.compareAndSet(false, true)) {
                        promise.failed(x);
                    }
                }
                finally {
                    if (task != null) {
                        task.cancel();
                    }
                }
            });
        }
    }

    @ManagedObject(value="The synchronous address resolver")
    public static class Sync
    implements SocketAddressResolver {
        @Override
        public void resolve(String host2, int port, Promise<List<InetSocketAddress>> promise) {
            try {
                InetAddress[] addresses = InetAddress.getAllByName(host2);
                ArrayList<InetSocketAddress> result2 = new ArrayList<InetSocketAddress>(addresses.length);
                for (InetAddress address : addresses) {
                    result2.add(new InetSocketAddress(address, port));
                }
                if (result2.isEmpty()) {
                    promise.failed(new UnknownHostException());
                } else {
                    promise.succeeded(result2);
                }
            }
            catch (Throwable x) {
                promise.failed(x);
            }
        }
    }
}

