/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.util.log;

import io.hops.hudi.org.eclipse.jetty.util.Loader;
import io.hops.hudi.org.eclipse.jetty.util.Uptime;
import io.hops.hudi.org.eclipse.jetty.util.annotation.ManagedAttribute;
import io.hops.hudi.org.eclipse.jetty.util.log.Logger;
import io.hops.hudi.org.eclipse.jetty.util.log.LoggerLog;
import io.hops.hudi.org.eclipse.jetty.util.log.StdErrLog;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Log {
    public static final String EXCEPTION = "EXCEPTION ";
    public static final String IGNORED = "IGNORED EXCEPTION ";
    public static String __logClass;
    public static boolean __ignored;
    protected static final Properties __props;
    private static final ConcurrentMap<String, Logger> __loggers;
    private static boolean __initialized;
    private static Logger LOG;

    private static void loadProperties(String resourceName, Properties props) {
        URL testProps = Loader.getResource(resourceName);
        if (testProps != null) {
            try (InputStream in = testProps.openStream();){
                Properties p = new Properties();
                p.load(in);
                for (Object key : p.keySet()) {
                    Object value = p.get(key);
                    if (value == null) continue;
                    props.put(key, value);
                }
            }
            catch (IOException e) {
                System.err.println("[WARN] Error loading logging config: " + testProps);
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialized() {
        Class<Log> clazz = Log.class;
        synchronized (Log.class) {
            if (__initialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            __initialized = true;
            boolean announce = Boolean.parseBoolean(__props.getProperty("io.hops.hudi.org.eclipse.jetty.util.log.announce", "true"));
            try {
                Class logClass = Loader.loadClass(Log.class, __logClass);
                if (LOG == null || !LOG.getClass().equals(logClass)) {
                    LOG = (Logger)logClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (announce) {
                        LOG.debug("Logging to {} via {}", LOG, logClass.getName());
                    }
                }
            }
            catch (Throwable e) {
                Log.initStandardLogging(e);
            }
            if (announce && LOG != null) {
                LOG.info(String.format("Logging initialized @%dms to %s", Uptime.getUptime(), LOG.getClass().getName()), new Object[0]);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            Objects.requireNonNull(LOG, "Root Logger may not be null");
            return;
        }
    }

    private static void initStandardLogging(Throwable e) {
        if (__ignored) {
            e.printStackTrace();
        }
        if (LOG == null) {
            LOG = new StdErrLog();
        }
    }

    public static Logger getLog() {
        Log.initialized();
        return LOG;
    }

    public static void setLog(Logger log) {
        LOG = Objects.requireNonNull(log, "Root Logger may not be null");
        __logClass = null;
    }

    public static Logger getRootLogger() {
        Log.initialized();
        return LOG;
    }

    static boolean isIgnored() {
        return __ignored;
    }

    public static void setLogToParent(String name2) {
        ClassLoader loader = Log.class.getClassLoader();
        if (loader != null && loader.getParent() != null) {
            try {
                Class<?> uberlog = loader.getParent().loadClass("io.hops.hudi.org.eclipse.jetty.util.log.Log");
                Method getLogger = uberlog.getMethod("getLogger", String.class);
                Object logger = getLogger.invoke(null, name2);
                Log.setLog(new LoggerLog(logger));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Log.setLog(Log.getLogger(name2));
        }
    }

    public static Logger getLogger(Class<?> clazz) {
        return Log.getLogger(clazz.getName());
    }

    public static Logger getLogger(String name2) {
        Log.initialized();
        Logger logger = null;
        if (name2 == null) {
            logger = LOG;
        }
        if (logger == null) {
            logger = (Logger)__loggers.get(name2);
        }
        if (logger == null && LOG != null) {
            logger = LOG.getLogger(name2);
        }
        Objects.requireNonNull(logger, "Logger with name [" + name2 + "]");
        return logger;
    }

    static ConcurrentMap<String, Logger> getMutableLoggers() {
        return __loggers;
    }

    @ManagedAttribute(value="list of all instantiated loggers")
    public static Map<String, Logger> getLoggers() {
        return Collections.unmodifiableMap(__loggers);
    }

    public static Properties getProperties() {
        return __props;
    }

    static {
        __props = new Properties();
        __loggers = new ConcurrentHashMap<String, Logger>();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Log.loadProperties("jetty-logging.properties", __props);
                String osName = System.getProperty("os.name");
                if (osName != null && osName.length() > 0) {
                    osName = osName.toLowerCase(Locale.ENGLISH).replace(' ', '-');
                    Log.loadProperties("jetty-logging-" + osName + ".properties", __props);
                }
                Enumeration<?> systemKeyEnum = System.getProperties().propertyNames();
                while (systemKeyEnum.hasMoreElements()) {
                    String key = (String)systemKeyEnum.nextElement();
                    String val = System.getProperty(key);
                    if (val == null) continue;
                    __props.setProperty(key, val);
                }
                __logClass = __props.getProperty("io.hops.hudi.org.eclipse.jetty.util.log.class", "io.hops.hudi.org.eclipse.jetty.util.log.Slf4jLog");
                __ignored = Boolean.parseBoolean(__props.getProperty("io.hops.hudi.org.eclipse.jetty.util.log.IGNORED", "false"));
                return null;
            }
        });
    }
}

