/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.util.thread;

import io.hops.hudi.org.eclipse.jetty.util.StringUtil;
import io.hops.hudi.org.eclipse.jetty.util.annotation.ManagedAttribute;
import io.hops.hudi.org.eclipse.jetty.util.annotation.ManagedObject;
import io.hops.hudi.org.eclipse.jetty.util.annotation.Name;
import io.hops.hudi.org.eclipse.jetty.util.component.AbstractLifeCycle;
import io.hops.hudi.org.eclipse.jetty.util.component.Dumpable;
import io.hops.hudi.org.eclipse.jetty.util.thread.Scheduler;
import java.io.IOException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

@ManagedObject
public class ScheduledExecutorScheduler
extends AbstractLifeCycle
implements Scheduler,
Dumpable {
    private final String name;
    private final boolean daemon;
    private final ClassLoader classloader;
    private final ThreadGroup threadGroup;
    private final int threads;
    private final AtomicInteger count = new AtomicInteger();
    private volatile ScheduledThreadPoolExecutor scheduler;
    private volatile Thread thread;

    public ScheduledExecutorScheduler() {
        this(null, false);
    }

    public ScheduledExecutorScheduler(String name2, boolean daemon) {
        this(name2, daemon, null);
    }

    public ScheduledExecutorScheduler(@Name(value="name") String name2, @Name(value="daemon") boolean daemon, @Name(value="threads") int threads) {
        this(name2, daemon, null, null, threads);
    }

    public ScheduledExecutorScheduler(String name2, boolean daemon, ClassLoader classLoader2) {
        this(name2, daemon, classLoader2, null);
    }

    public ScheduledExecutorScheduler(String name2, boolean daemon, ClassLoader classLoader2, ThreadGroup threadGroup) {
        this(name2, daemon, classLoader2, threadGroup, -1);
    }

    public ScheduledExecutorScheduler(@Name(value="name") String name2, @Name(value="daemon") boolean daemon, @Name(value="classLoader") ClassLoader classLoader2, @Name(value="threadGroup") ThreadGroup threadGroup, @Name(value="threads") int threads) {
        this.name = StringUtil.isBlank(name2) ? "Scheduler-" + this.hashCode() : name2;
        this.daemon = daemon;
        this.classloader = classLoader2 == null ? Thread.currentThread().getContextClassLoader() : classLoader2;
        this.threadGroup = threadGroup;
        this.threads = threads;
    }

    @Override
    protected void doStart() throws Exception {
        int size = this.threads > 0 ? this.threads : 1;
        this.scheduler = new ScheduledThreadPoolExecutor(size, r -> {
            Thread thread2 = this.thread = new Thread(this.threadGroup, r, this.name + "-" + this.count.incrementAndGet());
            thread2.setDaemon(this.daemon);
            thread2.setContextClassLoader(this.classloader);
            return thread2;
        });
        this.scheduler.setRemoveOnCancelPolicy(true);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        this.scheduler.shutdownNow();
        super.doStop();
        this.scheduler = null;
    }

    @Override
    public Scheduler.Task schedule(Runnable task, long delay, TimeUnit unit) {
        ScheduledThreadPoolExecutor s = this.scheduler;
        if (s == null) {
            return () -> false;
        }
        ScheduledFuture<?> result2 = s.schedule(task, delay, unit);
        return new ScheduledFutureTask(result2);
    }

    @Override
    public String dump() {
        return Dumpable.dump(this);
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        Thread thread2 = this.thread;
        if (thread2 == null) {
            Dumpable.dumpObject(out, this);
        } else {
            Dumpable.dumpObjects(out, indent, this, thread2.getStackTrace());
        }
    }

    @ManagedAttribute(value="The name of the scheduler")
    public String getName() {
        return this.name;
    }

    @ManagedAttribute(value="Whether the scheduler uses daemon threads")
    public boolean isDaemon() {
        return this.daemon;
    }

    @ManagedAttribute(value="The number of scheduler threads")
    public int getThreads() {
        return this.threads;
    }

    private static class ScheduledFutureTask
    implements Scheduler.Task {
        private final ScheduledFuture<?> scheduledFuture;

        ScheduledFutureTask(ScheduledFuture<?> scheduledFuture) {
            this.scheduledFuture = scheduledFuture;
        }

        @Override
        public boolean cancel() {
            return this.scheduledFuture.cancel(false);
        }
    }
}

