/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.webapp;

import io.hops.hudi.org.eclipse.jetty.io.RuntimeIOException;
import io.hops.hudi.org.eclipse.jetty.util.ArrayTernaryTrie;
import io.hops.hudi.org.eclipse.jetty.util.IncludeExcludeSet;
import io.hops.hudi.org.eclipse.jetty.util.StringUtil;
import io.hops.hudi.org.eclipse.jetty.util.TypeUtil;
import io.hops.hudi.org.eclipse.jetty.util.URIUtil;
import io.hops.hudi.org.eclipse.jetty.util.resource.Resource;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class ClasspathPattern
extends AbstractSet<String> {
    Map<String, Entry> _entries = new HashMap<String, Entry>();
    IncludeExcludeSet<Entry, String> _packageOrNamePatterns = new IncludeExcludeSet(ByPackageOrName.class);
    IncludeExcludeSet<Entry, URI> _locations = new IncludeExcludeSet(ByLocationOrModule.class);

    public ClasspathPattern() {
    }

    public ClasspathPattern(String[] patterns) {
        this.setAll(patterns);
    }

    public ClasspathPattern(String pattern) {
        this.add(pattern);
    }

    public boolean include(String name2) {
        if (name2 == null) {
            return false;
        }
        return this.add(this.newEntry(name2, true));
    }

    public boolean include(String ... name2) {
        boolean added = false;
        for (String n : name2) {
            if (n == null) continue;
            added = this.add(this.newEntry(n, true)) || added;
        }
        return added;
    }

    public boolean exclude(String name2) {
        if (name2 == null) {
            return false;
        }
        return this.add(this.newEntry(name2, false));
    }

    public boolean exclude(String ... name2) {
        boolean added = false;
        for (String n : name2) {
            if (n == null) continue;
            added = this.add(this.newEntry(n, false)) || added;
        }
        return added;
    }

    @Override
    public boolean add(String pattern) {
        if (pattern == null) {
            return false;
        }
        return this.add(this.newEntry(pattern));
    }

    @Override
    public boolean add(String ... pattern) {
        boolean added = false;
        for (String p : pattern) {
            if (p == null) continue;
            added = this.add(this.newEntry(p)) || added;
        }
        return added;
    }

    protected Entry newEntry(String pattern) {
        if (pattern.startsWith("-")) {
            return this.newEntry(pattern.substring(1), false);
        }
        return this.newEntry(pattern, true);
    }

    protected Entry newEntry(String name2, boolean inclusive) {
        if (name2.startsWith("-")) {
            throw new IllegalStateException(name2);
        }
        if (name2.startsWith("file:")) {
            return new LocationEntry(name2, inclusive);
        }
        if (name2.startsWith("jrt:")) {
            return new ModuleEntry(name2, inclusive);
        }
        if (name2.endsWith(".")) {
            return new PackageEntry(name2, inclusive);
        }
        return new ClassEntry(name2, inclusive);
    }

    @Override
    protected boolean add(Entry entry) {
        if (this._entries.containsKey(entry.getPattern())) {
            return false;
        }
        this._entries.put(entry.getPattern(), entry);
        if (entry instanceof LocationEntry || entry instanceof ModuleEntry) {
            if (entry.isInclusive()) {
                this._locations.include(entry);
            } else {
                this._locations.exclude(entry);
            }
        } else if (entry.isInclusive()) {
            this._packageOrNamePatterns.include(entry);
        } else {
            this._packageOrNamePatterns.exclude(entry);
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof String)) {
            return false;
        }
        String pattern = (String)o;
        Entry entry = this._entries.remove(pattern);
        if (entry == null) {
            return false;
        }
        ArrayList<Entry> saved = new ArrayList<Entry>(this._entries.values());
        this.clear();
        for (Entry e : saved) {
            this.add(e);
        }
        return true;
    }

    @Override
    public void clear() {
        this._entries.clear();
        this._packageOrNamePatterns.clear();
        this._locations.clear();
    }

    @Override
    public Iterator<String> iterator() {
        return this._entries.keySet().iterator();
    }

    @Override
    public int size() {
        return this._entries.size();
    }

    private void setAll(String[] classes2) {
        this._entries.clear();
        this.addAll(classes2);
    }

    private void addAll(String[] classes2) {
        if (classes2 != null) {
            this.addAll(Arrays.asList(classes2));
        }
    }

    public String[] getPatterns() {
        return this.toArray(new String[this._entries.size()]);
    }

    public boolean match(String name2) {
        return this._packageOrNamePatterns.test(name2);
    }

    public boolean match(Class<?> clazz) {
        try {
            return ClasspathPattern.combine(this._packageOrNamePatterns, clazz.getName(), this._locations, () -> TypeUtil.getLocationOfClass(clazz));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean match(String name2, URL url2) {
        if (name2.endsWith(".class")) {
            name2 = name2.substring(0, name2.length() - 6);
        }
        name2 = StringUtil.replace(name2, '/', '.');
        return ClasspathPattern.combine(this._packageOrNamePatterns, name2, this._locations, () -> {
            try {
                return URIUtil.getJarSource(url2.toURI());
            }
            catch (URISyntaxException ignored) {
                return null;
            }
        });
    }

    static boolean combine(IncludeExcludeSet<Entry, String> names, String name2, IncludeExcludeSet<Entry, URI> locations, Supplier<URI> location) {
        Boolean byLocation;
        Boolean byName = names.isIncludedAndNotExcluded(name2);
        if (Boolean.FALSE.equals(byName)) {
            return false;
        }
        URI uri2 = location.get();
        Boolean bl = byLocation = uri2 == null ? null : locations.isIncludedAndNotExcluded(uri2);
        if (Boolean.FALSE.equals(byLocation) || locations.hasExcludes() && uri2 == null) {
            return false;
        }
        if (names.hasIncludes() || locations.hasIncludes()) {
            return Boolean.TRUE.equals(byName) || Boolean.TRUE.equals(byLocation);
        }
        return true;
    }

    public static class ByLocationOrModule
    extends AbstractSet<Entry>
    implements Predicate<URI> {
        private final ByLocation _byLocation = new ByLocation();
        private final ByModule _byModule = new ByModule();

        @Override
        public boolean test(URI name2) {
            if (name2 == null || !name2.isAbsolute()) {
                return false;
            }
            return this._byLocation.test(name2) || this._byModule.test(name2);
        }

        @Override
        public Iterator<Entry> iterator() {
            HashSet<Entry> entries = new HashSet<Entry>();
            entries.addAll(this._byLocation);
            entries.addAll(this._byModule);
            return entries.iterator();
        }

        @Override
        public int size() {
            return this._byLocation.size() + this._byModule.size();
        }

        @Override
        public boolean add(Entry entry) {
            if (entry instanceof LocationEntry) {
                return this._byLocation.add(entry);
            }
            if (entry instanceof ModuleEntry) {
                return this._byModule.add(entry);
            }
            throw new IllegalArgumentException(entry.toString());
        }

        @Override
        public boolean remove(Object o) {
            if (o instanceof LocationEntry) {
                return this._byLocation.remove(o);
            }
            if (o instanceof ModuleEntry) {
                return this._byModule.remove(o);
            }
            return false;
        }

        @Override
        public void clear() {
            this._byLocation.clear();
            this._byModule.clear();
        }
    }

    public static class ByModule
    extends HashSet<Entry>
    implements Predicate<URI> {
        private final ArrayTernaryTrie.Growing<Entry> _entries = new ArrayTernaryTrie.Growing(false, 512, 512);

        @Override
        public boolean test(URI uri2) {
            if (uri2 == null || !uri2.isAbsolute()) {
                return false;
            }
            if (!uri2.getScheme().equalsIgnoreCase("jrt")) {
                return false;
            }
            String module = uri2.getPath();
            int end = module.indexOf(47, 1);
            if (end < 1) {
                end = module.length();
            }
            return this._entries.get(module, 1, end - 1) != null;
        }

        @Override
        public Iterator<Entry> iterator() {
            return this._entries.keySet().stream().map(this._entries::get).iterator();
        }

        @Override
        public int size() {
            return this._entries.size();
        }

        @Override
        public boolean add(Entry entry) {
            if (!(entry instanceof ModuleEntry)) {
                throw new IllegalArgumentException(entry.toString());
            }
            String module = ((ModuleEntry)entry).getModule();
            if (this._entries.get(module) != null) {
                return false;
            }
            this._entries.put(module, entry);
            return true;
        }

        @Override
        public boolean remove(Object entry) {
            if (!(entry instanceof Entry)) {
                return false;
            }
            return this._entries.remove(((Entry)entry).getName()) != null;
        }
    }

    public static class ByLocation
    extends HashSet<Entry>
    implements Predicate<URI> {
        @Override
        public boolean test(URI uri2) {
            if (uri2 == null || !uri2.isAbsolute()) {
                return false;
            }
            if (!uri2.getScheme().equals("file")) {
                return false;
            }
            Path path = Paths.get(uri2);
            for (Entry entry : this) {
                if (!(entry instanceof LocationEntry)) {
                    throw new IllegalStateException();
                }
                File file = ((LocationEntry)entry).getFile();
                if (!(file.isDirectory() ? path.startsWith(file.toPath()) : path.equals(file.toPath()))) continue;
                return true;
            }
            return false;
        }
    }

    public static class ByPackageOrName
    extends AbstractSet<Entry>
    implements Predicate<String> {
        private final ByClass _byClass = new ByClass();
        private final ByPackage _byPackage = new ByPackage();

        @Override
        public boolean test(String name2) {
            return this._byPackage.test(name2) || this._byClass.test(name2);
        }

        @Override
        public Iterator<Entry> iterator() {
            return this._byPackage.iterator();
        }

        @Override
        public int size() {
            return this._byPackage.size();
        }

        @Override
        public boolean add(Entry entry) {
            if (entry instanceof PackageEntry) {
                return this._byPackage.add(entry);
            }
            if (entry instanceof ClassEntry) {
                boolean added = this._byPackage.add(entry);
                added = this._byClass.add(entry) || added;
                return added;
            }
            throw new IllegalArgumentException();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            boolean removedPackage = this._byPackage.remove(o);
            boolean removedClass = this._byClass.remove(o);
            return removedPackage || removedClass;
        }

        @Override
        public void clear() {
            this._byPackage.clear();
            this._byClass.clear();
        }
    }

    public static class ByClass
    extends HashSet<Entry>
    implements Predicate<String> {
        private final Map<String, Entry> _entries = new HashMap<String, Entry>();

        @Override
        public boolean test(String name2) {
            return this._entries.containsKey(name2);
        }

        @Override
        public Iterator<Entry> iterator() {
            return this._entries.values().iterator();
        }

        @Override
        public int size() {
            return this._entries.size();
        }

        @Override
        public boolean add(Entry entry) {
            if (!(entry instanceof ClassEntry)) {
                throw new IllegalArgumentException(entry.toString());
            }
            return this._entries.put(entry.getName(), entry) == null;
        }

        @Override
        public boolean remove(Object entry) {
            if (!(entry instanceof Entry)) {
                return false;
            }
            return this._entries.remove(((Entry)entry).getName()) != null;
        }
    }

    public static class ByPackage
    extends AbstractSet<Entry>
    implements Predicate<String> {
        private final ArrayTernaryTrie.Growing<Entry> _entries = new ArrayTernaryTrie.Growing(false, 512, 512);

        @Override
        public boolean test(String name2) {
            return this._entries.getBest(name2) != null;
        }

        @Override
        public Iterator<Entry> iterator() {
            return this._entries.keySet().stream().map(this._entries::get).iterator();
        }

        @Override
        public int size() {
            return this._entries.size();
        }

        @Override
        public boolean isEmpty() {
            return this._entries.isEmpty();
        }

        @Override
        public boolean add(Entry entry) {
            String name2 = entry.getName();
            if (entry instanceof ClassEntry) {
                name2 = name2 + "$";
            } else {
                if (!(entry instanceof PackageEntry)) {
                    throw new IllegalArgumentException(entry.toString());
                }
                if (".".equals(name2)) {
                    name2 = "";
                }
            }
            if (this._entries.get(name2) != null) {
                return false;
            }
            return this._entries.put(name2, entry);
        }

        @Override
        public boolean remove(Object entry) {
            if (!(entry instanceof Entry)) {
                return false;
            }
            return this._entries.remove(((Entry)entry).getName()) != null;
        }

        @Override
        public void clear() {
            this._entries.clear();
        }
    }

    private static class ModuleEntry
    extends Entry {
        private final String _module;

        protected ModuleEntry(String name2, boolean inclusive) {
            super(name2, inclusive);
            if (!this.getName().startsWith("jrt:")) {
                throw new IllegalArgumentException(name2);
            }
            this._module = this.getName().split("/")[1];
        }

        public String getModule() {
            return this._module;
        }
    }

    private static class LocationEntry
    extends Entry {
        private final File _file;

        protected LocationEntry(String name2, boolean inclusive) {
            super(name2, inclusive);
            if (!this.getName().startsWith("file:")) {
                throw new IllegalArgumentException(name2);
            }
            try {
                this._file = Resource.newResource(this.getName()).getFile();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }

        public File getFile() {
            return this._file;
        }
    }

    private static class ClassEntry
    extends Entry {
        protected ClassEntry(String name2, boolean inclusive) {
            super(name2, inclusive);
        }
    }

    private static class PackageEntry
    extends Entry {
        protected PackageEntry(String name2, boolean inclusive) {
            super(name2, inclusive);
        }
    }

    static class Entry {
        private final String _pattern;
        private final String _name;
        private final boolean _inclusive;

        protected Entry(String name2, boolean inclusive) {
            this._name = name2;
            this._inclusive = inclusive;
            this._pattern = inclusive ? this._name : "-" + this._name;
        }

        public String getPattern() {
            return this._pattern;
        }

        public String getName() {
            return this._name;
        }

        public String toString() {
            return this._pattern;
        }

        public int hashCode() {
            return this._pattern.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof Entry && this._pattern.equals(((Entry)o)._pattern);
        }

        public boolean isInclusive() {
            return this._inclusive;
        }
    }
}

