/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.webapp;

import io.hops.hudi.org.eclipse.jetty.webapp.Descriptor;
import io.hops.hudi.org.eclipse.jetty.webapp.DescriptorProcessor;
import io.hops.hudi.org.eclipse.jetty.webapp.WebAppContext;
import io.hops.hudi.org.eclipse.jetty.xml.XmlParser;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class IterativeDescriptorProcessor
implements DescriptorProcessor {
    public static final Class<?>[] __signature = new Class[]{WebAppContext.class, Descriptor.class, XmlParser.Node.class};
    protected Map<String, Method> _visitors = new HashMap<String, Method>();

    public abstract void start(WebAppContext var1, Descriptor var2);

    public abstract void end(WebAppContext var1, Descriptor var2);

    public void registerVisitor(String nodeName, Method m) {
        this._visitors.put(nodeName, m);
    }

    @Override
    public void process(WebAppContext context, Descriptor descriptor2) throws Exception {
        if (descriptor2 == null) {
            return;
        }
        this.start(context, descriptor2);
        XmlParser.Node root = descriptor2.getRoot();
        Iterator iter = root.iterator();
        XmlParser.Node node = null;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof XmlParser.Node)) continue;
            node = (XmlParser.Node)o;
            this.visit(context, descriptor2, node);
        }
        this.end(context, descriptor2);
    }

    protected void visit(WebAppContext context, Descriptor descriptor2, XmlParser.Node node) throws Exception {
        String name2 = node.getTag();
        Method m = this._visitors.get(name2);
        if (m != null) {
            m.invoke((Object)this, context, descriptor2, node);
        }
    }
}

