/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.websocket.common;

import io.hops.hudi.org.eclipse.jetty.websocket.common.LogicalConnection;
import io.hops.hudi.org.eclipse.jetty.websocket.common.SessionFactory;
import io.hops.hudi.org.eclipse.jetty.websocket.common.WebSocketSession;
import io.hops.hudi.org.eclipse.jetty.websocket.common.events.EventDriver;
import io.hops.hudi.org.eclipse.jetty.websocket.common.events.JettyAnnotatedEventDriver;
import io.hops.hudi.org.eclipse.jetty.websocket.common.events.JettyListenerEventDriver;
import io.hops.hudi.org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import java.net.URI;

public class WebSocketSessionFactory
implements SessionFactory {
    private final WebSocketContainerScope containerScope;

    public WebSocketSessionFactory(WebSocketContainerScope containerScope) {
        this.containerScope = containerScope;
    }

    @Override
    public boolean supports(EventDriver websocket) {
        return websocket instanceof JettyAnnotatedEventDriver || websocket instanceof JettyListenerEventDriver;
    }

    @Override
    public WebSocketSession createSession(URI requestURI, EventDriver websocket, LogicalConnection connection) {
        return new WebSocketSession(this.containerScope, requestURI, websocket, connection);
    }
}

