/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.eclipse.jetty.websocket.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;

public class UpgradeHttpServletRequest
implements HttpServletRequest {
    private static final String UNSUPPORTED_WITH_WEBSOCKET_UPGRADE = "Feature unsupported with a Upgraded to WebSocket HttpServletRequest";
    private HttpServletRequest request;
    private final ServletContext context;
    private final DispatcherType dispatcher;
    private final String method;
    private final String protocol;
    private final String scheme;
    private final boolean secure;
    private final String requestURI;
    private final StringBuffer requestURL;
    private final String pathInfo;
    private final String pathTranslated;
    private final String servletPath;
    private final String query;
    private final String authType;
    private final Cookie[] cookies;
    private final String remoteUser;
    private final Principal principal;
    private final Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, String[]> parameters = new TreeMap<String, String[]>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, Object> attributes = new HashMap<String, Object>(2);
    private final List<Locale> locales = new ArrayList<Locale>(2);
    private HttpSession session;
    private final InetSocketAddress localAddress;
    private final String localName;
    private final InetSocketAddress remoteAddress;
    private final String remoteName;
    private final InetSocketAddress serverAddress;

    public UpgradeHttpServletRequest(HttpServletRequest httpRequest) {
        this.request = httpRequest;
        this.context = httpRequest.getServletContext();
        this.dispatcher = httpRequest.getDispatcherType();
        this.method = httpRequest.getMethod();
        this.protocol = httpRequest.getProtocol();
        this.scheme = httpRequest.getScheme();
        this.secure = httpRequest.isSecure();
        this.requestURI = httpRequest.getRequestURI();
        this.requestURL = httpRequest.getRequestURL();
        this.pathInfo = httpRequest.getPathInfo();
        this.pathTranslated = httpRequest.getPathTranslated();
        this.servletPath = httpRequest.getServletPath();
        this.query = httpRequest.getQueryString();
        this.authType = httpRequest.getAuthType();
        this.cookies = this.request.getCookies();
        this.remoteUser = httpRequest.getRemoteUser();
        this.principal = httpRequest.getUserPrincipal();
        Enumeration headerNames = httpRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name2 = (String)headerNames.nextElement();
            this.headers.put(name2, Collections.list(httpRequest.getHeaders(name2)));
        }
        this.parameters.putAll(this.request.getParameterMap());
        Enumeration attributeNames = httpRequest.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String name3 = (String)attributeNames.nextElement();
            this.attributes.put(name3, httpRequest.getAttribute(name3));
        }
        Enumeration localeElements = httpRequest.getLocales();
        while (localeElements.hasMoreElements()) {
            this.locales.add((Locale)localeElements.nextElement());
        }
        this.localAddress = InetSocketAddress.createUnresolved(httpRequest.getLocalAddr(), httpRequest.getLocalPort());
        this.localName = httpRequest.getLocalName();
        this.remoteAddress = InetSocketAddress.createUnresolved(httpRequest.getRemoteAddr(), httpRequest.getRemotePort());
        this.remoteName = httpRequest.getRemoteHost();
        this.serverAddress = InetSocketAddress.createUnresolved(httpRequest.getServerName(), httpRequest.getServerPort());
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    public String getAuthType() {
        return this.authType;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public String getHeader(String name2) {
        List<String> values2 = this.headers.get(name2);
        if (values2 == null || values2.isEmpty()) {
            return null;
        }
        return values2.get(0);
    }

    public Enumeration<String> getHeaders(String name2) {
        List<String> values2 = this.headers.get(name2);
        if (values2 == null) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(values2);
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public Map<String, List<String>> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public long getDateHeader(String name2) {
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public int getIntHeader(String name2) {
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    public String getContextPath() {
        return this.context.getContextPath();
    }

    public String getQueryString() {
        return this.query;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public boolean isUserInRole(String role) {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request != null) {
            return request.isUserInRole(role);
        }
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        return this.requestURL;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession(boolean create) {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request != null) {
            this.session = request.getSession(create);
            return this.session;
        }
        return this.session;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public String getRequestedSessionId() {
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public Object getAttribute(String name2) {
        return this.attributes.get(name2);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public String getParameter(String name2) {
        String[] values2 = this.parameters.get(name2);
        if (values2 == null || values2.length == 0) {
            return null;
        }
        return values2[0];
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name2) {
        return this.parameters.get(name2);
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameters;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverAddress.getHostString();
    }

    public int getServerPort() {
        return this.serverAddress.getPort();
    }

    public String getRemoteAddr() {
        return this.remoteAddress.getHostString();
    }

    public int getRemotePort() {
        return this.remoteAddress.getPort();
    }

    public String getRemoteHost() {
        return this.remoteName;
    }

    public void setAttribute(String name2, Object value) {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request != null) {
            request.setAttribute(name2, value);
        }
        this.attributes.put(name2, value);
    }

    public void removeAttribute(String name2) {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request != null) {
            request.removeAttribute(name2);
        }
        this.attributes.remove(name2);
    }

    public Locale getLocale() {
        if (this.locales.isEmpty()) {
            return Locale.getDefault();
        }
        return this.locales.get(0);
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(this.locales);
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getRealPath(String path) {
        return this.context.getRealPath(path);
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getLocalAddr() {
        return this.localAddress.getHostString();
    }

    public int getLocalPort() {
        return this.localAddress.getPort();
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public DispatcherType getDispatcherType() {
        return this.dispatcher;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public String changeSessionId() {
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public AsyncContext getAsyncContext() {
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public String getCharacterEncoding() {
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public int getContentLength() {
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public long getContentLengthLong() {
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public String getContentType() {
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public ServletInputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public Part getPart(String name2) throws IOException, ServletException {
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public BufferedReader getReader() throws IOException {
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public void login(String username, String password) throws ServletException {
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public AsyncContext startAsync() throws IllegalStateException {
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        throw new UnsupportedOperationException(UNSUPPORTED_WITH_WEBSOCKET_UPGRADE);
    }

    public void complete() {
        this.request = null;
    }
}

