/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.roaringbitmap;

import io.hops.hudi.org.roaringbitmap.ArrayContainer;
import io.hops.hudi.org.roaringbitmap.BitmapBatchIterator;
import io.hops.hudi.org.roaringbitmap.BitmapContainerCharIterator;
import io.hops.hudi.org.roaringbitmap.BitmapContainerCharRankIterator;
import io.hops.hudi.org.roaringbitmap.CharIterator;
import io.hops.hudi.org.roaringbitmap.Container;
import io.hops.hudi.org.roaringbitmap.ContainerBatchIterator;
import io.hops.hudi.org.roaringbitmap.IntConsumer;
import io.hops.hudi.org.roaringbitmap.PeekableCharIterator;
import io.hops.hudi.org.roaringbitmap.PeekableCharRankIterator;
import io.hops.hudi.org.roaringbitmap.RelativeRangeConsumer;
import io.hops.hudi.org.roaringbitmap.ReverseBitmapContainerCharIterator;
import io.hops.hudi.org.roaringbitmap.RunContainer;
import io.hops.hudi.org.roaringbitmap.Util;
import io.hops.hudi.org.roaringbitmap.buffer.MappeableBitmapContainer;
import io.hops.hudi.org.roaringbitmap.buffer.MappeableContainer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.util.Arrays;
import java.util.Iterator;

public final class BitmapContainer
extends Container
implements Cloneable {
    public static final int MAX_CAPACITY = 65536;
    private static final long serialVersionUID = 2L;
    private static final int BLOCKSIZE = 128;
    private static final boolean USE_BRANCHLESS = true;
    final long[] bitmap;
    int cardinality;
    private final int MAXRUNS = (this.getArraySizeInBytes() - 2) / 4;

    public static CharIterator getReverseShortIterator(long[] bitmap) {
        return new ReverseBitmapContainerCharIterator(bitmap);
    }

    public static PeekableCharIterator getShortIterator(long[] bitmap) {
        return new BitmapContainerCharIterator(bitmap);
    }

    protected static int serializedSizeInBytes(int unusedCardinality) {
        return 8192;
    }

    public BitmapContainer() {
        this.cardinality = 0;
        this.bitmap = new long[1024];
    }

    public BitmapContainer(int firstOfRun, int lastOfRun) {
        this.cardinality = lastOfRun - firstOfRun;
        this.bitmap = new long[1024];
        Util.setBitmapRange(this.bitmap, firstOfRun, lastOfRun);
    }

    private BitmapContainer(int newCardinality, long[] newBitmap) {
        this.cardinality = newCardinality;
        this.bitmap = Arrays.copyOf(newBitmap, newBitmap.length);
    }

    public BitmapContainer(long[] newBitmap, int newCardinality) {
        this.cardinality = newCardinality;
        this.bitmap = newBitmap;
    }

    public BitmapContainer(MappeableBitmapContainer bc) {
        this.cardinality = bc.getCardinality();
        this.bitmap = bc.toLongArray();
    }

    @Override
    public Container add(int begin, int end) {
        if (end == begin) {
            return this.clone();
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        BitmapContainer answer = this.clone();
        int prevOnesInRange = answer.cardinalityInRange(begin, end);
        Util.setBitmapRange(answer.bitmap, begin, end);
        answer.updateCardinality(prevOnesInRange, end - begin);
        return answer;
    }

    @Override
    public Container add(char i) {
        long newval;
        long previous = this.bitmap[i >>> 6];
        this.bitmap[i >>> 6] = newval = previous | 1L << i;
        this.cardinality += (int)((previous ^ newval) >>> i);
        return this;
    }

    @Override
    public ArrayContainer and(ArrayContainer value2) {
        ArrayContainer answer = new ArrayContainer(value2.content.length);
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            char v;
            answer.content[answer.cardinality] = v = value2.content[k];
            answer.cardinality += this.bitValue(v);
        }
        return answer;
    }

    @Override
    public Container and(BitmapContainer value2) {
        int newCardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] & value2.bitmap[k]);
        }
        if (newCardinality > 4096) {
            BitmapContainer answer = new BitmapContainer();
            for (int k = 0; k < answer.bitmap.length; ++k) {
                answer.bitmap[k] = this.bitmap[k] & value2.bitmap[k];
            }
            answer.cardinality = newCardinality;
            return answer;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        Util.fillArrayAND(ac.content, this.bitmap, value2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public Container and(RunContainer x) {
        return x.and(this);
    }

    @Override
    public int andCardinality(ArrayContainer value2) {
        int answer = 0;
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            char v = value2.content[k];
            answer += this.bitValue(v);
        }
        return answer;
    }

    @Override
    public int andCardinality(BitmapContainer value2) {
        int newCardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] & value2.bitmap[k]);
        }
        return newCardinality;
    }

    @Override
    public int andCardinality(RunContainer x) {
        return x.andCardinality(this);
    }

    @Override
    public Container andNot(ArrayContainer value2) {
        BitmapContainer answer = this.clone();
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            long aft;
            char v = value2.content[k];
            int i = v >>> 6;
            long w = answer.bitmap[i];
            answer.bitmap[i] = aft = w & (1L << v ^ 0xFFFFFFFFFFFFFFFFL);
            answer.cardinality = (int)((long)answer.cardinality - ((w ^ aft) >>> v));
        }
        if (answer.cardinality <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public Container andNot(BitmapContainer value2) {
        int newCardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] & (value2.bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL));
        }
        if (newCardinality > 4096) {
            BitmapContainer answer = new BitmapContainer();
            for (int k = 0; k < answer.bitmap.length; ++k) {
                answer.bitmap[k] = this.bitmap[k] & (value2.bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL);
            }
            answer.cardinality = newCardinality;
            return answer;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        Util.fillArrayANDNOT(ac.content, this.bitmap, value2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public Container andNot(RunContainer x) {
        BitmapContainer answer = this.clone();
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            char start2 = x.getValue(rlepos);
            int end = start2 + x.getLength(rlepos) + 1;
            int prevOnesInRange = answer.cardinalityInRange(start2, end);
            Util.resetBitmapRange(answer.bitmap, start2, end);
            answer.updateCardinality(prevOnesInRange, 0);
        }
        if (answer.getCardinality() > 4096) {
            return answer;
        }
        return answer.toArrayContainer();
    }

    @Override
    public void clear() {
        if (this.cardinality != 0) {
            this.cardinality = 0;
            Arrays.fill(this.bitmap, 0L);
        }
    }

    @Override
    public BitmapContainer clone() {
        return new BitmapContainer(this.cardinality, this.bitmap);
    }

    @Override
    public boolean isEmpty() {
        return this.cardinality == 0;
    }

    void computeCardinality() {
        this.cardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            this.cardinality += Long.bitCount(this.bitmap[k]);
        }
    }

    int cardinalityInRange(int start2, int end) {
        if (this.cardinality != -1 && end - start2 > 32768) {
            int before = Util.cardinalityInBitmapRange(this.bitmap, 0, start2);
            int after = Util.cardinalityInBitmapRange(this.bitmap, end, 65536);
            return this.cardinality - before - after;
        }
        return Util.cardinalityInBitmapRange(this.bitmap, start2, end);
    }

    void updateCardinality(int prevOnes, int newOnes) {
        int oldCardinality = this.cardinality;
        this.cardinality = oldCardinality - prevOnes + newOnes;
    }

    @Override
    public boolean contains(char i) {
        return (this.bitmap[i >>> 6] & 1L << i) != 0L;
    }

    @Override
    public boolean contains(int minimum, int supremum) {
        int start2 = minimum >>> 6;
        int end = supremum >>> 6;
        long first = -(1L << minimum);
        long last = (1L << supremum) - 1L;
        if (start2 == end) {
            return (this.bitmap[end] & first & last) == (first & last);
        }
        if ((this.bitmap[start2] & first) != first) {
            return false;
        }
        if (end < this.bitmap.length && (this.bitmap[end] & last) != last) {
            return false;
        }
        for (int i = start2 + 1; i < this.bitmap.length && i < end; ++i) {
            if (this.bitmap[i] == -1L) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean contains(BitmapContainer bitmapContainer) {
        if (this.cardinality != -1 && bitmapContainer.cardinality != -1 && this.cardinality < bitmapContainer.cardinality) {
            return false;
        }
        for (int i = 0; i < bitmapContainer.bitmap.length; ++i) {
            if ((this.bitmap[i] & bitmapContainer.bitmap[i]) == bitmapContainer.bitmap[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean contains(RunContainer runContainer) {
        int card;
        int runCardinality = runContainer.getCardinality();
        if (this.cardinality != -1 ? this.cardinality < runCardinality : (card = this.cardinality) < runCardinality) {
            return false;
        }
        for (int i = 0; i < runContainer.numberOfRuns(); ++i) {
            char length;
            char start2 = runContainer.getValue(i);
            if (this.contains(start2, start2 + (length = runContainer.getLength(i)))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean contains(ArrayContainer arrayContainer) {
        if (arrayContainer.cardinality != -1 && this.cardinality < arrayContainer.cardinality) {
            return false;
        }
        for (int i = 0; i < arrayContainer.cardinality; ++i) {
            if (this.contains(arrayContainer.content[i])) continue;
            return false;
        }
        return true;
    }

    int bitValue(char i) {
        return (int)(this.bitmap[i >>> 6] >>> i) & 1;
    }

    @Override
    public void deserialize(DataInput in) throws IOException {
        this.cardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            long w;
            this.bitmap[k] = w = Long.reverseBytes(in.readLong());
            this.cardinality += Long.bitCount(w);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof BitmapContainer) {
            BitmapContainer srb = (BitmapContainer)o;
            if (srb.cardinality != this.cardinality) {
                return false;
            }
            return Arrays.equals(this.bitmap, srb.bitmap);
        }
        if (o instanceof RunContainer) {
            return o.equals(this);
        }
        return false;
    }

    void fillArray(char[] array) {
        int pos = 0;
        int base2 = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            for (long bitset = this.bitmap[k]; bitset != 0L; bitset &= bitset - 1L) {
                array[pos++] = (char)(base2 + Long.numberOfTrailingZeros(bitset));
            }
            base2 += 64;
        }
    }

    @Override
    public void fillLeastSignificant16bits(int[] x, int i, int mask) {
        int pos = i;
        int base2 = mask;
        for (int k = 0; k < this.bitmap.length; ++k) {
            for (long bitset = this.bitmap[k]; bitset != 0L; bitset &= bitset - 1L) {
                x[pos++] = base2 + Long.numberOfTrailingZeros(bitset);
            }
            base2 += 64;
        }
    }

    @Override
    public Container flip(char i) {
        int index = i >>> 6;
        long bef = this.bitmap[index];
        long mask = 1L << i;
        if (this.cardinality == 4097 && (bef & mask) != 0L) {
            --this.cardinality;
            int n = index;
            this.bitmap[n] = this.bitmap[n] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            return this.toArrayContainer();
        }
        this.cardinality += 1 - 2 * (int)((bef & mask) >>> i);
        int n = index;
        this.bitmap[n] = this.bitmap[n] ^ mask;
        return this;
    }

    @Override
    public int getArraySizeInBytes() {
        return 8192;
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    @Override
    public PeekableCharIterator getReverseCharIterator() {
        return new ReverseBitmapContainerCharIterator(this.bitmap);
    }

    @Override
    public PeekableCharIterator getCharIterator() {
        return new BitmapContainerCharIterator(this.bitmap);
    }

    @Override
    public PeekableCharRankIterator getCharRankIterator() {
        return new BitmapContainerCharRankIterator(this.bitmap);
    }

    @Override
    public ContainerBatchIterator getBatchIterator() {
        return new BitmapBatchIterator(this);
    }

    @Override
    public int getSizeInBytes() {
        return this.bitmap.length * 8;
    }

    public int hashCode() {
        return Arrays.hashCode(this.bitmap);
    }

    @Override
    public Container iadd(int begin, int end) {
        if (end == begin) {
            return this;
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        int prevOnesInRange = this.cardinalityInRange(begin, end);
        Util.setBitmapRange(this.bitmap, begin, end);
        this.updateCardinality(prevOnesInRange, end - begin);
        return this;
    }

    @Override
    public Container iand(ArrayContainer b2) {
        if (-1 == this.cardinality) {
            Util.intersectArrayIntoBitmap(this.bitmap, b2.content, b2.cardinality);
            return this;
        }
        return b2.and(this);
    }

    @Override
    public Container iand(BitmapContainer b2) {
        int k;
        if (-1 == this.cardinality) {
            for (int i = 0; i < this.bitmap.length; ++i) {
                int n = i;
                this.bitmap[n] = this.bitmap[n] & b2.bitmap[i];
            }
            return this;
        }
        int newCardinality = 0;
        for (k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] & b2.bitmap[k]);
        }
        if (newCardinality > 4096) {
            for (k = 0; k < this.bitmap.length; ++k) {
                this.bitmap[k] = this.bitmap[k] & b2.bitmap[k];
            }
            this.cardinality = newCardinality;
            return this;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        Util.fillArrayAND(ac.content, this.bitmap, b2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public Container iand(RunContainer x) {
        int card = x.getCardinality();
        if (-1 != this.cardinality && card <= 4096) {
            ArrayContainer answer = new ArrayContainer(card);
            answer.cardinality = 0;
            for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
                int runStart = x.getValue(rlepos);
                int runEnd = runStart + x.getLength(rlepos);
                for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                    answer.content[answer.cardinality] = (char)runValue;
                    answer.cardinality += this.bitValue((char)runValue);
                }
            }
            return answer;
        }
        int start2 = 0;
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            char end = x.getValue(rlepos);
            if (-1 == this.cardinality) {
                Util.resetBitmapRange(this.bitmap, start2, end);
            } else {
                int prevOnes = this.cardinalityInRange(start2, end);
                Util.resetBitmapRange(this.bitmap, start2, end);
                this.updateCardinality(prevOnes, 0);
            }
            start2 = end + x.getLength(rlepos) + 1;
        }
        if (-1 == this.cardinality) {
            Util.resetBitmapRange(this.bitmap, start2, 65536);
        } else {
            int ones = this.cardinalityInRange(start2, 65536);
            Util.resetBitmapRange(this.bitmap, start2, 65536);
            this.updateCardinality(ones, 0);
            if (this.getCardinality() <= 4096) {
                return this.toArrayContainer();
            }
        }
        return this;
    }

    @Override
    public Container iandNot(ArrayContainer b2) {
        for (int k = 0; k < b2.cardinality; ++k) {
            this.remove(b2.content[k]);
        }
        if (this.cardinality <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public Container iandNot(BitmapContainer b2) {
        int k;
        int newCardinality = 0;
        for (k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] & (b2.bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL));
        }
        if (newCardinality > 4096) {
            for (k = 0; k < this.bitmap.length; ++k) {
                this.bitmap[k] = this.bitmap[k] & (b2.bitmap[k] ^ 0xFFFFFFFFFFFFFFFFL);
            }
            this.cardinality = newCardinality;
            return this;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        Util.fillArrayANDNOT(ac.content, this.bitmap, b2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public Container iandNot(RunContainer x) {
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            char start2 = x.getValue(rlepos);
            int end = start2 + x.getLength(rlepos) + 1;
            int prevOnesInRange = this.cardinalityInRange(start2, end);
            Util.resetBitmapRange(this.bitmap, start2, end);
            this.updateCardinality(prevOnesInRange, 0);
        }
        if (this.getCardinality() > 4096) {
            return this;
        }
        return this.toArrayContainer();
    }

    Container ilazyor(ArrayContainer value2) {
        this.cardinality = -1;
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            int i;
            char v = value2.content[k];
            int n = i = v >>> 6;
            this.bitmap[n] = this.bitmap[n] | 1L << v;
        }
        return this;
    }

    Container ilazyor(BitmapContainer x) {
        this.cardinality = -1;
        for (int k = 0; k < this.bitmap.length; ++k) {
            int n = k;
            this.bitmap[n] = this.bitmap[n] | x.bitmap[k];
        }
        return this;
    }

    Container ilazyor(RunContainer x) {
        this.cardinality = -1;
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            char start2 = x.getValue(rlepos);
            int end = start2 + x.getLength(rlepos) + 1;
            Util.setBitmapRange(this.bitmap, start2, end);
        }
        return this;
    }

    @Override
    public Container inot(int firstOfRange, int lastOfRange) {
        int prevOnes = this.cardinalityInRange(firstOfRange, lastOfRange);
        Util.flipBitmapRange(this.bitmap, firstOfRange, lastOfRange);
        this.updateCardinality(prevOnes, lastOfRange - firstOfRange - prevOnes);
        if (this.cardinality <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public boolean intersects(ArrayContainer value2) {
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            if (!this.contains(value2.content[k])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(BitmapContainer value2) {
        for (int k = 0; k < this.bitmap.length; ++k) {
            if ((this.bitmap[k] & value2.bitmap[k]) == 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(RunContainer x) {
        return x.intersects(this);
    }

    @Override
    public boolean intersects(int minimum, int supremum) {
        if (minimum < 0 || supremum < minimum || supremum > 65536) {
            throw new RuntimeException("This should never happen (bug).");
        }
        int start2 = minimum >>> 6;
        int end = supremum >>> 6;
        if (start2 == end) {
            return (this.bitmap[end] & (-(1L << minimum) & (1L << supremum) - 1L)) != 0L;
        }
        if ((this.bitmap[start2] & -(1L << minimum)) != 0L) {
            return true;
        }
        if (end < this.bitmap.length && (this.bitmap[end] & (1L << supremum) - 1L) != 0L) {
            return true;
        }
        for (int i = 1 + start2; i < end && i < this.bitmap.length; ++i) {
            if (this.bitmap[i] == 0L) continue;
            return true;
        }
        return false;
    }

    @Override
    public BitmapContainer ior(ArrayContainer value2) {
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            long aft;
            int i = value2.content[k] >>> 6;
            long bef = this.bitmap[i];
            this.bitmap[i] = aft = bef | 1L << value2.content[k];
            this.cardinality += (int)(bef - aft >>> 63);
        }
        return this;
    }

    @Override
    public Container ior(BitmapContainer b2) {
        int k = 0;
        while (k < this.bitmap.length & k < b2.bitmap.length) {
            int n = k;
            this.bitmap[n] = this.bitmap[n] | b2.bitmap[k];
            ++k;
        }
        this.computeCardinality();
        if (this.isFull()) {
            return RunContainer.full();
        }
        return this;
    }

    @Override
    public Container ior(RunContainer x) {
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            char start2 = x.getValue(rlepos);
            int end = start2 + x.getLength(rlepos) + 1;
            int prevOnesInRange = this.cardinalityInRange(start2, end);
            Util.setBitmapRange(this.bitmap, start2, end);
            this.updateCardinality(prevOnesInRange, end - start2);
        }
        if (this.isFull()) {
            return RunContainer.full();
        }
        return this;
    }

    @Override
    public Container iremove(int begin, int end) {
        if (end == begin) {
            return this;
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        int prevOnesInRange = this.cardinalityInRange(begin, end);
        Util.resetBitmapRange(this.bitmap, begin, end);
        this.updateCardinality(prevOnesInRange, 0);
        if (this.getCardinality() <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public Iterator<Character> iterator() {
        return new Iterator<Character>(){
            final CharIterator si;
            {
                this.si = BitmapContainer.this.getCharIterator();
            }

            @Override
            public boolean hasNext() {
                return this.si.hasNext();
            }

            @Override
            public Character next() {
                return Character.valueOf(this.si.next());
            }

            @Override
            public void remove() {
                throw new RuntimeException("unsupported operation: remove");
            }
        };
    }

    @Override
    public Container ixor(ArrayContainer value2) {
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            char vc = value2.content[k];
            long mask = 1L << vc;
            int index = vc >>> 6;
            long ba = this.bitmap[index];
            this.cardinality += 1 - 2 * (int)((ba & mask) >>> vc);
            this.bitmap[index] = ba ^ mask;
        }
        if (this.cardinality <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public Container ixor(BitmapContainer b2) {
        int k = 0;
        while (k < this.bitmap.length & k < b2.bitmap.length) {
            int n = k;
            this.bitmap[n] = this.bitmap[n] ^ b2.bitmap[k];
            ++k;
        }
        this.computeCardinality();
        if (this.cardinality > 4096) {
            return this;
        }
        return this.toArrayContainer();
    }

    @Override
    public Container ixor(RunContainer x) {
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            char start2 = x.getValue(rlepos);
            int end = start2 + x.getLength(rlepos) + 1;
            int prevOnes = this.cardinalityInRange(start2, end);
            Util.flipBitmapRange(this.bitmap, start2, end);
            this.updateCardinality(prevOnes, end - start2 - prevOnes);
        }
        if (this.getCardinality() > 4096) {
            return this;
        }
        return this.toArrayContainer();
    }

    protected Container lazyor(ArrayContainer value2) {
        BitmapContainer answer = this.clone();
        answer.cardinality = -1;
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            int i;
            char v = value2.content[k];
            int n = i = v >>> 6;
            answer.bitmap[n] = answer.bitmap[n] | 1L << v;
        }
        return answer;
    }

    protected Container lazyor(BitmapContainer x) {
        BitmapContainer answer = new BitmapContainer();
        answer.cardinality = -1;
        for (int k = 0; k < this.bitmap.length; ++k) {
            answer.bitmap[k] = this.bitmap[k] | x.bitmap[k];
        }
        return answer;
    }

    protected Container lazyor(RunContainer x) {
        BitmapContainer bc = this.clone();
        bc.cardinality = -1;
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            char start2 = x.getValue(rlepos);
            int end = start2 + x.getLength(rlepos) + 1;
            Util.setBitmapRange(bc.bitmap, start2, end);
        }
        return bc;
    }

    @Override
    public Container limit(int maxcardinality) {
        if (maxcardinality >= this.cardinality) {
            return this.clone();
        }
        if (maxcardinality <= 4096) {
            ArrayContainer ac = new ArrayContainer(maxcardinality);
            int pos = 0;
            for (int k = 0; ac.cardinality < maxcardinality && k < this.bitmap.length; ++k) {
                for (long bitset = this.bitmap[k]; ac.cardinality < maxcardinality && bitset != 0L; bitset &= bitset - 1L) {
                    ac.content[pos++] = (char)(k * 64 + Long.numberOfTrailingZeros(bitset));
                    ++ac.cardinality;
                }
            }
            return ac;
        }
        BitmapContainer bc = new BitmapContainer(maxcardinality, this.bitmap);
        char s = this.select(maxcardinality);
        int usedwords = (s + 63) / 64;
        int todelete = this.bitmap.length - usedwords;
        for (int k = 0; k < todelete; ++k) {
            bc.bitmap[bc.bitmap.length - 1 - k] = 0L;
        }
        int lastword = s % 64;
        if (lastword != 0) {
            int n = s / 64;
            bc.bitmap[n] = bc.bitmap[n] & -1L >>> 64 - lastword;
        }
        return bc;
    }

    void loadData(ArrayContainer arrayContainer) {
        this.cardinality = arrayContainer.cardinality;
        for (int k = 0; k < arrayContainer.cardinality; ++k) {
            char x = arrayContainer.content[k];
            int n = x / 64;
            this.bitmap[n] = this.bitmap[n] | 1L << x;
        }
    }

    public int nextSetBit(int i) {
        int x = i >> 6;
        long w = this.bitmap[x];
        if ((w >>>= i) != 0L) {
            return i + Long.numberOfTrailingZeros(w);
        }
        ++x;
        while (x < this.bitmap.length) {
            if (this.bitmap[x] != 0L) {
                return x * 64 + Long.numberOfTrailingZeros(this.bitmap[x]);
            }
            ++x;
        }
        return -1;
    }

    private int nextClearBit(int i) {
        int x = i >> 6;
        long w = this.bitmap[x] ^ 0xFFFFFFFFFFFFFFFFL;
        if ((w >>>= i) != 0L) {
            return i + Long.numberOfTrailingZeros(w);
        }
        ++x;
        while (x < this.bitmap.length) {
            long map2 = this.bitmap[x] ^ 0xFFFFFFFFFFFFFFFFL;
            if (map2 != 0L) {
                return x * 64 + Long.numberOfTrailingZeros(map2);
            }
            ++x;
        }
        return 65536;
    }

    @Override
    public Container not(int firstOfRange, int lastOfRange) {
        BitmapContainer answer = this.clone();
        return answer.inot(firstOfRange, lastOfRange);
    }

    @Override
    int numberOfRuns() {
        int numRuns = 0;
        long nextWord = this.bitmap[0];
        for (int i = 0; i < this.bitmap.length - 1; ++i) {
            long word = nextWord;
            nextWord = this.bitmap[i + 1];
            numRuns += Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1) + (int)(word >>> 63 & (nextWord ^ 0xFFFFFFFFFFFFFFFFL));
        }
        long word = nextWord;
        numRuns += Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1);
        if ((word & Long.MIN_VALUE) != 0L) {
            ++numRuns;
        }
        return numRuns;
    }

    public int numberOfRunsAdjustment() {
        int ans = 0;
        long nextWord = this.bitmap[0];
        for (int i = 0; i < this.bitmap.length - 1; ++i) {
            long word = nextWord;
            nextWord = this.bitmap[i + 1];
            ans += (int)(word >>> 63 & (nextWord ^ 0xFFFFFFFFFFFFFFFFL));
        }
        long word = nextWord;
        if ((word & Long.MIN_VALUE) != 0L) {
            ++ans;
        }
        return ans;
    }

    public int numberOfRunsLowerBound(int mustNotExceed) {
        int numRuns = 0;
        int blockOffset = 0;
        while (blockOffset + 128 <= this.bitmap.length) {
            for (int i = blockOffset; i < blockOffset + 128; ++i) {
                long word = this.bitmap[i];
                numRuns += Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1);
            }
            if (numRuns > mustNotExceed) {
                return numRuns;
            }
            blockOffset += 128;
        }
        return numRuns;
    }

    @Override
    public Container or(ArrayContainer value2) {
        BitmapContainer answer = this.clone();
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            long aft;
            char v = value2.content[k];
            int i = v >>> 6;
            long w = answer.bitmap[i];
            answer.bitmap[i] = aft = w | 1L << v;
            answer.cardinality += (int)(w - aft >>> 63);
        }
        if (answer.isFull()) {
            return RunContainer.full();
        }
        return answer;
    }

    @Override
    public boolean isFull() {
        return this.cardinality == 65536;
    }

    @Override
    public Container or(BitmapContainer value2) {
        BitmapContainer value1 = this.clone();
        return value1.ior(value2);
    }

    @Override
    public Container or(RunContainer x) {
        return x.or(this);
    }

    int prevSetBit(int i) {
        int x = i >> 6;
        long w = this.bitmap[x];
        if ((w <<= 64 - i - 1) != 0L) {
            return i - Long.numberOfLeadingZeros(w);
        }
        --x;
        while (x >= 0) {
            if (this.bitmap[x] != 0L) {
                return x * 64 + 63 - Long.numberOfLeadingZeros(this.bitmap[x]);
            }
            --x;
        }
        return -1;
    }

    private int prevClearBit(int i) {
        int x = i >> 6;
        long w = this.bitmap[x] ^ 0xFFFFFFFFFFFFFFFFL;
        if ((w <<= 64 - (i + 1)) != 0L) {
            return i - Long.numberOfLeadingZeros(w);
        }
        --x;
        while (x >= 0) {
            long map2 = this.bitmap[x] ^ 0xFFFFFFFFFFFFFFFFL;
            if (map2 != 0L) {
                return x * 64 + 63 - Long.numberOfLeadingZeros(map2);
            }
            --x;
        }
        return -1;
    }

    @Override
    public int rank(char lowbits) {
        int leftover = lowbits + '\u0001' & 0x3F;
        int answer = 0;
        for (int k = 0; k < lowbits + '\u0001' >>> 6; ++k) {
            answer += Long.bitCount(this.bitmap[k]);
        }
        if (leftover != 0) {
            answer += Long.bitCount(this.bitmap[lowbits + '\u0001' >>> 6] << 64 - leftover);
        }
        return answer;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.deserialize(in);
    }

    @Override
    public Container remove(int begin, int end) {
        if (end == begin) {
            return this.clone();
        }
        if (begin > end || end > 65536) {
            throw new IllegalArgumentException("Invalid range [" + begin + "," + end + ")");
        }
        BitmapContainer answer = this.clone();
        int prevOnesInRange = answer.cardinalityInRange(begin, end);
        Util.resetBitmapRange(answer.bitmap, begin, end);
        answer.updateCardinality(prevOnesInRange, 0);
        if (answer.getCardinality() <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public Container remove(char i) {
        int index = i >>> 6;
        long bef = this.bitmap[index];
        long mask = 1L << i;
        if (this.cardinality == 4097 && (bef & mask) != 0L) {
            --this.cardinality;
            this.bitmap[i >>> 6] = bef & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            return this.toArrayContainer();
        }
        long aft = bef & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        this.cardinality = (int)((long)this.cardinality - (aft - bef >>> 63));
        this.bitmap[index] = aft;
        return this;
    }

    @Override
    public Container repairAfterLazy() {
        if (this.getCardinality() < 0) {
            this.computeCardinality();
            if (this.getCardinality() <= 4096) {
                return this.toArrayContainer();
            }
            if (this.isFull()) {
                return RunContainer.full();
            }
        }
        return this;
    }

    @Override
    public Container runOptimize() {
        int numRuns = this.numberOfRunsLowerBound(this.MAXRUNS);
        int sizeAsRunContainerLowerBound = RunContainer.serializedSizeInBytes(numRuns);
        if (sizeAsRunContainerLowerBound >= this.getArraySizeInBytes()) {
            return this;
        }
        int sizeAsRunContainer = RunContainer.serializedSizeInBytes(numRuns += this.numberOfRunsAdjustment());
        if (this.getArraySizeInBytes() > sizeAsRunContainer) {
            return new RunContainer(this, numRuns);
        }
        return this;
    }

    @Override
    public char select(int j) {
        int leftover = j;
        for (int k = 0; k < this.bitmap.length; ++k) {
            int w = Long.bitCount(this.bitmap[k]);
            if (w > leftover) {
                return (char)(k * 64 + Util.select(this.bitmap[k], leftover));
            }
            leftover -= w;
        }
        throw new IllegalArgumentException("Insufficient cardinality.");
    }

    @Override
    public void serialize(DataOutput out) throws IOException {
        for (long w : this.bitmap) {
            out.writeLong(Long.reverseBytes(w));
        }
    }

    @Override
    public int serializedSizeInBytes() {
        return BitmapContainer.serializedSizeInBytes(0);
    }

    ArrayContainer toArrayContainer() {
        ArrayContainer ac = new ArrayContainer(this.cardinality);
        if (this.cardinality != 0) {
            ac.loadData(this);
        }
        if (ac.getCardinality() != this.cardinality) {
            throw new RuntimeException("Internal error.");
        }
        return ac;
    }

    public LongBuffer toLongBuffer() {
        LongBuffer lb = LongBuffer.allocate(this.bitmap.length);
        lb.put(this.bitmap);
        return lb;
    }

    @Override
    public MappeableContainer toMappeableContainer() {
        return new MappeableBitmapContainer(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{}".length() + "-123456789,".length() * 256);
        PeekableCharIterator i = this.getCharIterator();
        sb.append('{');
        while (i.hasNext()) {
            sb.append((int)i.next());
            if (!i.hasNext()) continue;
            sb.append(',');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void trim() {
    }

    @Override
    public void writeArray(DataOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public void writeArray(ByteBuffer buffer) {
        assert (buffer.order() == ByteOrder.LITTLE_ENDIAN);
        LongBuffer buf = buffer.asLongBuffer();
        buf.put(this.bitmap);
        int bytesWritten = this.bitmap.length * 8;
        buffer.position(buffer.position() + bytesWritten);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public Container xor(ArrayContainer value2) {
        BitmapContainer answer = this.clone();
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            char vc = value2.content[k];
            int index = vc >>> 6;
            long mask = 1L << vc;
            long val = answer.bitmap[index];
            answer.cardinality += (int)(1L - 2L * ((val & mask) >>> vc));
            answer.bitmap[index] = val ^ mask;
        }
        if (answer.cardinality <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public Container xor(BitmapContainer value2) {
        int newCardinality = 0;
        for (int k = 0; k < this.bitmap.length; ++k) {
            newCardinality += Long.bitCount(this.bitmap[k] ^ value2.bitmap[k]);
        }
        if (newCardinality > 4096) {
            BitmapContainer answer = new BitmapContainer();
            for (int k = 0; k < answer.bitmap.length; ++k) {
                answer.bitmap[k] = this.bitmap[k] ^ value2.bitmap[k];
            }
            answer.cardinality = newCardinality;
            return answer;
        }
        ArrayContainer ac = new ArrayContainer(newCardinality);
        Util.fillArrayXOR(ac.content, this.bitmap, value2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public Container xor(RunContainer x) {
        return x.xor(this);
    }

    @Override
    public void forEach(char msb, IntConsumer ic) {
        int high = msb << 16;
        for (int x = 0; x < this.bitmap.length; ++x) {
            for (long w = this.bitmap[x]; w != 0L; w &= w - 1L) {
                ic.accept((x << 6) + Long.numberOfTrailingZeros(w) | high);
            }
        }
    }

    @Override
    public void forAll(int offset, RelativeRangeConsumer rrc) {
        for (int wordIndex = 0; wordIndex < this.bitmap.length; ++wordIndex) {
            long word = this.bitmap[wordIndex];
            int bufferWordStart = offset + (wordIndex << 6);
            int bufferWordEnd = bufferWordStart + 64;
            this.addWholeWordToRangeConsumer(word, bufferWordStart, bufferWordEnd, rrc);
        }
    }

    @Override
    public void forAllFrom(char startValue, RelativeRangeConsumer rrc) {
        int startIndex;
        for (int wordIndex = startIndex = startValue >>> 6; wordIndex < this.bitmap.length; ++wordIndex) {
            long word;
            int wordStart = wordIndex << 6;
            int wordEnd = wordStart + 64;
            if (wordStart < startValue) {
                if (word == 0L) {
                    rrc.acceptAllAbsent(0, wordEnd - startValue);
                    continue;
                }
                if (word == -1L) {
                    rrc.acceptAllPresent(0, wordEnd - startValue);
                    continue;
                }
                int nextPos = startValue;
                for (word = this.bitmap[wordIndex]; word != 0L; word &= word - 1L) {
                    int pos = wordStart + Long.numberOfTrailingZeros(word);
                    if (nextPos < pos) {
                        rrc.acceptAllAbsent(nextPos - startValue, pos - startValue);
                        rrc.acceptPresent(pos - startValue);
                        nextPos = pos + 1;
                        continue;
                    }
                    if (nextPos != pos) continue;
                    rrc.acceptPresent(pos - startValue);
                    ++nextPos;
                }
                if (nextPos >= wordEnd) continue;
                rrc.acceptAllAbsent(nextPos - startValue, wordEnd - startValue);
                continue;
            }
            this.addWholeWordToRangeConsumer(word, wordStart - startValue, wordEnd - startValue, rrc);
        }
    }

    @Override
    public void forAllUntil(int offset, char endValue, RelativeRangeConsumer rrc) {
        int bufferEndPos = offset + endValue;
        for (int wordIndex = 0; wordIndex < this.bitmap.length; ++wordIndex) {
            long word;
            int bufferWordStart = offset + (wordIndex << 6);
            int bufferWordEnd = bufferWordStart + 64;
            if (bufferWordStart >= bufferEndPos) {
                return;
            }
            if (bufferEndPos < bufferWordEnd) {
                if (word == 0L) {
                    rrc.acceptAllAbsent(bufferWordStart, bufferEndPos);
                    continue;
                }
                if (word == -1L) {
                    rrc.acceptAllPresent(bufferWordStart, bufferEndPos);
                    continue;
                }
                int nextPos = bufferWordStart;
                for (word = this.bitmap[wordIndex]; word != 0L; word &= word - 1L) {
                    int pos = bufferWordStart + Long.numberOfTrailingZeros(word);
                    if (bufferEndPos <= pos) {
                        if (nextPos < bufferEndPos) {
                            rrc.acceptAllAbsent(nextPos, bufferEndPos);
                        }
                        return;
                    }
                    if (nextPos < pos) {
                        rrc.acceptAllAbsent(nextPos, pos);
                        nextPos = pos;
                    }
                    rrc.acceptPresent(pos);
                    ++nextPos;
                }
                if (nextPos < bufferEndPos) {
                    rrc.acceptAllAbsent(nextPos, bufferEndPos);
                }
                return;
            }
            this.addWholeWordToRangeConsumer(word, bufferWordStart, bufferWordEnd, rrc);
        }
    }

    @Override
    public void forAllInRange(char startValue, char endValue, RelativeRangeConsumer rrc) {
        int startIndex;
        if (endValue <= startValue) {
            throw new IllegalArgumentException("startValue (" + (char)startValue + ") must be less than endValue (" + endValue + ")");
        }
        for (int wordIndex = startIndex = startValue >>> 6; wordIndex < this.bitmap.length; ++wordIndex) {
            int pos;
            int nextPos;
            boolean wordAllOnes;
            long word;
            int wordStart = wordIndex << 6;
            int wordEndExclusive = wordStart + 64;
            if (wordStart >= endValue) {
                return;
            }
            boolean startInWord = wordStart < startValue;
            boolean endInWord = endValue < wordEndExclusive;
            boolean wordAllZeroes = word == 0L;
            boolean bl = wordAllOnes = word == -1L;
            if (startInWord && endInWord) {
                if (wordAllZeroes) {
                    rrc.acceptAllAbsent(0, endValue - startValue);
                } else if (wordAllOnes) {
                    rrc.acceptAllPresent(0, endValue - startValue);
                } else {
                    nextPos = startValue;
                    for (word = this.bitmap[wordIndex]; word != 0L; word &= word - 1L) {
                        pos = wordStart + Long.numberOfTrailingZeros(word);
                        if (endValue <= pos) {
                            if (nextPos < endValue) {
                                rrc.acceptAllAbsent(nextPos - startValue, endValue - startValue);
                            }
                            return;
                        }
                        if (nextPos < pos) {
                            rrc.acceptAllAbsent(nextPos - startValue, pos - startValue);
                            rrc.acceptPresent(pos - startValue);
                            nextPos = pos + 1;
                            continue;
                        }
                        if (nextPos != pos) continue;
                        rrc.acceptPresent(pos - startValue);
                        ++nextPos;
                    }
                    if (nextPos < endValue) {
                        rrc.acceptAllAbsent(nextPos - startValue, endValue - startValue);
                    }
                }
                return;
            }
            if (startInWord) {
                if (wordAllZeroes) {
                    rrc.acceptAllAbsent(0, 64 - (startValue - wordStart));
                    continue;
                }
                if (wordAllOnes) {
                    rrc.acceptAllPresent(0, 64 - (startValue - wordStart));
                    continue;
                }
                nextPos = startValue;
                while (word != 0L) {
                    pos = wordStart + Long.numberOfTrailingZeros(word);
                    if (nextPos < pos) {
                        rrc.acceptAllAbsent(nextPos - startValue, pos - startValue);
                        rrc.acceptPresent(pos - startValue);
                        nextPos = pos + 1;
                    } else if (nextPos == pos) {
                        rrc.acceptPresent(pos - startValue);
                        ++nextPos;
                    }
                    word &= word - 1L;
                }
                if (nextPos >= wordEndExclusive) continue;
                rrc.acceptAllAbsent(nextPos - startValue, wordEndExclusive - startValue);
                continue;
            }
            if (endInWord) {
                if (wordAllZeroes) {
                    rrc.acceptAllAbsent(wordStart - startValue, endValue - startValue);
                } else if (wordAllOnes) {
                    rrc.acceptAllPresent(wordStart - startValue, endValue - startValue);
                } else {
                    nextPos = wordStart;
                    while (word != 0L) {
                        pos = wordStart + Long.numberOfTrailingZeros(word);
                        if (endValue <= pos) {
                            if (nextPos < endValue) {
                                rrc.acceptAllAbsent(nextPos - startValue, endValue - startValue);
                            }
                            return;
                        }
                        if (nextPos < pos) {
                            rrc.acceptAllAbsent(nextPos - startValue, pos - startValue);
                            nextPos = pos;
                        }
                        rrc.acceptPresent(pos - startValue);
                        ++nextPos;
                        word &= word - 1L;
                    }
                    if (nextPos < endValue) {
                        rrc.acceptAllAbsent(nextPos - startValue, endValue - startValue);
                    }
                }
                return;
            }
            this.addWholeWordToRangeConsumer(word, wordStart - startValue, wordEndExclusive - startValue, rrc);
        }
    }

    private void addWholeWordToRangeConsumer(long word, int bufferWordStart, int bufferWordEnd, RelativeRangeConsumer rrc) {
        if (word == 0L) {
            rrc.acceptAllAbsent(bufferWordStart, bufferWordEnd);
        } else if (word == -1L) {
            rrc.acceptAllPresent(bufferWordStart, bufferWordEnd);
        } else {
            int nextPos = bufferWordStart;
            while (word != 0L) {
                int pos = bufferWordStart + Long.numberOfTrailingZeros(word);
                if (nextPos < pos) {
                    rrc.acceptAllAbsent(nextPos, pos);
                    nextPos = pos;
                }
                rrc.acceptPresent(pos);
                ++nextPos;
                word &= word - 1L;
            }
            if (nextPos < bufferWordEnd) {
                rrc.acceptAllAbsent(nextPos, bufferWordEnd);
            }
        }
    }

    @Override
    public BitmapContainer toBitmapContainer() {
        return this;
    }

    @Override
    public int nextValue(char fromValue) {
        return this.nextSetBit(fromValue);
    }

    @Override
    public int previousValue(char fromValue) {
        return this.prevSetBit(fromValue);
    }

    @Override
    public int nextAbsentValue(char fromValue) {
        return this.nextClearBit(fromValue);
    }

    @Override
    public int previousAbsentValue(char fromValue) {
        return this.prevClearBit(fromValue);
    }

    @Override
    public int first() {
        int i;
        this.assertNonEmpty(this.cardinality == 0);
        for (i = 0; i < this.bitmap.length - 1 && this.bitmap[i] == 0L; ++i) {
        }
        return i * 64 + Long.numberOfTrailingZeros(this.bitmap[i]);
    }

    @Override
    public int last() {
        int i;
        this.assertNonEmpty(this.cardinality == 0);
        for (i = this.bitmap.length - 1; i > 0 && this.bitmap[i] == 0L; --i) {
        }
        return (i + 1) * 64 - Long.numberOfLeadingZeros(this.bitmap[i]) - 1;
    }
}

