/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.roaringbitmap;

import io.hops.hudi.org.roaringbitmap.BitmapContainer;
import io.hops.hudi.org.roaringbitmap.Container;
import io.hops.hudi.org.roaringbitmap.ContainerPointer;
import io.hops.hudi.org.roaringbitmap.RoaringArray;
import io.hops.hudi.org.roaringbitmap.RoaringBitmap;
import io.hops.hudi.org.roaringbitmap.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;

public final class FastAggregation {
    public static RoaringBitmap and(Iterator<? extends RoaringBitmap> bitmaps) {
        return FastAggregation.naive_and(bitmaps);
    }

    public static RoaringBitmap and(RoaringBitmap ... bitmaps) {
        if (bitmaps.length > 10) {
            return FastAggregation.workShyAnd(new long[1024], bitmaps);
        }
        return FastAggregation.naive_and(bitmaps);
    }

    public static RoaringBitmap and(long[] aggregationBuffer, RoaringBitmap ... bitmaps) {
        if (bitmaps.length > 10) {
            if (aggregationBuffer.length < 1024) {
                throw new IllegalArgumentException("buffer should have at least 1024 elements.");
            }
            try {
                RoaringBitmap roaringBitmap = FastAggregation.workShyAnd(aggregationBuffer, bitmaps);
                return roaringBitmap;
            }
            finally {
                Arrays.fill(aggregationBuffer, 0L);
            }
        }
        return FastAggregation.naive_and(bitmaps);
    }

    public static int andCardinality(RoaringBitmap ... bitmaps) {
        switch (bitmaps.length) {
            case 0: {
                return 0;
            }
            case 1: {
                return bitmaps[0].getCardinality();
            }
            case 2: {
                return RoaringBitmap.andCardinality(bitmaps[0], bitmaps[1]);
            }
        }
        return FastAggregation.workShyAndCardinality(bitmaps);
    }

    public static int orCardinality(RoaringBitmap ... bitmaps) {
        switch (bitmaps.length) {
            case 0: {
                return 0;
            }
            case 1: {
                return bitmaps[0].getCardinality();
            }
            case 2: {
                return RoaringBitmap.orCardinality(bitmaps[0], bitmaps[1]);
            }
        }
        return FastAggregation.horizontalOrCardinality(bitmaps);
    }

    @Deprecated
    public static RoaringBitmap horizontal_or(Iterator<? extends RoaringBitmap> bitmaps) {
        return FastAggregation.naive_or(bitmaps);
    }

    public static RoaringBitmap horizontal_or(List<? extends RoaringBitmap> bitmaps) {
        RoaringBitmap answer = new RoaringBitmap();
        if (bitmaps.isEmpty()) {
            return answer;
        }
        PriorityQueue<ContainerPointer> pq = new PriorityQueue<ContainerPointer>(bitmaps.size());
        for (int k = 0; k < bitmaps.size(); ++k) {
            ContainerPointer x = bitmaps.get((int)k).highLowContainer.getContainerPointer();
            if (x.getContainer() == null) continue;
            pq.add(x);
        }
        while (!pq.isEmpty()) {
            ContainerPointer x1 = (ContainerPointer)pq.poll();
            if (pq.isEmpty() || ((ContainerPointer)pq.peek()).key() != x1.key()) {
                answer.highLowContainer.append(x1.key(), x1.getContainer().clone());
                x1.advance();
                if (x1.getContainer() == null) continue;
                pq.add(x1);
                continue;
            }
            ContainerPointer x2 = (ContainerPointer)pq.poll();
            Container newc = x1.getContainer().lazyOR(x2.getContainer());
            while (!pq.isEmpty() && ((ContainerPointer)pq.peek()).key() == x1.key()) {
                ContainerPointer x = (ContainerPointer)pq.poll();
                newc = newc.lazyIOR(x.getContainer());
                x.advance();
                if (x.getContainer() != null) {
                    pq.add(x);
                    continue;
                }
                if (!pq.isEmpty()) continue;
                break;
            }
            newc = newc.repairAfterLazy();
            answer.highLowContainer.append(x1.key(), newc);
            x1.advance();
            if (x1.getContainer() != null) {
                pq.add(x1);
            }
            x2.advance();
            if (x2.getContainer() == null) continue;
            pq.add(x2);
        }
        return answer;
    }

    public static RoaringBitmap horizontal_or(RoaringBitmap ... bitmaps) {
        RoaringBitmap answer = new RoaringBitmap();
        if (bitmaps.length == 0) {
            return answer;
        }
        PriorityQueue<ContainerPointer> pq = new PriorityQueue<ContainerPointer>(bitmaps.length);
        for (int k = 0; k < bitmaps.length; ++k) {
            ContainerPointer x = bitmaps[k].highLowContainer.getContainerPointer();
            if (x.getContainer() == null) continue;
            pq.add(x);
        }
        while (!pq.isEmpty()) {
            ContainerPointer x1 = (ContainerPointer)pq.poll();
            if (pq.isEmpty() || ((ContainerPointer)pq.peek()).key() != x1.key()) {
                answer.highLowContainer.append(x1.key(), x1.getContainer().clone());
                x1.advance();
                if (x1.getContainer() == null) continue;
                pq.add(x1);
                continue;
            }
            ContainerPointer x2 = (ContainerPointer)pq.poll();
            Container newc = x1.getContainer().lazyOR(x2.getContainer());
            while (!pq.isEmpty() && ((ContainerPointer)pq.peek()).key() == x1.key()) {
                ContainerPointer x = (ContainerPointer)pq.poll();
                newc = newc.lazyIOR(x.getContainer());
                x.advance();
                if (x.getContainer() != null) {
                    pq.add(x);
                    continue;
                }
                if (!pq.isEmpty()) continue;
                break;
            }
            newc = newc.repairAfterLazy();
            answer.highLowContainer.append(x1.key(), newc);
            x1.advance();
            if (x1.getContainer() != null) {
                pq.add(x1);
            }
            x2.advance();
            if (x2.getContainer() == null) continue;
            pq.add(x2);
        }
        return answer;
    }

    public static RoaringBitmap horizontal_xor(RoaringBitmap ... bitmaps) {
        RoaringBitmap answer = new RoaringBitmap();
        if (bitmaps.length == 0) {
            return answer;
        }
        PriorityQueue<ContainerPointer> pq = new PriorityQueue<ContainerPointer>(bitmaps.length);
        for (int k = 0; k < bitmaps.length; ++k) {
            ContainerPointer x = bitmaps[k].highLowContainer.getContainerPointer();
            if (x.getContainer() == null) continue;
            pq.add(x);
        }
        while (!pq.isEmpty()) {
            ContainerPointer x1 = (ContainerPointer)pq.poll();
            if (pq.isEmpty() || ((ContainerPointer)pq.peek()).key() != x1.key()) {
                answer.highLowContainer.append(x1.key(), x1.getContainer().clone());
                x1.advance();
                if (x1.getContainer() == null) continue;
                pq.add(x1);
                continue;
            }
            ContainerPointer x2 = (ContainerPointer)pq.poll();
            Container newc = x1.getContainer().xor(x2.getContainer());
            while (!pq.isEmpty() && ((ContainerPointer)pq.peek()).key() == x1.key()) {
                ContainerPointer x = (ContainerPointer)pq.poll();
                newc = newc.ixor(x.getContainer());
                x.advance();
                if (x.getContainer() != null) {
                    pq.add(x);
                    continue;
                }
                if (!pq.isEmpty()) continue;
                break;
            }
            answer.highLowContainer.append(x1.key(), newc);
            x1.advance();
            if (x1.getContainer() != null) {
                pq.add(x1);
            }
            x2.advance();
            if (x2.getContainer() == null) continue;
            pq.add(x2);
        }
        return answer;
    }

    public static RoaringBitmap naive_and(Iterator<? extends RoaringBitmap> bitmaps) {
        if (!bitmaps.hasNext()) {
            return new RoaringBitmap();
        }
        RoaringBitmap answer = bitmaps.next().clone();
        while (bitmaps.hasNext() && !answer.isEmpty()) {
            answer.and(bitmaps.next());
        }
        return answer;
    }

    public static RoaringBitmap naive_and(RoaringBitmap ... bitmaps) {
        if (bitmaps.length == 0) {
            return new RoaringBitmap();
        }
        RoaringBitmap smallest = bitmaps[0];
        for (int i = 1; i < bitmaps.length; ++i) {
            RoaringBitmap bitmap = bitmaps[i];
            if (bitmap.highLowContainer.size() >= smallest.highLowContainer.size()) continue;
            smallest = bitmap;
        }
        RoaringBitmap answer = smallest.clone();
        for (int k = 0; k < bitmaps.length && !answer.isEmpty(); ++k) {
            if (bitmaps[k] == smallest) continue;
            answer.and(bitmaps[k]);
        }
        return answer;
    }

    public static RoaringBitmap workShyAnd(long[] buffer, RoaringBitmap ... bitmaps) {
        long[] words = buffer;
        RoaringBitmap first = bitmaps[0];
        for (int i = 0; i < first.highLowContainer.size; ++i) {
            char key = first.highLowContainer.keys[i];
            int n = key >>> 6;
            words[n] = words[n] | 1L << key;
        }
        int numContainers = first.highLowContainer.size;
        for (int i = 1; i < bitmaps.length && numContainers > 0; ++i) {
            numContainers = Util.intersectArrayIntoBitmap(words, bitmaps[i].highLowContainer.keys, bitmaps[i].highLowContainer.size);
        }
        if (numContainers == 0) {
            return new RoaringBitmap();
        }
        char[] keys2 = new char[numContainers];
        int base2 = 0;
        int pos = 0;
        long[] lArray = words;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            for (long word = lArray[i]; word != 0L; word &= word - 1L) {
                keys2[pos++] = (char)(base2 + Long.numberOfTrailingZeros(word));
            }
            base2 += 64;
        }
        Container[][] containers = new Container[numContainers][bitmaps.length];
        for (int i = 0; i < bitmaps.length; ++i) {
            RoaringBitmap bitmap = bitmaps[i];
            int position = 0;
            for (int j = 0; j < bitmap.highLowContainer.size; ++j) {
                char key = bitmap.highLowContainer.keys[j];
                if ((words[key >>> 6] & 1L << key) == 0L) continue;
                containers[position++][i] = bitmap.highLowContainer.values[j];
            }
        }
        RoaringArray array = new RoaringArray(keys2, new Container[numContainers], 0);
        for (int i = 0; i < numContainers; ++i) {
            Container[] slice = containers[i];
            Arrays.fill(words, -1L);
            Container tmp = new BitmapContainer(words, -1);
            for (Container container2 : slice) {
                Container and = tmp.iand(container2);
                if (and == tmp) continue;
                tmp = and;
            }
            if ((tmp = tmp.repairAfterLazy()).isEmpty()) continue;
            array.append(keys2[i], tmp instanceof BitmapContainer ? tmp.clone() : tmp);
        }
        return new RoaringBitmap(array);
    }

    private static int workShyAndCardinality(RoaringBitmap ... bitmaps) {
        long[] words = new long[1024];
        RoaringBitmap first = bitmaps[0];
        for (int i = 0; i < first.highLowContainer.size; ++i) {
            char key = first.highLowContainer.keys[i];
            int n = key >>> 6;
            words[n] = words[n] | 1L << key;
        }
        int numKeys = first.highLowContainer.size;
        for (int i = 1; i < bitmaps.length && numKeys > 0; ++i) {
            numKeys = Util.intersectArrayIntoBitmap(words, bitmaps[i].highLowContainer.keys, bitmaps[i].highLowContainer.size);
        }
        if (numKeys == 0) {
            return 0;
        }
        char[] keys2 = new char[numKeys];
        int base2 = 0;
        int pos = 0;
        long[] lArray = words;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            for (long word = lArray[i]; word != 0L; word &= word - 1L) {
                keys2[pos++] = (char)(base2 + Long.numberOfTrailingZeros(word));
            }
            base2 += 64;
        }
        int cardinality = 0;
        for (int i = 0; i < numKeys; ++i) {
            Arrays.fill(words, -1L);
            Container tmp = new BitmapContainer(words, -1);
            for (RoaringBitmap bitmap : bitmaps) {
                Container container2;
                Container and;
                int index = bitmap.highLowContainer.getIndex(keys2[i]);
                if (index < 0 || (and = tmp.iand(container2 = bitmap.highLowContainer.getContainerAtIndex(index))) == tmp) continue;
                tmp = and;
            }
            cardinality += ((Container)tmp).repairAfterLazy().getCardinality();
        }
        return cardinality;
    }

    private static int horizontalOrCardinality(RoaringBitmap ... bitmaps) {
        long[] words = new long[1024];
        int minKey = 65535;
        int maxKey = 0;
        for (RoaringBitmap bitmap : bitmaps) {
            for (int i = 0; i < bitmap.highLowContainer.size(); ++i) {
                char key = bitmap.highLowContainer.getKeyAtIndex(i);
                int n = key >>> 6;
                words[n] = words[n] | 1L << key;
                minKey = Math.min(minKey, key);
                maxKey = Math.max(maxKey, key);
            }
        }
        int numKeys = Util.cardinalityInBitmapRange(words, minKey, maxKey + 1);
        char[] keys2 = new char[numKeys];
        int base2 = 0;
        int pos = 0;
        long[] i = words;
        int n = i.length;
        for (int j = 0; j < n; ++j) {
            for (long word = i[j]; word != 0L; word &= word - 1L) {
                keys2[pos++] = (char)(base2 + Long.numberOfTrailingZeros(word));
            }
            base2 += 64;
        }
        int cardinality = 0;
        for (char key : keys2) {
            Arrays.fill(words, 0L);
            Container tmp = new BitmapContainer(words, -1);
            for (RoaringBitmap bitmap : bitmaps) {
                Container container2;
                Container or;
                int index = bitmap.highLowContainer.getIndex(key);
                if (index < 0 || (or = tmp.lazyIOR(container2 = bitmap.highLowContainer.getContainerAtIndex(index))) == tmp) continue;
                tmp = or;
            }
            cardinality += ((Container)tmp).repairAfterLazy().getCardinality();
        }
        return cardinality;
    }

    public static RoaringBitmap workAndMemoryShyAnd(long[] buffer, RoaringBitmap ... bitmaps) {
        if (buffer.length < 1024) {
            throw new IllegalArgumentException("buffer should have at least 1024 elements.");
        }
        long[] words = buffer;
        RoaringBitmap first = bitmaps[0];
        for (int i = 0; i < first.highLowContainer.size; ++i) {
            char key = first.highLowContainer.keys[i];
            int n = key >>> 6;
            words[n] = words[n] | 1L << key;
        }
        int numContainers = first.highLowContainer.size;
        for (int i = 1; i < bitmaps.length && numContainers > 0; ++i) {
            numContainers = Util.intersectArrayIntoBitmap(words, bitmaps[i].highLowContainer.keys, bitmaps[i].highLowContainer.size);
        }
        if (numContainers == 0) {
            return new RoaringBitmap();
        }
        char[] keys2 = new char[numContainers];
        int base2 = 0;
        int pos = 0;
        long[] lArray = words;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            for (long word = lArray[i]; word != 0L; word &= word - 1L) {
                keys2[pos++] = (char)(base2 + Long.numberOfTrailingZeros(word));
            }
            base2 += 64;
        }
        RoaringArray array = new RoaringArray(keys2, new Container[numContainers], 0);
        for (int i = 0; i < numContainers; ++i) {
            char MatchingKey = keys2[i];
            Arrays.fill(words, -1L);
            Container tmp = new BitmapContainer(words, -1);
            for (RoaringBitmap bitmap : bitmaps) {
                Container container2;
                Container and;
                int idx = bitmap.highLowContainer.getIndex(MatchingKey);
                if (idx < 0 || (and = tmp.iand(container2 = bitmap.highLowContainer.getContainerAtIndex(idx))) == tmp) continue;
                tmp = and;
            }
            if ((tmp = tmp.repairAfterLazy()).isEmpty()) continue;
            array.append(keys2[i], tmp instanceof BitmapContainer ? tmp.clone() : tmp);
        }
        return new RoaringBitmap(array);
    }

    public static RoaringBitmap naive_or(Iterator<? extends RoaringBitmap> bitmaps) {
        RoaringBitmap answer = new RoaringBitmap();
        while (bitmaps.hasNext()) {
            answer.naivelazyor(bitmaps.next());
        }
        answer.repairAfterLazy();
        return answer;
    }

    public static RoaringBitmap naive_or(RoaringBitmap ... bitmaps) {
        RoaringBitmap answer = new RoaringBitmap();
        for (int k = 0; k < bitmaps.length; ++k) {
            answer.naivelazyor(bitmaps[k]);
        }
        answer.repairAfterLazy();
        return answer;
    }

    public static RoaringBitmap naive_xor(Iterator<? extends RoaringBitmap> bitmaps) {
        RoaringBitmap answer = new RoaringBitmap();
        while (bitmaps.hasNext()) {
            answer.xor(bitmaps.next());
        }
        return answer;
    }

    public static RoaringBitmap naive_xor(RoaringBitmap ... bitmaps) {
        RoaringBitmap answer = new RoaringBitmap();
        for (int k = 0; k < bitmaps.length; ++k) {
            answer.xor(bitmaps[k]);
        }
        return answer;
    }

    public static RoaringBitmap or(Iterator<? extends RoaringBitmap> bitmaps) {
        return FastAggregation.naive_or(bitmaps);
    }

    public static RoaringBitmap or(RoaringBitmap ... bitmaps) {
        return FastAggregation.naive_or(bitmaps);
    }

    public static RoaringBitmap priorityqueue_or(Iterator<? extends RoaringBitmap> bitmaps) {
        if (!bitmaps.hasNext()) {
            return new RoaringBitmap();
        }
        ArrayList<RoaringBitmap> buffer = new ArrayList<RoaringBitmap>();
        while (bitmaps.hasNext()) {
            buffer.add(bitmaps.next());
        }
        final long[] sizes = new long[buffer.size()];
        boolean[] istmp = new boolean[buffer.size()];
        for (int k = 0; k < sizes.length; ++k) {
            sizes[k] = ((RoaringBitmap)buffer.get(k)).getLongSizeInBytes();
        }
        PriorityQueue<Integer> pq = new PriorityQueue<Integer>(128, new Comparator<Integer>(){

            @Override
            public int compare(Integer a, Integer b) {
                return (int)(sizes[a] - sizes[b]);
            }
        });
        for (int k = 0; k < sizes.length; ++k) {
            pq.add(k);
        }
        while (pq.size() > 1) {
            Integer x1 = pq.poll();
            Integer x2 = pq.poll();
            if (istmp[x2] && istmp[x1]) {
                buffer.set(x1, RoaringBitmap.lazyorfromlazyinputs((RoaringBitmap)buffer.get(x1), (RoaringBitmap)buffer.get(x2)));
                sizes[x1.intValue()] = ((RoaringBitmap)buffer.get(x1)).getLongSizeInBytes();
                istmp[x1.intValue()] = true;
                pq.add(x1);
                continue;
            }
            if (istmp[x2]) {
                ((RoaringBitmap)buffer.get(x2)).lazyor((RoaringBitmap)buffer.get(x1));
                sizes[x2.intValue()] = ((RoaringBitmap)buffer.get(x2)).getLongSizeInBytes();
                pq.add(x2);
                continue;
            }
            if (istmp[x1]) {
                ((RoaringBitmap)buffer.get(x1)).lazyor((RoaringBitmap)buffer.get(x2));
                sizes[x1.intValue()] = ((RoaringBitmap)buffer.get(x1)).getLongSizeInBytes();
                pq.add(x1);
                continue;
            }
            buffer.set(x1, RoaringBitmap.lazyor((RoaringBitmap)buffer.get(x1), (RoaringBitmap)buffer.get(x2)));
            sizes[x1.intValue()] = ((RoaringBitmap)buffer.get(x1)).getLongSizeInBytes();
            istmp[x1.intValue()] = true;
            pq.add(x1);
        }
        RoaringBitmap answer = (RoaringBitmap)buffer.get(pq.poll());
        answer.repairAfterLazy();
        return answer;
    }

    public static RoaringBitmap priorityqueue_or(RoaringBitmap ... bitmaps) {
        if (bitmaps.length == 0) {
            return new RoaringBitmap();
        }
        RoaringBitmap[] buffer = Arrays.copyOf(bitmaps, bitmaps.length);
        final long[] sizes = new long[buffer.length];
        boolean[] istmp = new boolean[buffer.length];
        for (int k = 0; k < sizes.length; ++k) {
            sizes[k] = buffer[k].getLongSizeInBytes();
        }
        PriorityQueue<Integer> pq = new PriorityQueue<Integer>(128, new Comparator<Integer>(){

            @Override
            public int compare(Integer a, Integer b) {
                return (int)(sizes[a] - sizes[b]);
            }
        });
        for (int k = 0; k < sizes.length; ++k) {
            pq.add(k);
        }
        while (pq.size() > 1) {
            Integer x1 = pq.poll();
            Integer x2 = pq.poll();
            if (istmp[x2] && istmp[x1]) {
                buffer[x1.intValue()] = RoaringBitmap.lazyorfromlazyinputs(buffer[x1], buffer[x2]);
                sizes[x1.intValue()] = buffer[x1].getLongSizeInBytes();
                istmp[x1.intValue()] = true;
                pq.add(x1);
                continue;
            }
            if (istmp[x2]) {
                buffer[x2].lazyor(buffer[x1]);
                sizes[x2.intValue()] = buffer[x2].getLongSizeInBytes();
                pq.add(x2);
                continue;
            }
            if (istmp[x1]) {
                buffer[x1].lazyor(buffer[x2]);
                sizes[x1.intValue()] = buffer[x1].getLongSizeInBytes();
                pq.add(x1);
                continue;
            }
            buffer[x1.intValue()] = RoaringBitmap.lazyor(buffer[x1], buffer[x2]);
            sizes[x1.intValue()] = buffer[x1].getLongSizeInBytes();
            istmp[x1.intValue()] = true;
            pq.add(x1);
        }
        RoaringBitmap answer = buffer[pq.poll()];
        answer.repairAfterLazy();
        return answer;
    }

    public static RoaringBitmap priorityqueue_xor(RoaringBitmap ... bitmaps) {
        if (bitmaps.length == 0) {
            return new RoaringBitmap();
        }
        PriorityQueue<RoaringBitmap> pq = new PriorityQueue<RoaringBitmap>(bitmaps.length, new Comparator<RoaringBitmap>(){

            @Override
            public int compare(RoaringBitmap a, RoaringBitmap b) {
                return (int)(a.getLongSizeInBytes() - b.getLongSizeInBytes());
            }
        });
        Collections.addAll(pq, bitmaps);
        while (pq.size() > 1) {
            RoaringBitmap x1 = pq.poll();
            RoaringBitmap x2 = pq.poll();
            pq.add(RoaringBitmap.xor(x1, x2));
        }
        return pq.poll();
    }

    public static RoaringBitmap xor(Iterator<? extends RoaringBitmap> bitmaps) {
        return FastAggregation.naive_xor(bitmaps);
    }

    public static RoaringBitmap xor(RoaringBitmap ... bitmaps) {
        return FastAggregation.naive_xor(bitmaps);
    }

    private FastAggregation() {
    }
}

