/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.roaringbitmap.longlong;

import io.hops.hudi.org.roaringbitmap.Container;
import io.hops.hudi.org.roaringbitmap.art.Art;
import io.hops.hudi.org.roaringbitmap.art.ContainerIterator;
import io.hops.hudi.org.roaringbitmap.art.Containers;
import io.hops.hudi.org.roaringbitmap.art.KeyIterator;
import io.hops.hudi.org.roaringbitmap.art.LeafNode;
import io.hops.hudi.org.roaringbitmap.art.LeafNodeIterator;
import io.hops.hudi.org.roaringbitmap.longlong.ContainerWithIndex;
import io.hops.hudi.org.roaringbitmap.longlong.LongUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.NoSuchElementException;

public class HighLowContainer {
    private Art art = new Art();
    private Containers containers = new Containers();
    private static final byte EMPTY_TAG = 0;
    private static final byte NOT_EMPTY_TAG = 1;

    public Container getContainer(long containerIdx) {
        return this.containers.getContainer(containerIdx);
    }

    public ContainerWithIndex searchContainer(byte[] highPart) {
        long containerIdx = this.art.findByKey(highPart);
        if (containerIdx < 0L) {
            return null;
        }
        Container container2 = this.containers.getContainer(containerIdx);
        return new ContainerWithIndex(container2, containerIdx);
    }

    public void put(byte[] highPart, Container container2) {
        long containerIdx = this.containers.addContainer(container2);
        this.art.insert(highPart, containerIdx);
    }

    public void remove(byte[] highPart) {
        long containerIdx = this.art.remove(highPart);
        if (containerIdx != -1L) {
            this.containers.remove(containerIdx);
        }
    }

    public ContainerIterator containerIterator() {
        return this.containers.iterator();
    }

    public KeyIterator highKeyIterator() {
        return this.art.iterator(this.containers);
    }

    public LeafNodeIterator highKeyLeafNodeIterator(boolean reverse) {
        return this.art.leafNodeIterator(reverse, this.containers);
    }

    public LeafNodeIterator highKeyLeafNodeIteratorFrom(long bound, boolean reverse) {
        return this.art.leafNodeIteratorFrom(bound, reverse, this.containers);
    }

    public void replaceContainer(long containerIdx, Container container2) {
        this.containers.replace(containerIdx, container2);
    }

    public boolean isEmpty() {
        return this.art.isEmpty();
    }

    private void assertNonEmpty() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("Empty " + this.getClass().getSimpleName());
        }
    }

    public long first() {
        this.assertNonEmpty();
        LeafNode firstNode = this.art.first();
        long containerIdx = firstNode.getContainerIdx();
        Container container2 = this.getContainer(containerIdx);
        byte[] high = firstNode.getKeyBytes();
        char low = (char)container2.first();
        return LongUtils.toLong(high, low);
    }

    public long last() {
        this.assertNonEmpty();
        LeafNode lastNode = this.art.last();
        long containerIdx = lastNode.getContainerIdx();
        Container container2 = this.getContainer(containerIdx);
        byte[] high = lastNode.getKeyBytes();
        char low = (char)container2.last();
        return LongUtils.toLong(high, low);
    }

    public void serialize(ByteBuffer buffer) throws IOException {
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2 = byteBuffer = buffer.order() == ByteOrder.LITTLE_ENDIAN ? buffer : buffer.slice().order(ByteOrder.LITTLE_ENDIAN);
        if (this.art.isEmpty()) {
            byteBuffer.put((byte)0);
            return;
        }
        byteBuffer.put((byte)1);
        this.art.serializeArt(byteBuffer);
        this.containers.serialize(byteBuffer);
        if (byteBuffer != buffer) {
            buffer.position(buffer.position() + byteBuffer.position());
        }
    }

    public void deserialize(ByteBuffer buffer) throws IOException {
        ByteBuffer byteBuffer = buffer.order() == ByteOrder.LITTLE_ENDIAN ? buffer : buffer.slice().order(ByteOrder.LITTLE_ENDIAN);
        this.clear();
        byte emptyTag = byteBuffer.get();
        if (emptyTag == 0) {
            return;
        }
        this.art.deserializeArt(byteBuffer);
        this.containers.deserialize(byteBuffer);
    }

    public long serializedSizeInBytes() {
        long totalSize = 1L;
        if (this.art.isEmpty()) {
            return totalSize;
        }
        totalSize += this.art.serializeSizeInBytes();
        return totalSize += this.containers.serializedSizeInBytes();
    }

    public void serialize(DataOutput dataOutput) throws IOException {
        if (this.art.isEmpty()) {
            dataOutput.writeByte(0);
            return;
        }
        dataOutput.writeByte(1);
        this.art.serializeArt(dataOutput);
        this.containers.serialize(dataOutput);
    }

    public void deserialize(DataInput dataInput) throws IOException {
        this.clear();
        byte emptyTag = dataInput.readByte();
        if (emptyTag == 0) {
            return;
        }
        this.art.deserializeArt(dataInput);
        this.containers.deserialize(dataInput);
    }

    public void clear() {
        this.art = new Art();
        this.containers = new Containers();
    }

    public int hashCode() {
        int hashCode2 = 0;
        KeyIterator keyIterator = this.highKeyIterator();
        while (keyIterator.hasNext()) {
            byte[] key = keyIterator.next();
            int result2 = 1;
            for (byte element : key) {
                result2 = 31 * result2 + element;
            }
            long containerIdx = keyIterator.currentContainerIdx();
            Container container2 = this.containers.getContainer(containerIdx);
            hashCode2 = 31 * hashCode2 + result2 + container2.hashCode();
        }
        return hashCode2;
    }

    public boolean equals(Object object) {
        if (object instanceof HighLowContainer) {
            HighLowContainer otherHighLowContainer = (HighLowContainer)object;
            if (this.art.getKeySize() != otherHighLowContainer.art.getKeySize()) {
                return false;
            }
            KeyIterator thisKeyIte = this.highKeyIterator();
            while (thisKeyIte.hasNext()) {
                byte[] thisHigh = thisKeyIte.next();
                long containerIdx = thisKeyIte.currentContainerIdx();
                Container thisContainer = this.getContainer(containerIdx);
                ContainerWithIndex containerWithIndex = otherHighLowContainer.searchContainer(thisHigh);
                if (containerWithIndex == null) {
                    return false;
                }
                Container otherContainer = containerWithIndex.getContainer();
                if (thisContainer.equals(otherContainer)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

