/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.plugin.rendering;

import io.javalin.core.util.JavalinLogger;
import io.javalin.http.Context;
import io.javalin.plugin.rendering.FileRenderer;
import io.javalin.plugin.rendering.JavalinRenderer;
import io.javalin.plugin.rendering.markdown.JavalinCommonmark;
import io.javalin.plugin.rendering.template.JavalinFreemarker;
import io.javalin.plugin.rendering.template.JavalinJte;
import io.javalin.plugin.rendering.template.JavalinMustache;
import io.javalin.plugin.rendering.template.JavalinPebble;
import io.javalin.plugin.rendering.template.JavalinThymeleaf;
import io.javalin.plugin.rendering.template.JavalinVelocity;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0012\"\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\u0013J,\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00062\u0006\u0010\u0017\u001a\u00020\u0005R,\u0010\u0003\u001a\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00060\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\u0007*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lio/javalin/plugin/rendering/JavalinRenderer;", "", "()V", "baseModelFunction", "Lkotlin/Function1;", "Lio/javalin/http/Context;", "", "", "extensions", "", "Lio/javalin/plugin/rendering/FileRenderer;", "extension", "getExtension", "(Ljava/lang/String;)Ljava/lang/String;", "register", "", "fileRenderer", "ext", "", "(Lio/javalin/plugin/rendering/FileRenderer;[Ljava/lang/String;)V", "renderBasedOnExtension", "filePath", "model", "ctx", "javalin"})
public final class JavalinRenderer {
    @NotNull
    public static final JavalinRenderer INSTANCE = new JavalinRenderer();
    @NotNull
    private static final Map<String, FileRenderer> extensions;
    @JvmField
    @NotNull
    public static Function1<? super Context, ? extends Map<String, ? extends Object>> baseModelFunction;

    private JavalinRenderer() {
    }

    @NotNull
    public final String renderBasedOnExtension(@NotNull String filePath, @NotNull Map<String, ? extends Object> model, @NotNull Context ctx) {
        Intrinsics.checkNotNullParameter(filePath, "filePath");
        Intrinsics.checkNotNullParameter(model, "model");
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Object object = extensions.get(this.getExtension(filePath));
        if (object == null) {
            throw new IllegalArgumentException("No Renderer registered for extension '" + this.getExtension(filePath) + "'.");
        }
        FileRenderer renderer = object;
        object = renderer.render(filePath, MapsKt.plus(baseModelFunction.invoke(ctx), model), ctx);
        Intrinsics.checkNotNullExpressionValue(object, "renderer.render(filePath\u2026nction(ctx) + model, ctx)");
        return object;
    }

    @JvmStatic
    public static final void register(@NotNull FileRenderer fileRenderer, String ... ext) {
        Intrinsics.checkNotNullParameter(fileRenderer, "fileRenderer");
        Intrinsics.checkNotNullParameter(ext, "ext");
        String[] $this$forEach$iv = ext;
        boolean $i$f$forEach = false;
        String[] stringArray = $this$forEach$iv;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = stringArray[i];
            boolean bl = false;
            if (extensions.get(it) != null) {
                StringBuilder stringBuilder = new StringBuilder().append('\'').append(it).append("' is already registered to ");
                FileRenderer fileRenderer2 = extensions.get(it);
                Intrinsics.checkNotNull(fileRenderer2);
                JavalinLogger.info$default(stringBuilder.append(fileRenderer2.getClass()).append(". Overriding.").toString(), null, 2, null);
            }
            Map<String, FileRenderer> map2 = extensions;
            boolean bl2 = false;
            map2.put(it, fileRenderer);
        }
    }

    private final String getExtension(String $this$extension) {
        return StringsKt.replaceBeforeLast$default($this$extension, ".", "", null, 4, null);
    }

    static {
        boolean bl = false;
        extensions = new LinkedHashMap();
        String[] stringArray = new String[]{".vm", ".vtl"};
        JavalinRenderer.register(JavalinVelocity.INSTANCE, stringArray);
        stringArray = new String[]{".ftl"};
        JavalinRenderer.register(JavalinFreemarker.INSTANCE, stringArray);
        stringArray = new String[]{".mustache"};
        JavalinRenderer.register(JavalinMustache.INSTANCE, stringArray);
        stringArray = new String[]{".peb", ".pebble"};
        JavalinRenderer.register(JavalinPebble.INSTANCE, stringArray);
        stringArray = new String[]{".html", ".tl", ".thyme", ".thymeleaf"};
        JavalinRenderer.register(JavalinThymeleaf.INSTANCE, stringArray);
        stringArray = new String[]{".md", ".markdown"};
        JavalinRenderer.register(JavalinCommonmark.INSTANCE, stringArray);
        stringArray = new String[]{".jte", ".kte"};
        JavalinRenderer.register(JavalinJte.INSTANCE, stringArray);
        baseModelFunction = baseModelFunction.1.INSTANCE;
    }
}

