/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.OptionalFailure;
import org.apache.flink.util.SerializedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class AccumulatorHelper {
    private static final Logger LOG = LoggerFactory.getLogger(AccumulatorHelper.class);

    public static void mergeInto(Map<String, OptionalFailure<Accumulator<?, ?>>> target, Map<String, Accumulator<?, ?>> toMerge) {
        for (Map.Entry<String, Accumulator<?, ?>> otherEntry : toMerge.entrySet()) {
            OptionalFailure<Accumulator<?, ?>> ownAccumulator = target.get(otherEntry.getKey());
            if (ownAccumulator == null) {
                target.put(otherEntry.getKey(), AccumulatorHelper.wrapUnchecked(otherEntry.getKey(), () -> ((Accumulator)otherEntry.getValue()).clone()));
                continue;
            }
            if (ownAccumulator.isFailure()) continue;
            Accumulator<?, ?> accumulator = ownAccumulator.getUnchecked();
            AccumulatorHelper.compareAccumulatorTypes(otherEntry.getKey(), accumulator.getClass(), otherEntry.getValue().getClass());
            target.put(otherEntry.getKey(), AccumulatorHelper.wrapUnchecked(otherEntry.getKey(), () -> AccumulatorHelper.mergeSingle(accumulator, ((Accumulator)otherEntry.getValue()).clone())));
        }
    }

    private static <V, R extends Serializable> Accumulator<V, R> mergeSingle(Accumulator<?, ?> target, Accumulator<?, ?> toMerge) {
        Accumulator<?, ?> typedTarget = target;
        Accumulator<?, ?> typedToMerge = toMerge;
        typedTarget.merge(typedToMerge);
        return typedTarget;
    }

    public static void compareAccumulatorTypes(Object name2, Class<? extends Accumulator> first, Class<? extends Accumulator> second) throws UnsupportedOperationException {
        if (first == null || second == null) {
            throw new NullPointerException();
        }
        if (first != second) {
            if (!first.getName().equals(second.getName())) {
                throw new UnsupportedOperationException("The accumulator object '" + name2 + "' was created with two different types: " + first.getName() + " and " + second.getName());
            }
            throw new UnsupportedOperationException("The accumulator object '" + name2 + "' was created with two different classes: " + first + " and " + second + " Both have the same type (" + first.getName() + ") but different classloaders: " + first.getClassLoader() + " and " + second.getClassLoader());
        }
    }

    public static Map<String, OptionalFailure<Object>> toResultMap(Map<String, Accumulator<?, ?>> accumulators) {
        HashMap<String, OptionalFailure<Object>> resultMap = new HashMap<String, OptionalFailure<Object>>();
        for (Map.Entry<String, Accumulator<?, ?>> entry : accumulators.entrySet()) {
            resultMap.put(entry.getKey(), AccumulatorHelper.wrapUnchecked(entry.getKey(), () -> ((Accumulator)entry.getValue()).getLocalValue()));
        }
        return resultMap;
    }

    private static <R> OptionalFailure<R> wrapUnchecked(String name2, Supplier<R> supplier) {
        return OptionalFailure.createFrom(() -> {
            try {
                return supplier.get();
            }
            catch (RuntimeException ex) {
                LOG.error("Unexpected error while handling accumulator [" + name2 + "]", (Throwable)ex);
                throw new FlinkException(ex);
            }
        });
    }

    public static String getResultsFormatted(Map<String, Object> map2) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Object> entry : map2.entrySet()) {
            builder.append("- ").append(entry.getKey()).append(" (").append(entry.getValue().getClass().getName()).append(")");
            if (entry.getValue() instanceof Collection) {
                builder.append(" [").append(((Collection)entry.getValue()).size()).append(" elements]");
            } else {
                builder.append(": ").append(entry.getValue().toString());
            }
            builder.append(System.lineSeparator());
        }
        return builder.toString();
    }

    public static Map<String, Accumulator<?, ?>> copy(Map<String, Accumulator<?, ?>> accumulators) {
        HashMap result2 = new HashMap();
        for (Map.Entry<String, Accumulator<?, ?>> entry : accumulators.entrySet()) {
            result2.put(entry.getKey(), entry.getValue().clone());
        }
        return result2;
    }

    public static Map<String, OptionalFailure<Object>> deserializeAccumulators(Map<String, SerializedValue<OptionalFailure<Object>>> serializedAccumulators, ClassLoader loader) throws IOException, ClassNotFoundException {
        if (serializedAccumulators == null || serializedAccumulators.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, OptionalFailure<Object>> accumulators = CollectionUtil.newHashMapWithExpectedSize(serializedAccumulators.size());
        for (Map.Entry<String, SerializedValue<OptionalFailure<Object>>> entry : serializedAccumulators.entrySet()) {
            OptionalFailure<Object> value = null;
            if (entry.getValue() != null) {
                value = entry.getValue().deserializeValue(loader);
            }
            accumulators.put(entry.getKey(), value);
        }
        return accumulators;
    }

    public static Map<String, Object> deserializeAndUnwrapAccumulators(Map<String, SerializedValue<OptionalFailure<Object>>> serializedAccumulators, ClassLoader loader) throws IOException, ClassNotFoundException {
        Map<String, OptionalFailure<Object>> deserializedAccumulators = AccumulatorHelper.deserializeAccumulators(serializedAccumulators, loader);
        if (deserializedAccumulators.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> accumulators = CollectionUtil.newHashMapWithExpectedSize(serializedAccumulators.size());
        for (Map.Entry<String, OptionalFailure<Object>> entry : deserializedAccumulators.entrySet()) {
            accumulators.put(entry.getKey(), entry.getValue().getUnchecked());
        }
        return accumulators;
    }
}

