/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.SimpleAccumulator;

@PublicEvolving
public class IntCounter
implements SimpleAccumulator<Integer> {
    private static final long serialVersionUID = 1L;
    private int localValue = 0;

    public IntCounter() {
    }

    public IntCounter(int value) {
        this.localValue = value;
    }

    @Override
    public void add(Integer value) {
        this.localValue += value.intValue();
    }

    @Override
    public Integer getLocalValue() {
        return this.localValue;
    }

    @Override
    public void merge(Accumulator<Integer, Integer> other) {
        this.localValue += other.getLocalValue().intValue();
    }

    @Override
    public void resetLocal() {
        this.localValue = 0;
    }

    public IntCounter clone() {
        IntCounter result2 = new IntCounter();
        result2.localValue = this.localValue;
        return result2;
    }

    @Override
    public void add(int value) {
        this.localValue += value;
    }

    public int getLocalValuePrimitive() {
        return this.localValue;
    }

    public String toString() {
        return "IntCounter " + this.localValue;
    }
}

