/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.accumulators.SimpleAccumulator;

@PublicEvolving
public class LongCounter
implements SimpleAccumulator<Long> {
    private static final long serialVersionUID = 1L;
    private long localValue;

    public LongCounter() {
    }

    public LongCounter(long value) {
        this.localValue = value;
    }

    @Override
    public void add(Long value) {
        this.localValue += value.longValue();
    }

    @Override
    public Long getLocalValue() {
        return this.localValue;
    }

    @Override
    public void merge(Accumulator<Long, Long> other) {
        this.localValue += other.getLocalValue().longValue();
    }

    @Override
    public void resetLocal() {
        this.localValue = 0L;
    }

    public LongCounter clone() {
        LongCounter result2 = new LongCounter();
        result2.localValue = this.localValue;
        return result2;
    }

    @Override
    public void add(long value) {
        this.localValue += value;
    }

    public long getLocalValuePrimitive() {
        return this.localValue;
    }

    public String toString() {
        return "LongCounter " + this.localValue;
    }
}

