/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.aggregators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.aggregators.Aggregator;
import org.apache.flink.api.common.aggregators.AggregatorWithName;
import org.apache.flink.api.common.aggregators.ConvergenceCriterion;
import org.apache.flink.types.Value;

@Internal
public class AggregatorRegistry {
    private final Map<String, Aggregator<?>> registry = new HashMap();
    private ConvergenceCriterion<? extends Value> convergenceCriterion;
    private String convergenceCriterionAggregatorName;

    public void registerAggregator(String name2, Aggregator<?> aggregator) {
        if (name2 == null || aggregator == null) {
            throw new IllegalArgumentException("Name and aggregator must not be null");
        }
        if (this.registry.containsKey(name2)) {
            throw new RuntimeException("An aggregator is already registered under the given name.");
        }
        this.registry.put(name2, aggregator);
    }

    public Collection<AggregatorWithName<?>> getAllRegisteredAggregators() {
        ArrayList list = new ArrayList(this.registry.size());
        for (Map.Entry<String, Aggregator<?>> entry : this.registry.entrySet()) {
            Aggregator<?> valAgg = entry.getValue();
            list.add(new AggregatorWithName(entry.getKey(), valAgg));
        }
        return list;
    }

    public <T extends Value> void registerAggregationConvergenceCriterion(String name2, Aggregator<T> aggregator, ConvergenceCriterion<T> convergenceCheck) {
        if (name2 == null || aggregator == null || convergenceCheck == null) {
            throw new IllegalArgumentException("Name, aggregator, or convergence criterion must not be null");
        }
        Aggregator<T> genAgg = aggregator;
        Aggregator<?> previous = this.registry.get(name2);
        if (previous != null && previous != genAgg) {
            throw new RuntimeException("An aggregator is already registered under the given name.");
        }
        this.registry.put(name2, genAgg);
        this.convergenceCriterion = convergenceCheck;
        this.convergenceCriterionAggregatorName = name2;
    }

    public String getConvergenceCriterionAggregatorName() {
        return this.convergenceCriterionAggregatorName;
    }

    public ConvergenceCriterion<?> getConvergenceCriterion() {
        return this.convergenceCriterion;
    }

    public void addAll(AggregatorRegistry registry) {
        this.registry.putAll(registry.registry);
        this.convergenceCriterion = registry.convergenceCriterion;
        this.convergenceCriterionAggregatorName = registry.convergenceCriterionAggregatorName;
    }
}

