/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.functions.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobInfo;
import org.apache.flink.api.common.JobInfoImpl;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.externalresource.ExternalResourceInfo;
import org.apache.flink.api.common.functions.BroadcastVariableInitializer;
import org.apache.flink.api.common.functions.util.AbstractRuntimeUDFContext;
import org.apache.flink.core.fs.Path;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.util.SimpleUserCodeClassLoader;

@Internal
public class RuntimeUDFContext
extends AbstractRuntimeUDFContext {
    private final HashMap<String, Object> initializedBroadcastVars = new HashMap();
    private final HashMap<String, List<?>> uninitializedBroadcastVars = new HashMap();

    @VisibleForTesting
    public RuntimeUDFContext(TaskInfo taskInfo, ClassLoader userCodeClassLoader, ExecutionConfig executionConfig, Map<String, Future<Path>> cpTasks, Map<String, Accumulator<?, ?>> accumulators, OperatorMetricGroup metrics) {
        this((JobInfo)new JobInfoImpl(new JobID(), "TestJob"), taskInfo, userCodeClassLoader, executionConfig, cpTasks, accumulators, metrics);
    }

    public RuntimeUDFContext(JobInfo jobInfo, TaskInfo taskInfo, ClassLoader userCodeClassLoader, ExecutionConfig executionConfig, Map<String, Future<Path>> cpTasks, Map<String, Accumulator<?, ?>> accumulators, OperatorMetricGroup metrics) {
        super(jobInfo, taskInfo, SimpleUserCodeClassLoader.create(userCodeClassLoader), executionConfig, accumulators, cpTasks, metrics);
    }

    @Override
    public boolean hasBroadcastVariable(String name2) {
        return this.initializedBroadcastVars.containsKey(name2) || this.uninitializedBroadcastVars.containsKey(name2);
    }

    @Override
    public <RT> List<RT> getBroadcastVariable(String name2) {
        Object o = this.initializedBroadcastVars.get(name2);
        if (o != null) {
            if (o instanceof List) {
                return (List)o;
            }
            throw new IllegalStateException("The broadcast variable with name '" + name2 + "' is not a List. A different call must have requested this variable with a BroadcastVariableInitializer.");
        }
        List<?> uninitialized = this.uninitializedBroadcastVars.remove(name2);
        if (uninitialized != null) {
            this.initializedBroadcastVars.put(name2, uninitialized);
            return uninitialized;
        }
        throw new IllegalArgumentException("The broadcast variable with name '" + name2 + "' has not been set.");
    }

    @Override
    public <T, C> C getBroadcastVariableWithInitializer(String name2, BroadcastVariableInitializer<T, C> initializer) {
        Object o = this.initializedBroadcastVars.get(name2);
        if (o != null) {
            return (C)o;
        }
        List<?> uninitialized = this.uninitializedBroadcastVars.remove(name2);
        if (uninitialized != null) {
            C result2 = initializer.initializeBroadcastVariable(uninitialized);
            this.initializedBroadcastVars.put(name2, result2);
            return result2;
        }
        throw new IllegalArgumentException("The broadcast variable with name '" + name2 + "' has not been set.");
    }

    @Override
    public Set<ExternalResourceInfo> getExternalResourceInfos(String resourceName) {
        throw new UnsupportedOperationException("Do not support external resource in current environment");
    }

    public void setBroadcastVariable(String name2, List<?> value) {
        this.uninitializedBroadcastVars.put(name2, value);
        this.initializedBroadcastVars.remove(name2);
    }

    public void clearBroadcastVariable(String name2) {
        this.uninitializedBroadcastVars.remove(name2);
        this.initializedBroadcastVars.remove(name2);
    }

    public void clearAllBroadcastVariables() {
        this.uninitializedBroadcastVars.clear();
        this.initializedBroadcastVars.clear();
    }
}

