/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class SlotSharingGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    @Nullable
    private final CPUResource cpuCores;
    @Nullable
    private final MemorySize taskHeapMemory;
    @Nullable
    private final MemorySize taskOffHeapMemory;
    @Nullable
    private final MemorySize managedMemory;
    private final Map<String, Double> externalResources = new HashMap<String, Double>();

    private SlotSharingGroup(String name2, CPUResource cpuCores, MemorySize taskHeapMemory, MemorySize taskOffHeapMemory, MemorySize managedMemory, Map<String, Double> extendedResources) {
        this.name = Preconditions.checkNotNull(name2);
        this.cpuCores = Preconditions.checkNotNull(cpuCores);
        this.taskHeapMemory = Preconditions.checkNotNull(taskHeapMemory);
        this.taskOffHeapMemory = Preconditions.checkNotNull(taskOffHeapMemory);
        this.managedMemory = Preconditions.checkNotNull(managedMemory);
        this.externalResources.putAll(Preconditions.checkNotNull(extendedResources));
    }

    private SlotSharingGroup(String name2) {
        this.name = Preconditions.checkNotNull(name2);
        this.cpuCores = null;
        this.taskHeapMemory = null;
        this.taskOffHeapMemory = null;
        this.managedMemory = null;
    }

    public String getName() {
        return this.name;
    }

    public Optional<MemorySize> getManagedMemory() {
        return Optional.ofNullable(this.managedMemory);
    }

    public Optional<MemorySize> getTaskHeapMemory() {
        return Optional.ofNullable(this.taskHeapMemory);
    }

    public Optional<MemorySize> getTaskOffHeapMemory() {
        return Optional.ofNullable(this.taskOffHeapMemory);
    }

    public Optional<Double> getCpuCores() {
        return Optional.ofNullable(this.cpuCores).map(cpuResource -> cpuResource.getValue().doubleValue());
    }

    public Map<String, Double> getExternalResources() {
        return Collections.unmodifiableMap(this.externalResources);
    }

    public static Builder newBuilder(String name2) {
        return new Builder(name2);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == SlotSharingGroup.class) {
            SlotSharingGroup that = (SlotSharingGroup)obj;
            return Objects.equals(this.cpuCores, that.cpuCores) && Objects.equals(this.taskHeapMemory, that.taskHeapMemory) && Objects.equals(this.taskOffHeapMemory, that.taskOffHeapMemory) && Objects.equals(this.managedMemory, that.managedMemory) && Objects.equals(this.externalResources, that.externalResources);
        }
        return false;
    }

    public int hashCode() {
        int result2 = Objects.hashCode(this.cpuCores);
        result2 = 31 * result2 + Objects.hashCode(this.taskHeapMemory);
        result2 = 31 * result2 + Objects.hashCode(this.taskOffHeapMemory);
        result2 = 31 * result2 + Objects.hashCode(this.managedMemory);
        result2 = 31 * result2 + this.externalResources.hashCode();
        return result2;
    }

    public static SlotSharingGroup from(org.apache.flink.api.common.SlotSharingGroup group) {
        if (group.getCpuCores() != null && group.getTaskHeapMemory() != null) {
            MemorySize taskOffHeapMemory = group.getTaskOffHeapMemory() == null ? MemorySize.ZERO : group.getTaskOffHeapMemory();
            MemorySize managedMemory = group.getManagedMemory() == null ? MemorySize.ZERO : group.getManagedMemory();
            return new SlotSharingGroup(group.getName(), new CPUResource(group.getCpuCores()), group.getTaskHeapMemory(), taskOffHeapMemory, managedMemory, group.getExternalResources());
        }
        if (group.getCpuCores() != null || group.getTaskHeapMemory() != null || group.getTaskOffHeapMemory() != null || group.getManagedMemory() != null || !group.getExternalResources().isEmpty()) {
            throw new IllegalArgumentException("The cpu cores and task heap memory are required when specifying the resource of a slot sharing group. You need to explicitly configure them with positive value.");
        }
        return new SlotSharingGroup(group.getName());
    }

    public static class Builder {
        private String name;
        private CPUResource cpuCores;
        private MemorySize taskHeapMemory;
        private MemorySize taskOffHeapMemory;
        private MemorySize managedMemory;
        private Map<String, Double> externalResources = new HashMap<String, Double>();

        private Builder(String name2) {
            this.name = name2;
        }

        public Builder setCpuCores(double cpuCores) {
            Preconditions.checkArgument(cpuCores > 0.0, "The cpu cores should be positive.");
            this.cpuCores = new CPUResource(cpuCores);
            return this;
        }

        public Builder setTaskHeapMemory(MemorySize taskHeapMemory) {
            Preconditions.checkArgument(taskHeapMemory.compareTo(MemorySize.ZERO) > 0, "The task heap memory should be positive.");
            this.taskHeapMemory = taskHeapMemory;
            return this;
        }

        public Builder setTaskHeapMemoryMB(int taskHeapMemoryMB) {
            Preconditions.checkArgument(taskHeapMemoryMB > 0, "The task heap memory should be positive.");
            this.taskHeapMemory = MemorySize.ofMebiBytes((long)taskHeapMemoryMB);
            return this;
        }

        public Builder setTaskOffHeapMemory(MemorySize taskOffHeapMemory) {
            this.taskOffHeapMemory = taskOffHeapMemory;
            return this;
        }

        public Builder setTaskOffHeapMemoryMB(int taskOffHeapMemoryMB) {
            this.taskOffHeapMemory = MemorySize.ofMebiBytes((long)taskOffHeapMemoryMB);
            return this;
        }

        public Builder setManagedMemory(MemorySize managedMemory) {
            this.managedMemory = managedMemory;
            return this;
        }

        public Builder setManagedMemoryMB(int managedMemoryMB) {
            this.managedMemory = MemorySize.ofMebiBytes((long)managedMemoryMB);
            return this;
        }

        public Builder setExternalResource(String name2, double value) {
            this.externalResources.put(name2, value);
            return this;
        }

        public SlotSharingGroup build() {
            if (this.cpuCores != null && this.taskHeapMemory != null) {
                this.taskOffHeapMemory = Optional.ofNullable(this.taskOffHeapMemory).orElse(MemorySize.ZERO);
                this.managedMemory = Optional.ofNullable(this.managedMemory).orElse(MemorySize.ZERO);
                return new SlotSharingGroup(this.name, this.cpuCores, this.taskHeapMemory, this.taskOffHeapMemory, this.managedMemory, this.externalResources);
            }
            if (this.cpuCores != null || this.taskHeapMemory != null || this.taskOffHeapMemory != null || this.managedMemory != null || !this.externalResources.isEmpty()) {
                throw new IllegalArgumentException("The cpu cores and task heap memory are required when specifying the resource of a slot sharing group. You need to explicitly configure them with positive value.");
            }
            return new SlotSharingGroup(this.name);
        }
    }
}

