/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.DualInputOperator;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.util.UserCodeClassWrapper;

@Internal
public class Union<T>
extends DualInputOperator<T, T, T, AbstractRichFunction> {
    public Union(BinaryOperatorInformation<T, T, T> operatorInfo, String unionLocationName) {
        super(new UserCodeClassWrapper<AbstractRichFunction>(AbstractRichFunction.class), operatorInfo, "Union at " + unionLocationName);
    }

    public Union(Operator<T> input1, Operator<T> input2, String unionLocationName) {
        this(new BinaryOperatorInformation<T, T, T>(input1.getOperatorInfo().getOutputType(), input1.getOperatorInfo().getOutputType(), input1.getOperatorInfo().getOutputType()), unionLocationName);
        this.setFirstInput(input1);
        this.setSecondInput(input2);
    }

    @Override
    protected List<T> executeOnCollections(List<T> inputData1, List<T> inputData2, RuntimeContext runtimeContext, ExecutionConfig executionConfig) {
        ArrayList<T> result2 = new ArrayList<T>(inputData1.size() + inputData2.size());
        result2.addAll(inputData1);
        result2.addAll(inputData2);
        return result2;
    }
}

