/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.CrossFunction;
import org.apache.flink.api.common.functions.DefaultOpenContext;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.DualInputOperator;
import org.apache.flink.api.common.operators.util.UserCodeClassWrapper;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.common.typeutils.TypeSerializer;

@Internal
public class CrossOperatorBase<IN1, IN2, OUT, FT extends CrossFunction<IN1, IN2, OUT>>
extends DualInputOperator<IN1, IN2, OUT, FT> {
    private CrossHint hint = CrossHint.OPTIMIZER_CHOOSES;

    public CrossOperatorBase(UserCodeWrapper<FT> udf, BinaryOperatorInformation<IN1, IN2, OUT> operatorInfo, String name2) {
        super(udf, operatorInfo, name2);
        if (this instanceof CrossWithSmall) {
            this.setCrossHint(CrossHint.SECOND_IS_SMALL);
        } else if (this instanceof CrossWithLarge) {
            this.setCrossHint(CrossHint.FIRST_IS_SMALL);
        }
    }

    public CrossOperatorBase(FT udf, BinaryOperatorInformation<IN1, IN2, OUT> operatorInfo, String name2) {
        this(new UserCodeObjectWrapper<FT>(udf), operatorInfo, name2);
    }

    public CrossOperatorBase(Class<? extends FT> udf, BinaryOperatorInformation<IN1, IN2, OUT> operatorInfo, String name2) {
        this(new UserCodeClassWrapper<FT>(udf), operatorInfo, name2);
    }

    public void setCrossHint(CrossHint hint) {
        this.hint = hint == null ? CrossHint.OPTIMIZER_CHOOSES : hint;
    }

    public CrossHint getCrossHint() {
        return this.hint;
    }

    @Override
    protected List<OUT> executeOnCollections(List<IN1> inputData1, List<IN2> inputData2, RuntimeContext ctx, ExecutionConfig executionConfig) throws Exception {
        CrossFunction function = (CrossFunction)this.userFunction.getUserCodeObject();
        FunctionUtils.setFunctionRuntimeContext(function, ctx);
        FunctionUtils.openFunction(function, DefaultOpenContext.INSTANCE);
        ArrayList result2 = new ArrayList(inputData1.size() * inputData2.size());
        TypeSerializer inSerializer1 = ((BinaryOperatorInformation)this.getOperatorInfo()).getFirstInputType().createSerializer(executionConfig.getSerializerConfig());
        TypeSerializer inSerializer2 = ((BinaryOperatorInformation)this.getOperatorInfo()).getSecondInputType().createSerializer(executionConfig.getSerializerConfig());
        TypeSerializer outSerializer = this.getOperatorInfo().getOutputType().createSerializer(executionConfig.getSerializerConfig());
        for (IN1 element1 : inputData1) {
            for (IN2 element2 : inputData2) {
                Object copy1 = inSerializer1.copy(element1);
                Object copy2 = inSerializer2.copy(element2);
                Object o = function.cross(copy1, copy2);
                result2.add(outSerializer.copy(o));
            }
        }
        FunctionUtils.closeFunction(function);
        return result2;
    }

    public static interface CrossWithLarge {
    }

    public static interface CrossWithSmall {
    }

    @Public
    public static enum CrossHint {
        OPTIMIZER_CHOOSES,
        FIRST_IS_SMALL,
        SECOND_IS_SMALL;

    }
}

