/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.aggregators.AggregatorRegistry;
import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.DualInputOperator;
import org.apache.flink.api.common.operators.IterationOperator;
import org.apache.flink.api.common.operators.Operator;
import org.apache.flink.api.common.operators.OperatorInformation;
import org.apache.flink.api.common.operators.util.UserCodeClassWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.util.Visitor;

@Internal
public class DeltaIterationBase<ST, WT>
extends DualInputOperator<ST, WT, ST, AbstractRichFunction>
implements IterationOperator {
    private final Operator<ST> solutionSetPlaceholder;
    private final Operator<WT> worksetPlaceholder;
    private Operator<ST> solutionSetDelta;
    private Operator<WT> nextWorkset;
    private final int[] solutionSetKeyFields;
    private int maxNumberOfIterations = -1;
    private final AggregatorRegistry aggregators = new AggregatorRegistry();
    private boolean solutionSetUnManaged;

    public DeltaIterationBase(BinaryOperatorInformation<ST, WT, ST> operatorInfo, int keyPosition) {
        this(operatorInfo, new int[]{keyPosition});
    }

    public DeltaIterationBase(BinaryOperatorInformation<ST, WT, ST> operatorInfo, int[] keyPositions) {
        this(operatorInfo, keyPositions, "<Unnamed Delta Iteration>");
    }

    public DeltaIterationBase(BinaryOperatorInformation<ST, WT, ST> operatorInfo, int keyPosition, String name2) {
        this(operatorInfo, new int[]{keyPosition}, name2);
    }

    public DeltaIterationBase(BinaryOperatorInformation<ST, WT, ST> operatorInfo, int[] keyPositions, String name2) {
        super(new UserCodeClassWrapper<AbstractRichFunction>(AbstractRichFunction.class), operatorInfo, name2);
        this.solutionSetKeyFields = keyPositions;
        this.solutionSetPlaceholder = new SolutionSetPlaceHolder<ST>(this, new OperatorInformation<ST>(operatorInfo.getFirstInputType()));
        this.worksetPlaceholder = new WorksetPlaceHolder<WT>(this, new OperatorInformation<WT>(operatorInfo.getSecondInputType()));
    }

    public int[] getSolutionSetKeyFields() {
        return this.solutionSetKeyFields;
    }

    public void setMaximumNumberOfIterations(int maxIterations) {
        this.maxNumberOfIterations = maxIterations;
    }

    public int getMaximumNumberOfIterations() {
        return this.maxNumberOfIterations;
    }

    @Override
    public AggregatorRegistry getAggregators() {
        return this.aggregators;
    }

    public Operator<ST> getSolutionSet() {
        return this.solutionSetPlaceholder;
    }

    public Operator<WT> getWorkset() {
        return this.worksetPlaceholder;
    }

    public void setNextWorkset(Operator<WT> result2) {
        this.nextWorkset = result2;
    }

    public Operator<WT> getNextWorkset() {
        return this.nextWorkset;
    }

    public void setSolutionSetDelta(Operator<ST> delta) {
        this.solutionSetDelta = delta;
    }

    public Operator<ST> getSolutionSetDelta() {
        return this.solutionSetDelta;
    }

    public Operator<ST> getInitialSolutionSet() {
        return this.getFirstInput();
    }

    public Operator<WT> getInitialWorkset() {
        return this.getSecondInput();
    }

    public void setInitialSolutionSet(Operator<ST> input) {
        this.setFirstInput(input);
    }

    public void setInitialWorkset(Operator<WT> input) {
        this.setSecondInput(input);
    }

    @Override
    public Map<String, Operator<?>> getBroadcastInputs() {
        return Collections.emptyMap();
    }

    @Override
    public void setBroadcastVariable(String name2, Operator<?> root) {
        throw new UnsupportedOperationException("The DeltaIteration meta operator cannot have broadcast inputs.");
    }

    @Override
    public <X> void setBroadcastVariables(Map<String, Operator<X>> inputs) {
        throw new UnsupportedOperationException("The DeltaIteration meta operator cannot have broadcast inputs.");
    }

    public void setSolutionSetUnManaged(boolean solutionSetUnManaged) {
        this.solutionSetUnManaged = solutionSetUnManaged;
    }

    public boolean isSolutionSetUnManaged() {
        return this.solutionSetUnManaged;
    }

    @Override
    protected List<ST> executeOnCollections(List<ST> inputData1, List<WT> inputData2, RuntimeContext runtimeContext, ExecutionConfig executionConfig) {
        throw new UnsupportedOperationException();
    }

    public static class SolutionSetPlaceHolder<ST>
    extends Operator<ST> {
        protected final DeltaIterationBase<ST, ?> containingIteration;

        public SolutionSetPlaceHolder(DeltaIterationBase<ST, ?> container2, OperatorInformation<ST> operatorInfo) {
            super(operatorInfo, "Solution Set");
            this.containingIteration = container2;
        }

        public DeltaIterationBase<ST, ?> getContainingWorksetIteration() {
            return this.containingIteration;
        }

        @Override
        public void accept(Visitor<Operator<?>> visitor2) {
            visitor2.preVisit(this);
            visitor2.postVisit(this);
        }

        @Override
        public UserCodeWrapper<?> getUserCodeWrapper() {
            return null;
        }
    }

    public static class WorksetPlaceHolder<WT>
    extends Operator<WT> {
        private final DeltaIterationBase<?, WT> containingIteration;

        public WorksetPlaceHolder(DeltaIterationBase<?, WT> container2, OperatorInformation<WT> operatorInfo) {
            super(operatorInfo, "Workset");
            this.containingIteration = container2;
        }

        public DeltaIterationBase<?, WT> getContainingWorksetIteration() {
            return this.containingIteration;
        }

        @Override
        public void accept(Visitor<Operator<?>> visitor2) {
            visitor2.preVisit(this);
            visitor2.postVisit(this);
        }

        @Override
        public UserCodeWrapper<?> getUserCodeWrapper() {
            return null;
        }
    }
}

