/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.DefaultOpenContext;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.CopyingListCollector;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.util.UserCodeClassWrapper;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.common.typeutils.TypeSerializer;

@Internal
public class FlatMapOperatorBase<IN, OUT, FT extends FlatMapFunction<IN, OUT>>
extends SingleInputOperator<IN, OUT, FT> {
    public FlatMapOperatorBase(UserCodeWrapper<FT> udf, UnaryOperatorInformation<IN, OUT> operatorInfo, String name2) {
        super(udf, operatorInfo, name2);
    }

    public FlatMapOperatorBase(FT udf, UnaryOperatorInformation<IN, OUT> operatorInfo, String name2) {
        super(new UserCodeObjectWrapper<FT>(udf), operatorInfo, name2);
    }

    public FlatMapOperatorBase(Class<? extends FT> udf, UnaryOperatorInformation<IN, OUT> operatorInfo, String name2) {
        super(new UserCodeClassWrapper<FT>(udf), operatorInfo, name2);
    }

    @Override
    protected List<OUT> executeOnCollections(List<IN> input, RuntimeContext ctx, ExecutionConfig executionConfig) throws Exception {
        FlatMapFunction function = (FlatMapFunction)this.userFunction.getUserCodeObject();
        FunctionUtils.setFunctionRuntimeContext(function, ctx);
        FunctionUtils.openFunction(function, DefaultOpenContext.INSTANCE);
        ArrayList result2 = new ArrayList(input.size());
        TypeSerializer inSerializer = ((UnaryOperatorInformation)this.getOperatorInfo()).getInputType().createSerializer(executionConfig.getSerializerConfig());
        TypeSerializer outSerializer = this.getOperatorInfo().getOutputType().createSerializer(executionConfig.getSerializerConfig());
        CopyingListCollector resultCollector = new CopyingListCollector(result2, outSerializer);
        for (IN element : input) {
            Object inCopy = inSerializer.copy(element);
            function.flatMap(inCopy, resultCollector);
        }
        FunctionUtils.closeFunction(function);
        return result2;
    }
}

