/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.functions.DefaultOpenContext;
import org.apache.flink.api.common.functions.GroupCombineFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.CopyingListCollector;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.operators.OperatorInformation;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.util.ListKeyGroupedIterator;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.Preconditions;

@Internal
public class GroupCombineOperatorBase<IN, OUT, FT extends GroupCombineFunction<IN, OUT>>
extends SingleInputOperator<IN, OUT, FT> {
    private Ordering groupOrder;

    public GroupCombineOperatorBase(FT udf, UnaryOperatorInformation<IN, OUT> operatorInfo, int[] keyPositions, String name2) {
        super(new UserCodeObjectWrapper<FT>(udf), operatorInfo, keyPositions, name2);
    }

    public void setGroupOrder(Ordering order) {
        this.groupOrder = order;
    }

    public Ordering getGroupOrder() {
        return this.groupOrder;
    }

    private TypeComparator<IN> getTypeComparator(TypeInformation<IN> typeInfo, int[] sortColumns, boolean[] sortOrderings, ExecutionConfig executionConfig) {
        if (typeInfo instanceof CompositeType) {
            return ((CompositeType)typeInfo).createComparator(sortColumns, sortOrderings, 0, executionConfig);
        }
        if (typeInfo instanceof AtomicType) {
            return ((AtomicType)((Object)typeInfo)).createComparator(sortOrderings[0], executionConfig);
        }
        throw new InvalidProgramException("Input type of GroupCombine must be one of composite types or atomic types.");
    }

    @Override
    protected List<OUT> executeOnCollections(List<IN> inputData, RuntimeContext ctx, ExecutionConfig executionConfig) throws Exception {
        int[] keyColumns;
        GroupCombineFunction function = (GroupCombineFunction)this.userFunction.getUserCodeObject();
        OperatorInformation operatorInfo = this.getOperatorInfo();
        TypeInformation inputType = ((UnaryOperatorInformation)operatorInfo).getInputType();
        int[] sortColumns = keyColumns = this.getKeyColumns(0);
        boolean[] sortOrderings = new boolean[sortColumns.length];
        if (this.groupOrder != null) {
            sortColumns = ArrayUtils.addAll((int[])sortColumns, (int[])this.groupOrder.getFieldPositions());
            sortOrderings = ArrayUtils.addAll((boolean[])sortOrderings, (boolean[])this.groupOrder.getFieldSortDirections());
        }
        if (sortColumns.length == 0) {
            Preconditions.checkArgument(sortOrderings.length == 0);
        } else {
            final TypeComparator sortComparator = this.getTypeComparator(inputType, sortColumns, sortOrderings, executionConfig);
            Collections.sort(inputData, new Comparator<IN>(){

                @Override
                public int compare(IN o1, IN o2) {
                    return sortComparator.compare(o1, o2);
                }
            });
        }
        FunctionUtils.setFunctionRuntimeContext(function, ctx);
        FunctionUtils.openFunction(function, DefaultOpenContext.INSTANCE);
        ArrayList result2 = new ArrayList();
        if (keyColumns.length == 0) {
            TypeSerializer inputSerializer = inputType.createSerializer(executionConfig.getSerializerConfig());
            TypeSerializer outSerializer = this.getOperatorInfo().getOutputType().createSerializer(executionConfig.getSerializerConfig());
            ArrayList inputDataCopy = new ArrayList(inputData.size());
            for (IN in : inputData) {
                inputDataCopy.add(inputSerializer.copy(in));
            }
            CopyingListCollector collector = new CopyingListCollector(result2, outSerializer);
            function.combine(inputDataCopy, collector);
        } else {
            TypeSerializer inputSerializer = inputType.createSerializer(executionConfig.getSerializerConfig());
            boolean[] keyOrderings = new boolean[keyColumns.length];
            TypeComparator comparator = this.getTypeComparator(inputType, keyColumns, keyOrderings, executionConfig);
            ListKeyGroupedIterator<IN> keyedIterator = new ListKeyGroupedIterator<IN>(inputData, inputSerializer, comparator);
            TypeSerializer outSerializer = this.getOperatorInfo().getOutputType().createSerializer(executionConfig.getSerializerConfig());
            CopyingListCollector collector = new CopyingListCollector(result2, outSerializer);
            while (keyedIterator.nextKey()) {
                function.combine(keyedIterator.getValues(), collector);
            }
        }
        FunctionUtils.closeFunction(function);
        return result2;
    }
}

