/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.DefaultOpenContext;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.CopyingListCollector;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.common.operators.util.UserCodeClassWrapper;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.GenericPairComparator;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;

@Internal
public class InnerJoinOperatorBase<IN1, IN2, OUT, FT extends FlatJoinFunction<IN1, IN2, OUT>>
extends JoinOperatorBase<IN1, IN2, OUT, FT> {
    public InnerJoinOperatorBase(UserCodeWrapper<FT> udf, BinaryOperatorInformation<IN1, IN2, OUT> operatorInfo, int[] keyPositions1, int[] keyPositions2, String name2) {
        super(udf, operatorInfo, keyPositions1, keyPositions2, name2);
    }

    public InnerJoinOperatorBase(FT udf, BinaryOperatorInformation<IN1, IN2, OUT> operatorInfo, int[] keyPositions1, int[] keyPositions2, String name2) {
        super(new UserCodeObjectWrapper<FT>(udf), operatorInfo, keyPositions1, keyPositions2, name2);
    }

    public InnerJoinOperatorBase(Class<? extends FT> udf, BinaryOperatorInformation<IN1, IN2, OUT> operatorInfo, int[] keyPositions1, int[] keyPositions2, String name2) {
        super(new UserCodeClassWrapper<FT>(udf), operatorInfo, keyPositions1, keyPositions2, name2);
    }

    @Override
    protected List<OUT> executeOnCollections(List<IN1> inputData1, List<IN2> inputData2, RuntimeContext runtimeContext, ExecutionConfig executionConfig) throws Exception {
        TypeComparator<IN2> rightComparator;
        boolean[] orders;
        int[] keyPositions;
        TypeComparator<Object> leftComparator;
        FlatJoinFunction function = (FlatJoinFunction)this.userFunction.getUserCodeObject();
        FunctionUtils.setFunctionRuntimeContext(function, runtimeContext);
        FunctionUtils.openFunction(function, DefaultOpenContext.INSTANCE);
        TypeInformation leftInformation = ((BinaryOperatorInformation)this.getOperatorInfo()).getFirstInputType();
        TypeInformation rightInformation = ((BinaryOperatorInformation)this.getOperatorInfo()).getSecondInputType();
        TypeInformation outInformation = this.getOperatorInfo().getOutputType();
        TypeSerializer leftSerializer = leftInformation.createSerializer(executionConfig.getSerializerConfig());
        TypeSerializer rightSerializer = rightInformation.createSerializer(executionConfig.getSerializerConfig());
        if (leftInformation instanceof AtomicType) {
            leftComparator = ((AtomicType)((Object)leftInformation)).createComparator(true, executionConfig);
        } else if (leftInformation instanceof CompositeType) {
            keyPositions = this.getKeyColumns(0);
            orders = new boolean[keyPositions.length];
            Arrays.fill(orders, true);
            leftComparator = ((CompositeType)leftInformation).createComparator(keyPositions, orders, 0, executionConfig);
        } else {
            throw new RuntimeException("Type information for left input of type " + leftInformation.getClass().getCanonicalName() + " is not supported. Could not generate a comparator.");
        }
        if (rightInformation instanceof AtomicType) {
            rightComparator = ((AtomicType)((Object)rightInformation)).createComparator(true, executionConfig);
        } else if (rightInformation instanceof CompositeType) {
            keyPositions = this.getKeyColumns(1);
            orders = new boolean[keyPositions.length];
            Arrays.fill(orders, true);
            rightComparator = ((CompositeType)rightInformation).createComparator(keyPositions, orders, 0, executionConfig);
        } else {
            throw new RuntimeException("Type information for right input of type " + rightInformation.getClass().getCanonicalName() + " is not supported. Could not generate a comparator.");
        }
        GenericPairComparator pairComparator = new GenericPairComparator(leftComparator, rightComparator);
        ArrayList result2 = new ArrayList();
        CopyingListCollector collector = new CopyingListCollector(result2, outInformation.createSerializer(executionConfig.getSerializerConfig()));
        HashMap<Integer, ArrayList<IN2>> probeTable = new HashMap<Integer, ArrayList<IN2>>();
        for (IN2 element : inputData2) {
            ArrayList<IN2> list = (ArrayList<IN2>)probeTable.get(rightComparator.hash(element));
            if (list == null) {
                list = new ArrayList<IN2>();
                probeTable.put(rightComparator.hash(element), list);
            }
            list.add(element);
        }
        for (Object left : inputData1) {
            List matchingHashes = (List)probeTable.get(leftComparator.hash(left));
            if (matchingHashes == null) continue;
            ((TypePairComparator)pairComparator).setReference(left);
            for (Object right : matchingHashes) {
                if (!((TypePairComparator)pairComparator).equalToReference(right)) continue;
                function.join(leftSerializer.copy(left), rightSerializer.copy(right), collector);
            }
        }
        FunctionUtils.closeFunction(function);
        return result2;
    }
}

