/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.ResettableIterator;
import org.apache.commons.collections.iterators.ListIteratorWrapper;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.DefaultOpenContext;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.CopyingListCollector;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.operators.BinaryOperatorInformation;
import org.apache.flink.api.common.operators.base.JoinOperatorBase;
import org.apache.flink.api.common.operators.util.ListKeyGroupedIterator;
import org.apache.flink.api.common.operators.util.UserCodeClassWrapper;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.operators.util.UserCodeWrapper;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.GenericPairComparator;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;

@Internal
public class OuterJoinOperatorBase<IN1, IN2, OUT, FT extends FlatJoinFunction<IN1, IN2, OUT>>
extends JoinOperatorBase<IN1, IN2, OUT, FT> {
    private OuterJoinType outerJoinType;

    public OuterJoinOperatorBase(UserCodeWrapper<FT> udf, BinaryOperatorInformation<IN1, IN2, OUT> operatorInfo, int[] keyPositions1, int[] keyPositions2, String name2, OuterJoinType outerJoinType) {
        super(udf, operatorInfo, keyPositions1, keyPositions2, name2);
        this.outerJoinType = outerJoinType;
    }

    public OuterJoinOperatorBase(FT udf, BinaryOperatorInformation<IN1, IN2, OUT> operatorInfo, int[] keyPositions1, int[] keyPositions2, String name2, OuterJoinType outerJoinType) {
        super(new UserCodeObjectWrapper<FT>(udf), operatorInfo, keyPositions1, keyPositions2, name2);
        this.outerJoinType = outerJoinType;
    }

    public OuterJoinOperatorBase(Class<? extends FT> udf, BinaryOperatorInformation<IN1, IN2, OUT> operatorInfo, int[] keyPositions1, int[] keyPositions2, String name2, OuterJoinType outerJoinType) {
        super(new UserCodeClassWrapper<FT>(udf), operatorInfo, keyPositions1, keyPositions2, name2);
        this.outerJoinType = outerJoinType;
    }

    public void setOuterJoinType(OuterJoinType outerJoinType) {
        this.outerJoinType = outerJoinType;
    }

    public OuterJoinType getOuterJoinType() {
        return this.outerJoinType;
    }

    @Override
    protected List<OUT> executeOnCollections(List<IN1> leftInput, List<IN2> rightInput, RuntimeContext runtimeContext, ExecutionConfig executionConfig) throws Exception {
        TypeInformation leftInformation = ((BinaryOperatorInformation)this.getOperatorInfo()).getFirstInputType();
        TypeInformation rightInformation = ((BinaryOperatorInformation)this.getOperatorInfo()).getSecondInputType();
        TypeInformation outInformation = this.getOperatorInfo().getOutputType();
        TypeComparator leftComparator = this.buildComparatorFor(0, executionConfig, leftInformation);
        TypeComparator rightComparator = this.buildComparatorFor(1, executionConfig, rightInformation);
        TypeSerializer leftSerializer = leftInformation.createSerializer(executionConfig.getSerializerConfig());
        TypeSerializer rightSerializer = rightInformation.createSerializer(executionConfig.getSerializerConfig());
        OuterJoinListIterator<IN1, IN2> outerJoinIterator = new OuterJoinListIterator<IN1, IN2>(leftInput, leftSerializer, leftComparator, rightInput, rightSerializer, rightComparator, this.outerJoinType);
        FlatJoinFunction function = (FlatJoinFunction)this.userFunction.getUserCodeObject();
        FunctionUtils.setFunctionRuntimeContext(function, runtimeContext);
        FunctionUtils.openFunction(function, DefaultOpenContext.INSTANCE);
        ArrayList result2 = new ArrayList();
        CopyingListCollector collector = new CopyingListCollector(result2, outInformation.createSerializer(executionConfig.getSerializerConfig()));
        while (((OuterJoinListIterator)outerJoinIterator).next()) {
            Object left = ((OuterJoinListIterator)outerJoinIterator).getLeft();
            Object right = ((OuterJoinListIterator)outerJoinIterator).getRight();
            function.join(left == null ? null : leftSerializer.copy(left), right == null ? null : rightSerializer.copy(right), collector);
        }
        FunctionUtils.closeFunction(function);
        return result2;
    }

    private <T> TypeComparator<T> buildComparatorFor(int input, ExecutionConfig executionConfig, TypeInformation<T> typeInformation) {
        TypeComparator comparator;
        if (typeInformation instanceof AtomicType) {
            comparator = ((AtomicType)((Object)typeInformation)).createComparator(true, executionConfig);
        } else if (typeInformation instanceof CompositeType) {
            int[] keyPositions = this.getKeyColumns(input);
            boolean[] orders = new boolean[keyPositions.length];
            Arrays.fill(orders, true);
            comparator = ((CompositeType)typeInformation).createComparator(keyPositions, orders, 0, executionConfig);
        } else {
            throw new RuntimeException("Type information for input of type " + typeInformation.getClass().getCanonicalName() + " is not supported. Could not generate a comparator.");
        }
        return comparator;
    }

    private static class OuterJoinListIterator<IN1, IN2> {
        private OuterJoinType outerJoinType;
        private ListKeyGroupedIterator<IN1> leftGroupedIterator;
        private ListKeyGroupedIterator<IN2> rightGroupedIterator;
        private Iterable<IN1> currLeftSubset;
        private ResettableIterator currLeftIterator;
        private Iterable<IN2> currRightSubset;
        private ResettableIterator currRightIterator;
        private MatchStatus matchStatus;
        private GenericPairComparator<IN1, IN2> pairComparator;
        private IN1 leftReturn;
        private IN2 rightReturn;

        public OuterJoinListIterator(List<IN1> leftInput, TypeSerializer<IN1> leftSerializer, final TypeComparator<IN1> leftComparator, List<IN2> rightInput, TypeSerializer<IN2> rightSerializer, final TypeComparator<IN2> rightComparator, OuterJoinType outerJoinType) {
            this.outerJoinType = outerJoinType;
            this.pairComparator = new GenericPairComparator<IN1, IN2>(leftComparator, rightComparator);
            this.leftGroupedIterator = new ListKeyGroupedIterator<IN1>(leftInput, leftSerializer, leftComparator);
            this.rightGroupedIterator = new ListKeyGroupedIterator<IN2>(rightInput, rightSerializer, rightComparator);
            Collections.sort(leftInput, new Comparator<IN1>(){

                @Override
                public int compare(IN1 o1, IN1 o2) {
                    return leftComparator.compare(o1, o2);
                }
            });
            Collections.sort(rightInput, new Comparator<IN2>(){

                @Override
                public int compare(IN2 o1, IN2 o2) {
                    return rightComparator.compare(o1, o2);
                }
            });
        }

        private boolean next() throws IOException {
            if (!(this.currLeftIterator != null && this.currLeftIterator.hasNext() || this.currRightIterator != null && this.currRightIterator.hasNext())) {
                boolean hasMoreElements = this.nextGroups(this.outerJoinType);
                if (hasMoreElements) {
                    if (this.outerJoinType != OuterJoinType.LEFT) {
                        this.currLeftIterator = new ListIteratorWrapper(this.currLeftSubset.iterator());
                    }
                    this.leftReturn = this.currLeftIterator.next();
                    if (this.outerJoinType != OuterJoinType.RIGHT) {
                        this.currRightIterator = new ListIteratorWrapper(this.currRightSubset.iterator());
                    }
                    this.rightReturn = this.currRightIterator.next();
                    return true;
                }
                return false;
            }
            if (this.currLeftIterator.hasNext() && !this.currRightIterator.hasNext()) {
                this.leftReturn = this.currLeftIterator.next();
                this.currRightIterator.reset();
                this.rightReturn = this.currRightIterator.next();
                return true;
            }
            this.rightReturn = this.currRightIterator.next();
            return true;
        }

        private boolean nextGroups(OuterJoinType outerJoinType) throws IOException {
            if (outerJoinType == OuterJoinType.FULL) {
                return this.nextGroups();
            }
            if (outerJoinType == OuterJoinType.LEFT) {
                boolean leftContainsElements = false;
                while (!leftContainsElements && this.nextGroups()) {
                    this.currLeftIterator = new ListIteratorWrapper(this.currLeftSubset.iterator());
                    if (this.currLeftIterator.next() != null) {
                        leftContainsElements = true;
                    }
                    this.currLeftIterator.reset();
                }
                return leftContainsElements;
            }
            if (outerJoinType == OuterJoinType.RIGHT) {
                boolean rightContainsElements = false;
                while (!rightContainsElements && this.nextGroups()) {
                    this.currRightIterator = new ListIteratorWrapper(this.currRightSubset.iterator());
                    if (this.currRightIterator.next() != null) {
                        rightContainsElements = true;
                    }
                    this.currRightIterator.reset();
                }
                return rightContainsElements;
            }
            throw new IllegalArgumentException("Outer join of type '" + (Object)((Object)outerJoinType) + "' not supported.");
        }

        private boolean nextGroups() throws IOException {
            boolean firstEmpty = true;
            boolean secondEmpty = true;
            if (this.matchStatus != MatchStatus.FIRST_EMPTY) {
                if (this.matchStatus == MatchStatus.FIRST_REMAINED) {
                    firstEmpty = false;
                } else if (this.leftGroupedIterator.nextKey()) {
                    this.pairComparator.setReference(this.leftGroupedIterator.getValues().getCurrent());
                    firstEmpty = false;
                }
            }
            if (this.matchStatus != MatchStatus.SECOND_EMPTY) {
                if (this.matchStatus == MatchStatus.SECOND_REMAINED) {
                    secondEmpty = false;
                } else if (this.rightGroupedIterator.nextKey()) {
                    secondEmpty = false;
                }
            }
            if (firstEmpty && secondEmpty) {
                return false;
            }
            if (firstEmpty && !secondEmpty) {
                this.currLeftSubset = Collections.singleton(null);
                this.currRightSubset = this.rightGroupedIterator.getValues();
                this.matchStatus = MatchStatus.FIRST_EMPTY;
                return true;
            }
            if (!firstEmpty && secondEmpty) {
                this.currLeftSubset = this.leftGroupedIterator.getValues();
                this.currRightSubset = Collections.singleton(null);
                this.matchStatus = MatchStatus.SECOND_EMPTY;
                return true;
            }
            int comp = this.pairComparator.compareToReference(this.rightGroupedIterator.getValues().getCurrent());
            if (0 == comp) {
                this.currLeftSubset = this.leftGroupedIterator.getValues();
                this.currRightSubset = this.rightGroupedIterator.getValues();
                this.matchStatus = MatchStatus.NONE_REMAINED;
            } else if (0 < comp) {
                this.currLeftSubset = this.leftGroupedIterator.getValues();
                this.currRightSubset = Collections.singleton(null);
                this.matchStatus = MatchStatus.SECOND_REMAINED;
            } else {
                this.currLeftSubset = Collections.singleton(null);
                this.currRightSubset = this.rightGroupedIterator.getValues();
                this.matchStatus = MatchStatus.FIRST_REMAINED;
            }
            return true;
        }

        private IN1 getLeft() {
            return this.leftReturn;
        }

        private IN2 getRight() {
            return this.rightReturn;
        }

        private static enum MatchStatus {
            NONE_REMAINED,
            FIRST_REMAINED,
            SECOND_REMAINED,
            FIRST_EMPTY,
            SECOND_EMPTY;

        }
    }

    public static enum OuterJoinType {
        LEFT,
        RIGHT,
        FULL;

    }
}

