/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators.base;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.NoOpFunction;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.SingleInputOperator;
import org.apache.flink.api.common.operators.SingleInputSemanticProperties;
import org.apache.flink.api.common.operators.UnaryOperatorInformation;
import org.apache.flink.api.common.operators.util.UserCodeObjectWrapper;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.common.typeutils.TypeComparator;

@Internal
public class SortPartitionOperatorBase<IN>
extends SingleInputOperator<IN, IN, NoOpFunction> {
    private final Ordering partitionOrdering;

    public SortPartitionOperatorBase(UnaryOperatorInformation<IN, IN> operatorInfo, Ordering partitionOrdering, String name2) {
        super(new UserCodeObjectWrapper<NoOpFunction>(new NoOpFunction()), operatorInfo, name2);
        this.partitionOrdering = partitionOrdering;
    }

    public Ordering getPartitionOrdering() {
        return this.partitionOrdering;
    }

    @Override
    public SingleInputSemanticProperties getSemanticProperties() {
        return new SingleInputSemanticProperties.AllFieldsForwardedProperties();
    }

    @Override
    protected List<IN> executeOnCollections(List<IN> inputData, RuntimeContext runtimeContext, ExecutionConfig executionConfig) {
        TypeComparator sortComparator;
        TypeInformation inputType = this.getInput().getOperatorInfo().getOutputType();
        int[] sortColumns = this.partitionOrdering.getFieldPositions();
        boolean[] sortOrderings = this.partitionOrdering.getFieldSortDirections();
        if (inputType instanceof CompositeType) {
            sortComparator = ((CompositeType)inputType).createComparator(sortColumns, sortOrderings, 0, executionConfig);
        } else if (inputType instanceof AtomicType) {
            sortComparator = ((AtomicType)((Object)inputType)).createComparator(sortOrderings[0], executionConfig);
        } else {
            throw new UnsupportedOperationException("Partition sorting does not support type " + inputType + " yet.");
        }
        Collections.sort(inputData, new Comparator<IN>(){

            @Override
            public int compare(IN o1, IN o2) {
                return sortComparator.compare(o1, o2);
            }
        });
        return inputData;
    }
}

