/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.restartstrategy;

import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.RestartStrategyOptions;

@Deprecated
@PublicEvolving
public class RestartStrategies {
    public static RestartStrategyConfiguration noRestart() {
        return new NoRestartStrategyConfiguration();
    }

    public static RestartStrategyConfiguration fallBackRestart() {
        return new FallbackRestartStrategyConfiguration();
    }

    public static RestartStrategyConfiguration fixedDelayRestart(int restartAttempts, long delayBetweenAttempts) {
        return RestartStrategies.fixedDelayRestart(restartAttempts, Time.of(delayBetweenAttempts, TimeUnit.MILLISECONDS));
    }

    @Deprecated
    public static RestartStrategyConfiguration fixedDelayRestart(int restartAttempts, Time delayInterval) {
        return RestartStrategies.fixedDelayRestart(restartAttempts, Time.toDuration(delayInterval));
    }

    public static RestartStrategyConfiguration fixedDelayRestart(int restartAttempts, Duration delayInterval) {
        return new FixedDelayRestartStrategyConfiguration(restartAttempts, delayInterval);
    }

    @Deprecated
    public static FailureRateRestartStrategyConfiguration failureRateRestart(int failureRate, Time failureInterval, Time delayInterval) {
        return RestartStrategies.failureRateRestart(failureRate, Time.toDuration(failureInterval), Time.toDuration(delayInterval));
    }

    public static FailureRateRestartStrategyConfiguration failureRateRestart(int failureRate, Duration failureInterval, Duration delayInterval) {
        return new FailureRateRestartStrategyConfiguration(failureRate, failureInterval, delayInterval);
    }

    @Deprecated
    public static ExponentialDelayRestartStrategyConfiguration exponentialDelayRestart(Time initialBackoff, Time maxBackoff, double backoffMultiplier, Time resetBackoffThreshold, double jitterFactor) {
        return RestartStrategies.exponentialDelayRestart(Time.toDuration(initialBackoff), Time.toDuration(maxBackoff), backoffMultiplier, Time.toDuration(resetBackoffThreshold), jitterFactor);
    }

    public static ExponentialDelayRestartStrategyConfiguration exponentialDelayRestart(Duration initialBackoff, Duration maxBackoff, double backoffMultiplier, Duration resetBackoffThreshold, double jitterFactor) {
        return new ExponentialDelayRestartStrategyConfiguration(initialBackoff, maxBackoff, backoffMultiplier, resetBackoffThreshold, jitterFactor);
    }

    public static Optional<RestartStrategyConfiguration> fromConfiguration(ReadableConfig configuration) {
        return configuration.getOptional(RestartStrategyOptions.RESTART_STRATEGY).map(confName -> RestartStrategies.parseConfiguration(confName, configuration));
    }

    private static RestartStrategyConfiguration parseConfiguration(String restartstrategyKind, ReadableConfig configuration) {
        switch (RestartStrategyOptions.RestartStrategyType.of(restartstrategyKind.toLowerCase())) {
            case NO_RESTART_STRATEGY: {
                return RestartStrategies.noRestart();
            }
            case FIXED_DELAY: {
                int attempts = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_ATTEMPTS);
                Duration delay = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_DELAY);
                return RestartStrategies.fixedDelayRestart(attempts, delay.toMillis());
            }
            case EXPONENTIAL_DELAY: {
                Duration initialBackoff = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_INITIAL_BACKOFF);
                Duration maxBackoff = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_MAX_BACKOFF);
                double backoffMultiplier = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_BACKOFF_MULTIPLIER);
                Duration resetBackoffThreshold = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_RESET_BACKOFF_THRESHOLD);
                double jitter = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_EXPONENTIAL_DELAY_JITTER_FACTOR);
                return RestartStrategies.exponentialDelayRestart(initialBackoff, maxBackoff, backoffMultiplier, resetBackoffThreshold, jitter);
            }
            case FAILURE_RATE: {
                int maxFailures = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_FAILURE_RATE_MAX_FAILURES_PER_INTERVAL);
                Duration failureRateInterval = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_FAILURE_RATE_FAILURE_RATE_INTERVAL);
                Duration failureRateDelay = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_FAILURE_RATE_DELAY);
                return RestartStrategies.failureRateRestart(maxFailures, Time.milliseconds(failureRateInterval.toMillis()), Time.milliseconds(failureRateDelay.toMillis()));
            }
        }
        throw new IllegalArgumentException("Unknown restart strategy " + restartstrategyKind + ".");
    }

    @PublicEvolving
    public static final class FallbackRestartStrategyConfiguration
    extends RestartStrategyConfiguration {
        private static final long serialVersionUID = -4441787204284085544L;

        @Override
        public String getDescription() {
            return "Cluster level default restart strategy";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof FallbackRestartStrategyConfiguration;
        }

        public int hashCode() {
            return Objects.hash(new Object[0]);
        }
    }

    @PublicEvolving
    public static final class FailureRateRestartStrategyConfiguration
    extends RestartStrategyConfiguration {
        private static final long serialVersionUID = 1195028697539661739L;
        private final int maxFailureRate;
        private final Duration failureInterval;
        private final Duration delayBetweenAttemptsInterval;

        @Deprecated
        public FailureRateRestartStrategyConfiguration(int maxFailureRate, Time failureInterval, Time delayBetweenAttemptsInterval) {
            this(maxFailureRate, Time.toDuration(failureInterval), Time.toDuration(delayBetweenAttemptsInterval));
        }

        public FailureRateRestartStrategyConfiguration(int maxFailureRate, Duration failureInterval, Duration delayBetweenAttemptsInterval) {
            this.maxFailureRate = maxFailureRate;
            this.failureInterval = failureInterval;
            this.delayBetweenAttemptsInterval = delayBetweenAttemptsInterval;
        }

        public int getMaxFailureRate() {
            return this.maxFailureRate;
        }

        @Deprecated
        public Time getFailureInterval() {
            return Time.fromDuration(this.getFailureIntervalDuration());
        }

        public Duration getFailureIntervalDuration() {
            return this.failureInterval;
        }

        @Deprecated
        public Time getDelayBetweenAttemptsInterval() {
            return Time.fromDuration(this.getDurationBetweenAttempts());
        }

        public Duration getDurationBetweenAttempts() {
            return this.delayBetweenAttemptsInterval;
        }

        @Override
        public String getDescription() {
            return String.format("Failure rate restart with maximum of %d failures within interval %s and fixed delay %s.", this.maxFailureRate, this.failureInterval.toString(), this.delayBetweenAttemptsInterval.toString());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FailureRateRestartStrategyConfiguration that = (FailureRateRestartStrategyConfiguration)o;
            return this.maxFailureRate == that.maxFailureRate && Objects.equals(this.failureInterval, that.failureInterval) && Objects.equals(this.delayBetweenAttemptsInterval, that.delayBetweenAttemptsInterval);
        }

        public int hashCode() {
            return Objects.hash(this.maxFailureRate, this.failureInterval, this.delayBetweenAttemptsInterval);
        }
    }

    @PublicEvolving
    public static final class ExponentialDelayRestartStrategyConfiguration
    extends RestartStrategyConfiguration {
        private static final long serialVersionUID = 1467941615941965194L;
        private final Duration initialBackoff;
        private final Duration maxBackoff;
        private final double backoffMultiplier;
        private final Duration resetBackoffThreshold;
        private final double jitterFactor;

        @Deprecated
        public ExponentialDelayRestartStrategyConfiguration(Time initialBackoff, Time maxBackoff, double backoffMultiplier, Time resetBackoffThreshold, double jitterFactor) {
            this(Time.toDuration(initialBackoff), Time.toDuration(maxBackoff), backoffMultiplier, Time.toDuration(resetBackoffThreshold), jitterFactor);
        }

        public ExponentialDelayRestartStrategyConfiguration(Duration initialBackoff, Duration maxBackoff, double backoffMultiplier, Duration resetBackoffThreshold, double jitterFactor) {
            this.initialBackoff = initialBackoff;
            this.maxBackoff = maxBackoff;
            this.backoffMultiplier = backoffMultiplier;
            this.resetBackoffThreshold = resetBackoffThreshold;
            this.jitterFactor = jitterFactor;
        }

        @Deprecated
        public Time getInitialBackoff() {
            return Time.fromDuration(this.getInitialBackoffDuration());
        }

        public Duration getInitialBackoffDuration() {
            return this.initialBackoff;
        }

        @Deprecated
        public Time getMaxBackoff() {
            return Time.fromDuration(this.maxBackoff);
        }

        public Duration getMaxBackoffDuration() {
            return this.maxBackoff;
        }

        public double getBackoffMultiplier() {
            return this.backoffMultiplier;
        }

        @Deprecated
        public Time getResetBackoffThreshold() {
            return Time.fromDuration(this.resetBackoffThreshold);
        }

        public Duration getResetBackoffDurationThreshold() {
            return this.resetBackoffThreshold;
        }

        public double getJitterFactor() {
            return this.jitterFactor;
        }

        @Override
        public String getDescription() {
            return String.format("Restart with exponential delay: starting at %s, increasing by %f, with maximum %s. Delay resets after %s with jitter %f", this.initialBackoff, this.backoffMultiplier, this.maxBackoff, this.resetBackoffThreshold, this.jitterFactor);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExponentialDelayRestartStrategyConfiguration that = (ExponentialDelayRestartStrategyConfiguration)o;
            return Double.compare(that.backoffMultiplier, this.backoffMultiplier) == 0 && Double.compare(that.jitterFactor, this.jitterFactor) == 0 && Objects.equals(this.initialBackoff, that.initialBackoff) && Objects.equals(this.maxBackoff, that.maxBackoff) && Objects.equals(this.resetBackoffThreshold, that.resetBackoffThreshold);
        }

        public int hashCode() {
            int result2 = this.initialBackoff.hashCode();
            result2 = 31 * result2 + this.maxBackoff.hashCode();
            result2 = 31 * result2 + (int)this.backoffMultiplier;
            result2 = 31 * result2 + this.resetBackoffThreshold.hashCode();
            result2 = 31 * result2 + (int)this.jitterFactor;
            return result2;
        }
    }

    @PublicEvolving
    public static final class FixedDelayRestartStrategyConfiguration
    extends RestartStrategyConfiguration {
        private static final long serialVersionUID = 4149870149673363190L;
        private final int restartAttempts;
        private final Duration delayBetweenAttemptsInterval;

        FixedDelayRestartStrategyConfiguration(int restartAttempts, Duration delayBetweenAttemptsInterval) {
            this.restartAttempts = restartAttempts;
            this.delayBetweenAttemptsInterval = delayBetweenAttemptsInterval;
        }

        public int getRestartAttempts() {
            return this.restartAttempts;
        }

        @Deprecated
        public Time getDelayBetweenAttemptsInterval() {
            return Time.fromDuration(this.getDurationBetweenAttempts());
        }

        public Duration getDurationBetweenAttempts() {
            return this.delayBetweenAttemptsInterval;
        }

        public int hashCode() {
            int result2 = this.restartAttempts;
            result2 = 31 * result2 + (this.delayBetweenAttemptsInterval != null ? this.delayBetweenAttemptsInterval.hashCode() : 0);
            return result2;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FixedDelayRestartStrategyConfiguration) {
                FixedDelayRestartStrategyConfiguration other = (FixedDelayRestartStrategyConfiguration)obj;
                return this.restartAttempts == other.restartAttempts && this.delayBetweenAttemptsInterval.equals(other.delayBetweenAttemptsInterval);
            }
            return false;
        }

        @Override
        public String getDescription() {
            return String.format("Restart with fixed delay (%s). #%d restart attempts.", this.delayBetweenAttemptsInterval, this.restartAttempts);
        }
    }

    @PublicEvolving
    public static final class NoRestartStrategyConfiguration
    extends RestartStrategyConfiguration {
        private static final long serialVersionUID = -5894362702943349962L;

        @Override
        public String getDescription() {
            return "Restart deactivated.";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof NoRestartStrategyConfiguration;
        }

        public int hashCode() {
            return Objects.hash(new Object[0]);
        }
    }

    @PublicEvolving
    public static abstract class RestartStrategyConfiguration
    implements Serializable {
        private static final long serialVersionUID = 6285853591578313960L;

        private RestartStrategyConfiguration() {
        }

        public abstract String getDescription();

        public String toString() {
            return this.getDescription();
        }
    }
}

