/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.serialization;

import io.hops.hudi.com.esotericsoftware.kryo.Serializer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInfoFactory;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TernaryBoolean;

@Internal
public final class SerializerConfigImpl
implements SerializerConfig {
    private static final long serialVersionUID = 1L;
    private final Configuration configuration;
    private final ExecutionConfig executionConfig;
    private LinkedHashMap<Class<?>, ExecutionConfig.SerializableSerializer<?>> registeredTypesWithKryoSerializers = new LinkedHashMap();
    private LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> registeredTypesWithKryoSerializerClasses = new LinkedHashMap();
    private LinkedHashMap<Class<?>, ExecutionConfig.SerializableSerializer<?>> defaultKryoSerializers = new LinkedHashMap();
    private LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> defaultKryoSerializerClasses = new LinkedHashMap();
    private LinkedHashSet<Class<?>> registeredKryoTypes = new LinkedHashSet();
    private LinkedHashSet<Class<?>> registeredPojoTypes = new LinkedHashSet();
    private Map<Class<?>, Class<? extends TypeInfoFactory<?>>> registeredTypeInfoFactories = new HashMap();

    public SerializerConfigImpl() {
        Configuration conf;
        this.configuration = conf = new Configuration();
        this.executionConfig = new ExecutionConfig(conf);
    }

    @Internal
    public SerializerConfigImpl(Configuration configuration, ExecutionConfig executionConfig) {
        this.configuration = configuration;
        this.executionConfig = executionConfig;
    }

    @Override
    public <T extends Serializer<?>> void addDefaultKryoSerializer(Class<?> type2, T serializer) {
        if (type2 == null || serializer == null) {
            throw new NullPointerException("Cannot register null class or serializer.");
        }
        this.defaultKryoSerializers.put(type2, new ExecutionConfig.SerializableSerializer<T>(serializer));
    }

    @Override
    public void addDefaultKryoSerializer(Class<?> type2, Class<? extends Serializer<?>> serializerClass) {
        if (type2 == null || serializerClass == null) {
            throw new NullPointerException("Cannot register null class or serializer.");
        }
        this.defaultKryoSerializerClasses.put(type2, serializerClass);
    }

    @Override
    public <T extends Serializer<?>> void registerTypeWithKryoSerializer(Class<?> type2, T serializer) {
        if (type2 == null || serializer == null) {
            throw new NullPointerException("Cannot register null class or serializer.");
        }
        this.registeredTypesWithKryoSerializers.put(type2, new ExecutionConfig.SerializableSerializer<T>(serializer));
    }

    @Override
    public void registerTypeWithKryoSerializer(Class<?> type2, Class<? extends Serializer> serializerClass) {
        if (type2 == null || serializerClass == null) {
            throw new NullPointerException("Cannot register null class or serializer.");
        }
        Class<? extends Serializer> castedSerializerClass = serializerClass;
        this.registeredTypesWithKryoSerializerClasses.put(type2, castedSerializerClass);
    }

    @Override
    public void registerPojoType(Class<?> type2) {
        if (type2 == null) {
            throw new NullPointerException("Cannot register null type class.");
        }
        this.registeredPojoTypes.add(type2);
    }

    @Override
    public void registerKryoType(Class<?> type2) {
        if (type2 == null) {
            throw new NullPointerException("Cannot register null type class.");
        }
        this.registeredKryoTypes.add(type2);
    }

    @Override
    public LinkedHashMap<Class<?>, ExecutionConfig.SerializableSerializer<?>> getRegisteredTypesWithKryoSerializers() {
        return this.registeredTypesWithKryoSerializers;
    }

    @Override
    public LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> getRegisteredTypesWithKryoSerializerClasses() {
        return this.registeredTypesWithKryoSerializerClasses;
    }

    @Override
    public LinkedHashMap<Class<?>, ExecutionConfig.SerializableSerializer<?>> getDefaultKryoSerializers() {
        return this.defaultKryoSerializers;
    }

    @Override
    public LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> getDefaultKryoSerializerClasses() {
        return this.defaultKryoSerializerClasses;
    }

    @Override
    public LinkedHashSet<Class<?>> getRegisteredKryoTypes() {
        if (this.isForceKryoEnabled()) {
            LinkedHashSet result2 = new LinkedHashSet(this.registeredKryoTypes);
            result2.addAll(this.registeredPojoTypes);
            return result2;
        }
        return this.registeredKryoTypes;
    }

    @Override
    public LinkedHashSet<Class<?>> getRegisteredPojoTypes() {
        return this.registeredPojoTypes;
    }

    @Override
    public Map<Class<?>, Class<? extends TypeInfoFactory<?>>> getRegisteredTypeInfoFactories() {
        return this.registeredTypeInfoFactories;
    }

    @Override
    public boolean hasGenericTypesDisabled() {
        return this.configuration.get(PipelineOptions.GENERIC_TYPES) == false;
    }

    @Override
    public void setGenericTypes(boolean genericTypes) {
        this.configuration.set((ConfigOption)PipelineOptions.GENERIC_TYPES, (Object)genericTypes);
    }

    @Override
    public boolean isForceKryoEnabled() {
        return this.configuration.get(PipelineOptions.FORCE_KRYO);
    }

    @Override
    public void setForceKryo(boolean forceKryo) {
        this.configuration.set((ConfigOption)PipelineOptions.FORCE_KRYO, (Object)forceKryo);
    }

    @Override
    public boolean isForceAvroEnabled() {
        return this.configuration.get(PipelineOptions.FORCE_AVRO);
    }

    @Override
    public void setForceAvro(boolean forceAvro) {
        this.configuration.set((ConfigOption)PipelineOptions.FORCE_AVRO, (Object)forceAvro);
    }

    @Override
    public void setForceKryoAvro(boolean forceKryoAvro) {
        this.configuration.set((ConfigOption)PipelineOptions.FORCE_KRYO_AVRO, (Object)forceKryoAvro);
    }

    @Override
    public TernaryBoolean isForceKryoAvroEnabled() {
        return this.configuration.getOptional(PipelineOptions.FORCE_KRYO_AVRO).map(TernaryBoolean::fromBoolean).orElse(TernaryBoolean.UNDEFINED);
    }

    public boolean equals(Object obj) {
        if (obj instanceof SerializerConfigImpl) {
            SerializerConfigImpl other = (SerializerConfigImpl)obj;
            return Objects.equals(this.configuration, other.configuration) && this.registeredTypesWithKryoSerializers.equals(other.registeredTypesWithKryoSerializers) && this.registeredTypesWithKryoSerializerClasses.equals(other.registeredTypesWithKryoSerializerClasses) && this.defaultKryoSerializers.equals(other.defaultKryoSerializers) && this.defaultKryoSerializerClasses.equals(other.defaultKryoSerializerClasses) && this.registeredKryoTypes.equals(other.registeredKryoTypes) && this.registeredPojoTypes.equals(other.registeredPojoTypes) && this.registeredTypeInfoFactories.equals(other.registeredTypeInfoFactories);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.configuration, this.registeredTypesWithKryoSerializers, this.registeredTypesWithKryoSerializerClasses, this.defaultKryoSerializers, this.defaultKryoSerializerClasses, this.registeredKryoTypes, this.registeredPojoTypes, this.registeredTypeInfoFactories);
    }

    public String toString() {
        return "SerializerConfig{configuration=" + this.configuration + ", registeredTypesWithKryoSerializers=" + this.registeredTypesWithKryoSerializers + ", registeredTypesWithKryoSerializerClasses=" + this.registeredTypesWithKryoSerializerClasses + ", defaultKryoSerializers=" + this.defaultKryoSerializers + ", defaultKryoSerializerClasses=" + this.defaultKryoSerializerClasses + ", registeredKryoTypes=" + this.registeredKryoTypes + ", registeredPojoTypes=" + this.registeredPojoTypes + ", registeredTypeFactories=" + this.registeredTypeInfoFactories + '}';
    }

    @Override
    public void configure(ReadableConfig configuration, ClassLoader classLoader2) {
        configuration.getOptional(PipelineOptions.GENERIC_TYPES).ifPresent(this::setGenericTypes);
        configuration.getOptional(PipelineOptions.FORCE_KRYO).ifPresent(this::setForceKryo);
        configuration.getOptional(PipelineOptions.FORCE_AVRO).ifPresent(this::setForceAvro);
        configuration.getOptional(PipelineOptions.FORCE_KRYO_AVRO).ifPresent(this::setForceKryoAvro);
        configuration.getOptional(PipelineOptions.KRYO_DEFAULT_SERIALIZERS).map(s -> this.parseKryoSerializersWithExceptionHandling(classLoader2, (List<String>)s)).ifPresent(s -> {
            this.defaultKryoSerializerClasses = s;
        });
        configuration.getOptional(PipelineOptions.POJO_REGISTERED_CLASSES).map(c -> this.loadClasses((List<String>)c, classLoader2, "Could not load pojo type to be registered.")).ifPresent(c -> {
            this.registeredPojoTypes = c;
        });
        configuration.getOptional(PipelineOptions.KRYO_REGISTERED_CLASSES).map(c -> this.loadClasses((List<String>)c, classLoader2, "Could not load kryo type to be registered.")).ifPresent(c -> {
            this.registeredKryoTypes = c;
        });
        try {
            configuration.getOptional(PipelineOptions.SERIALIZATION_CONFIG).ifPresent(c -> this.parseSerializationConfigWithExceptionHandling(classLoader2, (List<String>)c));
        }
        catch (Exception e) {
            if (!GlobalConfiguration.isStandardYaml()) {
                throw new UnsupportedOperationException(String.format("%s is only supported with the standard YAML config parser, please use \"config.yaml\" as the config file.", PipelineOptions.SERIALIZATION_CONFIG.key()));
            }
            throw e;
        }
    }

    private LinkedHashSet<Class<?>> loadClasses(List<String> classNames2, ClassLoader classLoader2, String errorMessage2) {
        return classNames2.stream().map(name2 -> this.loadClass((String)name2, classLoader2, errorMessage2)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> parseKryoSerializersWithExceptionHandling(ClassLoader classLoader2, List<String> kryoSerializers) {
        try {
            return this.parseKryoSerializers(classLoader2, kryoSerializers);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Could not configure kryo serializers from %s. The expected format is:'class:<fully qualified class name>,serializer:<fully qualified serializer name>;...", kryoSerializers), e);
        }
    }

    private LinkedHashMap<Class<?>, Class<? extends Serializer<?>>> parseKryoSerializers(ClassLoader classLoader2, List<String> kryoSerializers) {
        return kryoSerializers.stream().map(ConfigurationUtils::parseStringToMap).collect(Collectors.toMap(m -> this.loadClass((String)m.get("class"), classLoader2, "Could not load class for kryo serialization"), m -> this.loadClass((String)m.get("serializer"), classLoader2, "Could not load serializer's class"), (m1, m2) -> {
            throw new IllegalArgumentException("Duplicated serializer for class: " + m1);
        }, LinkedHashMap::new));
    }

    private <T extends Class> T loadClass(String className, ClassLoader classLoader2, String errorMessage2) {
        try {
            return (T)Class.forName(className, false, classLoader2);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(errorMessage2, e);
        }
    }

    private void parseSerializationConfigWithExceptionHandling(ClassLoader classLoader2, List<String> serializationConfigs) {
        try {
            this.parseSerializationConfig(classLoader2, serializationConfigs);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Could not configure serializers from %s.", serializationConfigs), e);
        }
    }

    private void parseSerializationConfig(ClassLoader classLoader2, List<String> serializationConfigs) {
        LinkedHashMap serializationConfigByClass = serializationConfigs.stream().map(ConfigurationUtils::parseStringToMap).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(e -> this.loadClass((String)e.getKey(), classLoader2, "Could not load class for serialization config"), e -> ConfigurationUtils.parseStringToMap((String)e.getValue()), (v1, v2) -> {
            throw new IllegalArgumentException("Duplicated serializer for the same class.");
        }, LinkedHashMap::new));
        block10: for (Map.Entry entry : serializationConfigByClass.entrySet()) {
            Class type2 = (Class)entry.getKey();
            Map config = (Map)entry.getValue();
            String configType = (String)config.get("type");
            if (configType == null) {
                throw new IllegalArgumentException("Serializer type not specified for " + type2);
            }
            switch (configType) {
                case "pojo": {
                    this.registerPojoType(type2);
                    continue block10;
                }
                case "kryo": {
                    this.parseAndRegisterKryoType(classLoader2, type2, config);
                    continue block10;
                }
                case "typeinfo": {
                    this.parseAndRegisterTypeFactory(classLoader2, type2, config);
                    continue block10;
                }
            }
            throw new IllegalArgumentException(String.format("Unsupported serializer type %s for %s", configType, type2));
        }
    }

    private void parseAndRegisterKryoType(ClassLoader classLoader2, Class<?> t, Map<String, String> m) {
        String kryoType = m.get("kryo-type");
        if (kryoType == null) {
            this.registerKryoType(t);
        } else {
            switch (kryoType) {
                case "default": {
                    this.addDefaultKryoSerializer(t, (Class<? extends Serializer<?>>)this.loadClass(m.get("class"), classLoader2, "Could not load serializer's class"));
                    break;
                }
                case "registered": {
                    this.registerTypeWithKryoSerializer(t, (Class<? extends Serializer>)this.loadClass(m.get("class"), classLoader2, "Could not load serializer's class"));
                    break;
                }
            }
        }
    }

    private void parseAndRegisterTypeFactory(ClassLoader classLoader2, Class<?> t, Map<String, String> m) {
        Object factoryClass = this.loadClass(m.get("class"), classLoader2, "Could not load TypeInfoFactory's class");
        TypeExtractor.registerFactory(t, factoryClass);
        this.registerTypeWithTypeInfoFactory(t, (Class<? extends TypeInfoFactory<?>>)factoryClass);
    }

    private void registerTypeWithTypeInfoFactory(Class<?> t, Class<? extends TypeInfoFactory<?>> factory) {
        Preconditions.checkNotNull(t, "Type parameter must not be null.");
        Preconditions.checkNotNull(factory, "Factory parameter must not be null.");
        if (!TypeInfoFactory.class.isAssignableFrom(factory)) {
            throw new IllegalArgumentException("Class is not a TypeInfoFactory.");
        }
        if (this.registeredTypeInfoFactories.containsKey(t)) {
            throw new InvalidTypesException("A TypeInfoFactory for type '" + t + "' is already registered.");
        }
        this.registeredTypeInfoFactories.put(t, factory);
    }

    public ExecutionConfig getExecutionConfig() {
        return this.executionConfig;
    }

    @Override
    public SerializerConfigImpl copy() {
        SerializerConfigImpl newSerializerConfig = new SerializerConfigImpl();
        newSerializerConfig.configure(this.configuration, this.getClass().getClassLoader());
        this.getRegisteredTypesWithKryoSerializers().forEach((c, s) -> newSerializerConfig.registerTypeWithKryoSerializer((Class<?>)c, s.getSerializer()));
        this.getRegisteredTypesWithKryoSerializerClasses().forEach(newSerializerConfig::registerTypeWithKryoSerializer);
        this.getDefaultKryoSerializers().forEach((c, s) -> newSerializerConfig.addDefaultKryoSerializer((Class<?>)c, s.getSerializer()));
        this.getDefaultKryoSerializerClasses().forEach(newSerializerConfig::addDefaultKryoSerializer);
        this.getRegisteredKryoTypes().forEach(newSerializerConfig::registerKryoType);
        this.getRegisteredPojoTypes().forEach(newSerializerConfig::registerPojoType);
        this.getRegisteredTypeInfoFactories().forEach(newSerializerConfig::registerTypeWithTypeInfoFactory);
        return newSerializerConfig;
    }
}

