/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.util.Preconditions;

@Public
public abstract class CompositeType<T>
extends TypeInformation<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> typeClass;

    @PublicEvolving
    public CompositeType(Class<T> typeClass) {
        this.typeClass = Preconditions.checkNotNull(typeClass);
    }

    @Override
    @PublicEvolving
    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    @PublicEvolving
    public List<FlatFieldDescriptor> getFlatFields(String fieldExpression) {
        ArrayList<FlatFieldDescriptor> result2 = new ArrayList<FlatFieldDescriptor>();
        this.getFlatFields(fieldExpression, 0, result2);
        return result2;
    }

    @PublicEvolving
    public abstract void getFlatFields(String var1, int var2, List<FlatFieldDescriptor> var3);

    @PublicEvolving
    public abstract <X> TypeInformation<X> getTypeAt(String var1);

    @PublicEvolving
    public abstract <X> TypeInformation<X> getTypeAt(int var1);

    @PublicEvolving
    protected abstract TypeComparatorBuilder<T> createTypeComparatorBuilder();

    @PublicEvolving
    public TypeComparator<T> createComparator(int[] logicalKeyFields, boolean[] orders, int logicalFieldOffset, ExecutionConfig config) {
        TypeComparatorBuilder<T> builder = this.createTypeComparatorBuilder();
        builder.initializeTypeComparatorBuilder(logicalKeyFields.length);
        for (int logicalKeyFieldIndex = 0; logicalKeyFieldIndex < logicalKeyFields.length; ++logicalKeyFieldIndex) {
            int logicalKeyField = logicalKeyFields[logicalKeyFieldIndex];
            int logicalField = logicalFieldOffset;
            boolean comparatorAdded = false;
            for (int localFieldId = 0; localFieldId < this.getArity() && logicalField <= logicalKeyField && !comparatorAdded; ++logicalField, ++localFieldId) {
                TypeInformation localFieldType = this.getTypeAt(localFieldId);
                if (localFieldType instanceof AtomicType && logicalField == logicalKeyField) {
                    builder.addComparatorField(localFieldId, ((AtomicType)((Object)localFieldType)).createComparator(orders[logicalKeyFieldIndex], config));
                    comparatorAdded = true;
                } else if (localFieldType instanceof CompositeType && logicalField <= logicalKeyField && logicalKeyField <= logicalField + (localFieldType.getTotalFields() - 1)) {
                    builder.addComparatorField(localFieldId, ((CompositeType)localFieldType).createComparator(new int[]{logicalKeyField}, new boolean[]{orders[logicalKeyFieldIndex]}, logicalField, config));
                    comparatorAdded = true;
                }
                if (!(localFieldType instanceof CompositeType)) continue;
                logicalField += localFieldType.getTotalFields() - 1;
            }
            if (comparatorAdded) continue;
            throw new IllegalArgumentException("Could not add a comparator for the logicalkey field index " + logicalKeyFieldIndex + ".");
        }
        return builder.createTypeComparator(config);
    }

    @PublicEvolving
    public boolean hasField(String fieldName) {
        return this.getFieldIndex(fieldName) >= 0;
    }

    @Override
    @PublicEvolving
    public boolean isKeyType() {
        for (int i = 0; i < this.getArity(); ++i) {
            if (this.getTypeAt(i).isKeyType()) continue;
            return false;
        }
        return true;
    }

    @Override
    @PublicEvolving
    public boolean isSortKeyType() {
        for (int i = 0; i < this.getArity(); ++i) {
            if (this.getTypeAt(i).isSortKeyType()) continue;
            return false;
        }
        return true;
    }

    @PublicEvolving
    public abstract String[] getFieldNames();

    @PublicEvolving
    public boolean hasDeterministicFieldOrder() {
        return false;
    }

    @PublicEvolving
    public abstract int getFieldIndex(String var1);

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CompositeType) {
            CompositeType compositeType = (CompositeType)obj;
            return compositeType.canEqual(this) && this.typeClass == compositeType.typeClass;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.typeClass);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof CompositeType;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "<" + this.typeClass.getSimpleName() + ">";
    }

    @PublicEvolving
    public static class InvalidFieldReferenceException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public InvalidFieldReferenceException(String s) {
            super(s);
        }
    }

    @PublicEvolving
    public static class FlatFieldDescriptor {
        private int keyPosition;
        private TypeInformation<?> type;

        public FlatFieldDescriptor(int keyPosition, TypeInformation<?> type2) {
            if (type2 instanceof CompositeType) {
                throw new IllegalArgumentException("A flattened field can not be a composite type");
            }
            this.keyPosition = keyPosition;
            this.type = type2;
        }

        public int getPosition() {
            return this.keyPosition;
        }

        public TypeInformation<?> getType() {
            return this.type;
        }

        public String toString() {
            return "FlatFieldDescriptor [position=" + this.keyPosition + " typeInfo=" + this.type + "]";
        }
    }

    @PublicEvolving
    protected static interface TypeComparatorBuilder<T> {
        public void initializeTypeComparatorBuilder(int var1);

        public void addComparatorField(int var1, TypeComparator<?> var2);

        public TypeComparator<T> createTypeComparator(ExecutionConfig var1);
    }
}

