/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils;

import java.io.IOException;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public abstract class SimpleTypeSerializerSnapshot<T>
implements TypeSerializerSnapshot<T> {
    private static final int CURRENT_VERSION = 3;
    @Nonnull
    private Supplier<? extends TypeSerializer<T>> serializerSupplier;

    public SimpleTypeSerializerSnapshot(@Nonnull Supplier<? extends TypeSerializer<T>> serializerSupplier) {
        this.serializerSupplier = Preconditions.checkNotNull(serializerSupplier);
    }

    @Override
    public int getCurrentVersion() {
        return 3;
    }

    @Override
    public TypeSerializer<T> restoreSerializer() {
        return this.serializerSupplier.get();
    }

    @Override
    public TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializerSnapshot<T> oldSerializerSnapshot) {
        if (!(oldSerializerSnapshot instanceof SimpleTypeSerializerSnapshot)) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        SimpleTypeSerializerSnapshot oldSimpleTypeSerializerSnapshot = (SimpleTypeSerializerSnapshot)oldSerializerSnapshot;
        return oldSimpleTypeSerializerSnapshot.restoreSerializer().getClass() == this.restoreSerializer().getClass() ? TypeSerializerSchemaCompatibility.compatibleAsIs() : TypeSerializerSchemaCompatibility.incompatible();
    }

    @Override
    public void writeSnapshot(DataOutputView out) throws IOException {
    }

    @Override
    public void readSnapshot(int readVersion, DataInputView in, ClassLoader classLoader2) throws IOException {
        switch (readVersion) {
            case 3: {
                break;
            }
            case 2: {
                in.readUTF();
                break;
            }
            default: {
                throw new IOException("Unrecognized version: " + readVersion);
            }
        }
    }

    public final boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    public final int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return this.getClass().getName();
    }
}

