/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base.array;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.base.BooleanComparator;
import org.apache.flink.api.common.typeutils.base.array.PrimitiveArrayComparator;

@Internal
public class BooleanPrimitiveArrayComparator
extends PrimitiveArrayComparator<boolean[], BooleanComparator> {
    public BooleanPrimitiveArrayComparator(boolean ascending) {
        super(ascending, new BooleanComparator(ascending));
    }

    @Override
    public int hash(boolean[] record) {
        int result2 = 0;
        for (boolean field2 : record) {
            result2 += field2 ? 1231 : 1237;
        }
        return result2;
    }

    @Override
    public int compare(boolean[] first, boolean[] second) {
        for (int x = 0; x < Math.min(first.length, second.length); ++x) {
            int cmp;
            int n = second[x] == first[x] ? 0 : (cmp = first[x] ? 1 : -1);
            if (cmp == 0) continue;
            return this.ascending ? cmp : -cmp;
        }
        int cmp = first.length - second.length;
        return this.ascending ? cmp : -cmp;
    }

    @Override
    public TypeComparator<boolean[]> duplicate() {
        BooleanPrimitiveArrayComparator dupe = new BooleanPrimitiveArrayComparator(this.ascending);
        dupe.setReference(this.reference);
        return dupe;
    }
}

