/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base.array;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public final class BytePrimitiveArraySerializer
extends TypeSerializerSingleton<byte[]> {
    private static final long serialVersionUID = 1L;
    private static final byte[] EMPTY = new byte[0];
    public static final BytePrimitiveArraySerializer INSTANCE = new BytePrimitiveArraySerializer();

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public byte[] createInstance() {
        return EMPTY;
    }

    @Override
    public byte[] copy(byte[] from) {
        byte[] copy2 = new byte[from.length];
        System.arraycopy(from, 0, copy2, 0, from.length);
        return copy2;
    }

    @Override
    public byte[] copy(byte[] from, byte[] reuse) {
        return this.copy(from);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(byte[] record, DataOutputView target) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("The record must not be null.");
        }
        int len = record.length;
        target.writeInt(len);
        target.write(record);
    }

    @Override
    public byte[] deserialize(DataInputView source) throws IOException {
        int len = source.readInt();
        byte[] result2 = new byte[len];
        source.readFully(result2);
        return result2;
    }

    @Override
    public byte[] deserialize(byte[] reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int len = source.readInt();
        target.writeInt(len);
        target.write(source, len);
    }

    @Override
    public TypeSerializerSnapshot<byte[]> snapshotConfiguration() {
        return new BytePrimitiveArraySerializerSnapshot();
    }

    public static final class BytePrimitiveArraySerializerSnapshot
    extends SimpleTypeSerializerSnapshot<byte[]> {
        public BytePrimitiveArraySerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

