/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base.array;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.base.IntComparator;
import org.apache.flink.api.common.typeutils.base.array.PrimitiveArrayComparator;

@Internal
public class IntPrimitiveArrayComparator
extends PrimitiveArrayComparator<int[], IntComparator> {
    public IntPrimitiveArrayComparator(boolean ascending) {
        super(ascending, new IntComparator(ascending));
    }

    @Override
    public int hash(int[] record) {
        int result2 = 0;
        for (int field2 : record) {
            result2 += field2;
        }
        return result2;
    }

    @Override
    public int compare(int[] first, int[] second) {
        for (int x = 0; x < Math.min(first.length, second.length); ++x) {
            int cmp = first[x] - second[x];
            if (cmp == 0) continue;
            return this.ascending ? cmp : -cmp;
        }
        int cmp = first.length - second.length;
        return this.ascending ? cmp : -cmp;
    }

    @Override
    public TypeComparator<int[]> duplicate() {
        IntPrimitiveArrayComparator dupe = new IntPrimitiveArrayComparator(this.ascending);
        dupe.setReference(this.reference);
        return dupe;
    }
}

