/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base.array;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

@Internal
public class IntPrimitiveArraySerializer
extends TypeSerializerSingleton<int[]> {
    private static final long serialVersionUID = 1L;
    private static final int[] EMPTY = new int[0];
    public static final IntPrimitiveArraySerializer INSTANCE = new IntPrimitiveArraySerializer();

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public int[] createInstance() {
        return EMPTY;
    }

    @Override
    public int[] copy(int[] from) {
        int[] copy2 = new int[from.length];
        System.arraycopy(from, 0, copy2, 0, from.length);
        return copy2;
    }

    @Override
    public int[] copy(int[] from, int[] reuse) {
        return this.copy(from);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public void serialize(int[] record, DataOutputView target) throws IOException {
        if (record == null) {
            throw new IllegalArgumentException("The record must not be null.");
        }
        int len = record.length;
        target.writeInt(len);
        for (int i = 0; i < len; ++i) {
            target.writeInt(record[i]);
        }
    }

    @Override
    public int[] deserialize(DataInputView source) throws IOException {
        int len = source.readInt();
        int[] result2 = new int[len];
        for (int i = 0; i < len; ++i) {
            result2[i] = source.readInt();
        }
        return result2;
    }

    @Override
    public int[] deserialize(int[] reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int len = source.readInt();
        target.writeInt(len);
        target.write(source, len * 4);
    }

    @Override
    public TypeSerializerSnapshot<int[]> snapshotConfiguration() {
        return new IntPrimitiveArraySerializerSnapshot();
    }

    public static final class IntPrimitiveArraySerializerSnapshot
    extends SimpleTypeSerializerSnapshot<int[]> {
        public IntPrimitiveArraySerializerSnapshot() {
            super(() -> INSTANCE);
        }
    }
}

