/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.CopyableValue;
import org.apache.flink.types.NormalizableKey;
import org.apache.flink.util.InstantiationUtil;

@Internal
public class CopyableValueComparator<T extends CopyableValue<T> & Comparable<T>>
extends TypeComparator<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> type;
    private final boolean ascendingComparison;
    private transient T reference;
    private transient T tempReference;
    private final TypeComparator<?>[] comparators = new TypeComparator[]{this};

    public CopyableValueComparator(boolean ascending, Class<T> type2) {
        this.type = type2;
        this.ascendingComparison = ascending;
        this.reference = InstantiationUtil.instantiate(type2, CopyableValue.class);
    }

    @Override
    public int hash(T record) {
        return record.hashCode();
    }

    @Override
    public void setReference(T toCompare) {
        toCompare.copyTo(this.reference);
    }

    @Override
    public boolean equalToReference(T candidate) {
        return candidate.equals(this.reference);
    }

    @Override
    public int compareToReference(TypeComparator<T> referencedComparator) {
        T otherRef = ((CopyableValueComparator)referencedComparator).reference;
        int comp = ((Comparable)otherRef).compareTo(this.reference);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public int compare(T first, T second) {
        int comp = ((Comparable)first).compareTo(second);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        if (this.tempReference == null) {
            this.tempReference = InstantiationUtil.instantiate(this.type, CopyableValue.class);
        }
        this.reference.read(firstSource);
        this.tempReference.read(secondSource);
        int comp = ((Comparable)this.reference).compareTo(this.tempReference);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public boolean supportsNormalizedKey() {
        return NormalizableKey.class.isAssignableFrom(this.type);
    }

    @Override
    public int getNormalizeKeyLen() {
        NormalizableKey key = (NormalizableKey)this.reference;
        return key.getMaxNormalizedKeyLen();
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < this.getNormalizeKeyLen();
    }

    @Override
    public void putNormalizedKey(T record, MemorySegment target, int offset, int numBytes) {
        NormalizableKey key = (NormalizableKey)record;
        key.copyNormalizedKey(target, offset, numBytes);
    }

    @Override
    public boolean invertNormalizedKey() {
        return !this.ascendingComparison;
    }

    @Override
    public TypeComparator<T> duplicate() {
        return new CopyableValueComparator<T>(this.ascendingComparison, this.type);
    }

    @Override
    public int extractKeys(Object record, Object[] target, int index) {
        target[index] = record;
        return 1;
    }

    @Override
    public TypeComparator<?>[] getFlatComparators() {
        return this.comparators;
    }

    @Override
    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    @Override
    public void writeWithKeyNormalization(T record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public T readWithKeyDenormalization(T reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.reference = InstantiationUtil.instantiate(this.type, CopyableValue.class);
        this.tempReference = null;
    }
}

