/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.guava31.com.google.common.base.Defaults;
import org.apache.flink.util.Preconditions;

@Internal
final class JavaRecordBuilderFactory<T> {
    private final Constructor<T> canonicalConstructor;
    @Nullable
    private final int[] paramIndexMapping;
    @Nullable
    private final Object[] defaultConstructorArgs;

    private JavaRecordBuilderFactory(Constructor<T> canonicalConstructor) {
        this(canonicalConstructor, null, null);
    }

    private JavaRecordBuilderFactory(Constructor<T> canonicalConstructor, @Nullable int[] argIndexMapping, @Nullable Object[] defaultConstructorArgs) {
        Preconditions.checkArgument(argIndexMapping == null == (defaultConstructorArgs == null));
        this.canonicalConstructor = canonicalConstructor;
        this.paramIndexMapping = argIndexMapping;
        this.defaultConstructorArgs = defaultConstructorArgs;
    }

    JavaRecordBuilder newBuilder() {
        return new JavaRecordBuilder();
    }

    static <T> JavaRecordBuilderFactory<T> create(Class<T> clazz, Field[] fields2) {
        try {
            boolean migrating;
            Object[] recordComponents = (Object[])Class.class.getMethod("getRecordComponents", new Class[0]).invoke(clazz, new Object[0]);
            Class[] componentTypes = new Class[recordComponents.length];
            ArrayList<String> componentNames = new ArrayList<String>(recordComponents.length);
            Method getType = Class.forName("java.lang.reflect.RecordComponent").getMethod("getType", new Class[0]);
            Method getName = Class.forName("java.lang.reflect.RecordComponent").getMethod("getName", new Class[0]);
            for (int i = 0; i < recordComponents.length; ++i) {
                componentNames.add((String)getName.invoke(recordComponents[i], new Object[0]));
                componentTypes[i] = (Class)getType.invoke(recordComponents[i], new Object[0]);
            }
            Constructor<T> recordConstructor = clazz.getDeclaredConstructor(componentTypes);
            recordConstructor.setAccessible(true);
            List previousFields = Arrays.stream(fields2).filter(Objects::nonNull).map(Field::getName).collect(Collectors.toList());
            boolean bl = migrating = !previousFields.equals(componentNames);
            if (migrating) {
                int[] argIndexMapping = new int[fields2.length];
                for (int i = 0; i < fields2.length; ++i) {
                    Field field2 = fields2[i];
                    argIndexMapping[i] = field2 == null ? -1 : componentNames.indexOf(fields2[i].getName());
                }
                Object[] defaultValues = new Object[componentNames.size()];
                for (int i = 0; i < componentNames.size(); ++i) {
                    Class fieldType = componentTypes[i];
                    boolean newPrimitive = fieldType.isPrimitive() && !previousFields.contains(componentNames.get(i));
                    defaultValues[i] = newPrimitive ? Defaults.defaultValue((Class)fieldType) : null;
                }
                return new JavaRecordBuilderFactory<T>(recordConstructor, argIndexMapping, defaultValues);
            }
            return new JavaRecordBuilderFactory<T>(recordConstructor);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not find record canonical constructor", e);
        }
    }

    @Internal
    final class JavaRecordBuilder {
        private final Object[] args;

        JavaRecordBuilder() {
            this.args = JavaRecordBuilderFactory.this.defaultConstructorArgs == null ? new Object[JavaRecordBuilderFactory.this.canonicalConstructor.getParameterCount()] : Arrays.copyOf(JavaRecordBuilderFactory.this.defaultConstructorArgs, JavaRecordBuilderFactory.this.defaultConstructorArgs.length);
        }

        T build() {
            try {
                return JavaRecordBuilderFactory.this.canonicalConstructor.newInstance(this.args);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not instantiate record", e);
            }
        }

        void setField(int i, Object value) {
            if (JavaRecordBuilderFactory.this.paramIndexMapping != null) {
                this.args[((JavaRecordBuilderFactory)JavaRecordBuilderFactory.this).paramIndexMapping[i]] = value;
            } else {
                this.args[i] = value;
            }
        }
    }
}

