/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import io.hops.hudi.com.esotericsoftware.kryo.Kryo;
import io.hops.hudi.com.esotericsoftware.kryo.Serializer;
import io.hops.hudi.com.esotericsoftware.kryo.factories.ReflectionSerializerFactory;
import java.io.Serializable;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.util.Preconditions;

@Internal
public class KryoRegistration
implements Serializable {
    private static final long serialVersionUID = 5375110512910892655L;
    private final Class<?> registeredClass;
    @Nullable
    private final Class<? extends Serializer<?>> serializerClass;
    @Nullable
    private final ExecutionConfig.SerializableSerializer<? extends Serializer<?>> serializableSerializerInstance;
    private final SerializerDefinitionType serializerDefinitionType;

    public KryoRegistration(Class<?> registeredClass) {
        this.registeredClass = Preconditions.checkNotNull(registeredClass);
        this.serializerClass = null;
        this.serializableSerializerInstance = null;
        this.serializerDefinitionType = SerializerDefinitionType.UNSPECIFIED;
    }

    public KryoRegistration(Class<?> registeredClass, Class<? extends Serializer<?>> serializerClass) {
        this.registeredClass = Preconditions.checkNotNull(registeredClass);
        this.serializerClass = Preconditions.checkNotNull(serializerClass);
        this.serializableSerializerInstance = null;
        this.serializerDefinitionType = SerializerDefinitionType.CLASS;
    }

    public KryoRegistration(Class<?> registeredClass, ExecutionConfig.SerializableSerializer<? extends Serializer<?>> serializableSerializerInstance) {
        this.registeredClass = Preconditions.checkNotNull(registeredClass);
        this.serializerClass = null;
        this.serializableSerializerInstance = Preconditions.checkNotNull(serializableSerializerInstance);
        this.serializerDefinitionType = SerializerDefinitionType.INSTANCE;
    }

    public Class<?> getRegisteredClass() {
        return this.registeredClass;
    }

    public SerializerDefinitionType getSerializerDefinitionType() {
        return this.serializerDefinitionType;
    }

    @Nullable
    public Class<? extends Serializer<?>> getSerializerClass() {
        return this.serializerClass;
    }

    @Nullable
    public ExecutionConfig.SerializableSerializer<? extends Serializer<?>> getSerializableSerializerInstance() {
        return this.serializableSerializerInstance;
    }

    public Serializer<?> getSerializer(Kryo kryo) {
        switch (this.serializerDefinitionType) {
            case UNSPECIFIED: {
                return null;
            }
            case CLASS: {
                return ReflectionSerializerFactory.makeSerializer(kryo, this.serializerClass, this.registeredClass);
            }
            case INSTANCE: {
                return this.serializableSerializerInstance.getSerializer();
            }
        }
        throw new IllegalStateException("Unrecognized Kryo registration serializer definition type: " + (Object)((Object)this.serializerDefinitionType));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof KryoRegistration) {
            KryoRegistration other = (KryoRegistration)obj;
            return this.serializerDefinitionType == other.serializerDefinitionType && this.registeredClass == other.registeredClass && this.serializerClass == other.serializerClass;
        }
        return false;
    }

    public int hashCode() {
        int result2 = this.serializerDefinitionType.hashCode();
        result2 = 31 * result2 + this.registeredClass.hashCode();
        if (this.serializerClass != null) {
            result2 = 31 * result2 + this.serializerClass.hashCode();
        }
        return result2;
    }

    public static enum SerializerDefinitionType {
        UNSPECIFIED,
        CLASS,
        INSTANCE;

    }
}

