/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeComparator;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.api.java.typeutils.runtime.MaskUtils;
import org.apache.flink.api.java.typeutils.runtime.NullAwareComparator;
import org.apache.flink.api.java.typeutils.runtime.TupleComparatorBase;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.types.KeyFieldOutOfBoundsException;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

@Internal
public class RowComparator
extends CompositeTypeComparator<Row> {
    private static final long serialVersionUID = 2L;
    private final int arity;
    private final int[] keyPositions;
    private final NullAwareComparator<Object>[] comparators;
    private final TypeSerializer<Object>[] serializers;
    private final int[] normalizedKeyLengths;
    private final int numLeadingNormalizableKeys;
    private final int normalizableKeyPrefixLen;
    private final boolean invertNormKey;
    private final boolean[] mask1;
    private final boolean[] mask2;
    private final transient Object[] deserializedKeyFields1;
    private final transient Object[] deserializedKeyFields2;

    public RowComparator(int arity, int[] keyPositions, TypeComparator<Object>[] comparators, TypeSerializer<Object>[] serializers, boolean[] orders) {
        this(arity, keyPositions, RowComparator.makeNullAware(comparators, orders), serializers);
    }

    private RowComparator(int arity, int[] keyPositions, NullAwareComparator<Object>[] comparators, TypeSerializer<Object>[] serializers) {
        this(arity, keyPositions, comparators, serializers, RowComparator.createAuxiliaryFields(keyPositions, comparators));
    }

    private RowComparator(int arity, int[] keyPositions, NullAwareComparator<Object>[] comparators, TypeSerializer<Object>[] serializers, Tuple4<int[], Integer, Integer, Boolean> auxiliaryFields) {
        this(arity, keyPositions, comparators, serializers, (int[])auxiliaryFields.f0, (Integer)auxiliaryFields.f1, (Integer)auxiliaryFields.f2, (Boolean)auxiliaryFields.f3);
    }

    private RowComparator(int arity, int[] keyPositions, NullAwareComparator<Object>[] comparators, TypeSerializer<Object>[] serializers, int[] normalizedKeyLengths, int numLeadingNormalizableKeys, int normalizableKeyPrefixLen, boolean invertNormKey) {
        this.arity = arity;
        this.keyPositions = keyPositions;
        this.comparators = comparators;
        this.serializers = serializers;
        this.normalizedKeyLengths = normalizedKeyLengths;
        this.numLeadingNormalizableKeys = numLeadingNormalizableKeys;
        this.normalizableKeyPrefixLen = normalizableKeyPrefixLen;
        this.invertNormKey = invertNormKey;
        this.mask1 = new boolean[2 + arity];
        this.mask2 = new boolean[2 + arity];
        this.deserializedKeyFields1 = this.instantiateDeserializationFields();
        this.deserializedKeyFields2 = this.instantiateDeserializationFields();
    }

    @Override
    public void getFlatComparator(List<TypeComparator> flatComparators) {
        for (NullAwareComparator<Object> c : this.comparators) {
            Collections.addAll(flatComparators, c.getFlatComparators());
        }
    }

    @Override
    public int hash(Row record) {
        int i;
        int code = 0;
        try {
            for (i = 0; i < this.keyPositions.length; ++i) {
                code *= TupleComparatorBase.HASH_SALT[i & 0x1F];
                Object element = record.getField(this.keyPositions[i]);
                code += this.comparators[i].hash(element);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new KeyFieldOutOfBoundsException(this.keyPositions[i]);
        }
        return code;
    }

    @Override
    public void setReference(Row toCompare) {
        int i;
        try {
            for (i = 0; i < this.keyPositions.length; ++i) {
                NullAwareComparator<Object> comparator = this.comparators[i];
                Object element = toCompare.getField(this.keyPositions[i]);
                ((TypeComparator)comparator).setReference(element);
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new KeyFieldOutOfBoundsException(this.keyPositions[i]);
        }
    }

    @Override
    public boolean equalToReference(Row candidate) {
        int i;
        try {
            for (i = 0; i < this.keyPositions.length; ++i) {
                NullAwareComparator<Object> comparator = this.comparators[i];
                Object element = candidate.getField(this.keyPositions[i]);
                if (((TypeComparator)comparator).equalToReference(element)) continue;
                return false;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new KeyFieldOutOfBoundsException(this.keyPositions[i]);
        }
        return true;
    }

    @Override
    public int compareToReference(TypeComparator<Row> referencedComparator) {
        int i;
        RowComparator other = (RowComparator)referencedComparator;
        try {
            for (i = 0; i < this.keyPositions.length; ++i) {
                int cmp = this.comparators[i].compareToReference(other.comparators[i]);
                if (cmp == 0) continue;
                return cmp;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new KeyFieldOutOfBoundsException(this.keyPositions[i]);
        }
        return 0;
    }

    @Override
    public int compare(Row first, Row second) {
        int i;
        try {
            for (i = 0; i < this.keyPositions.length; ++i) {
                Object secondElement;
                NullAwareComparator<Object> comparator = this.comparators[i];
                int keyPos = this.keyPositions[i];
                Object firstElement = first.getField(keyPos);
                int cmp = ((TypeComparator)comparator).compare(firstElement, secondElement = second.getField(keyPos));
                if (cmp == 0) continue;
                return cmp;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new KeyFieldOutOfBoundsException(this.keyPositions[i]);
        }
        return 0;
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        int fieldPos;
        int len = this.serializers.length;
        int keyLen = this.keyPositions.length;
        MaskUtils.readIntoMask(firstSource, this.mask1);
        MaskUtils.readIntoMask(secondSource, this.mask2);
        for (fieldPos = 0; fieldPos < len; ++fieldPos) {
            TypeSerializer<Object> serializer = this.serializers[fieldPos];
            if (!this.mask1[2 + fieldPos]) {
                this.deserializedKeyFields1[fieldPos] = serializer.deserialize(this.deserializedKeyFields1[fieldPos], firstSource);
            }
            if (this.mask2[2 + fieldPos]) continue;
            this.deserializedKeyFields2[fieldPos] = serializer.deserialize(this.deserializedKeyFields2[fieldPos], secondSource);
        }
        for (fieldPos = 0; fieldPos < keyLen; ++fieldPos) {
            int keyPos = this.keyPositions[fieldPos];
            NullAwareComparator<Object> comparator = this.comparators[fieldPos];
            boolean isNull1 = this.mask1[2 + keyPos];
            boolean isNull2 = this.mask2[2 + keyPos];
            int cmp = isNull1 && isNull2 ? 0 : (isNull1 ? ((TypeComparator)comparator).compare(null, this.deserializedKeyFields2[keyPos]) : (isNull2 ? ((TypeComparator)comparator).compare(this.deserializedKeyFields1[keyPos], null) : ((TypeComparator)comparator).compare(this.deserializedKeyFields1[keyPos], this.deserializedKeyFields2[keyPos])));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    @Override
    public boolean supportsNormalizedKey() {
        return this.numLeadingNormalizableKeys > 0;
    }

    @Override
    public boolean supportsSerializationWithKeyNormalization() {
        return false;
    }

    @Override
    public int getNormalizeKeyLen() {
        return this.normalizableKeyPrefixLen;
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return this.numLeadingNormalizableKeys < this.keyPositions.length || this.normalizableKeyPrefixLen == Integer.MAX_VALUE || this.normalizableKeyPrefixLen > keyBytes;
    }

    @Override
    public void putNormalizedKey(Row record, MemorySegment target, int offset, int numBytes) {
        int bytesLeft = numBytes;
        int currentOffset = offset;
        for (int i = 0; i < this.numLeadingNormalizableKeys && bytesLeft > 0; ++i) {
            int len = this.normalizedKeyLengths[i];
            len = bytesLeft >= len ? len : bytesLeft;
            NullAwareComparator<Object> comparator = this.comparators[i];
            Object element = record.getField(this.keyPositions[i]);
            ((TypeComparator)comparator).putNormalizedKey(element, target, currentOffset, len);
            bytesLeft -= len;
            currentOffset += len;
        }
    }

    @Override
    public void writeWithKeyNormalization(Row record, DataOutputView target) throws IOException {
        throw new UnsupportedOperationException("Record serialization with leading normalized keys not supported.");
    }

    @Override
    public Row readWithKeyDenormalization(Row reuse, DataInputView source) throws IOException {
        throw new UnsupportedOperationException("Record deserialization with leading normalized keys not supported.");
    }

    @Override
    public boolean invertNormalizedKey() {
        return this.invertNormKey;
    }

    @Override
    public TypeComparator<Row> duplicate() {
        NullAwareComparator[] comparatorsCopy = new NullAwareComparator[this.comparators.length];
        for (int i = 0; i < this.comparators.length; ++i) {
            comparatorsCopy[i] = (NullAwareComparator)this.comparators[i].duplicate();
        }
        TypeSerializer[] serializersCopy = new TypeSerializer[this.serializers.length];
        for (int i = 0; i < this.serializers.length; ++i) {
            serializersCopy[i] = this.serializers[i].duplicate();
        }
        return new RowComparator(this.arity, this.keyPositions, comparatorsCopy, serializersCopy, this.normalizedKeyLengths, this.numLeadingNormalizableKeys, this.normalizableKeyPrefixLen, this.invertNormKey);
    }

    @Override
    public int extractKeys(Object record, Object[] target, int index) {
        int len = this.comparators.length;
        int localIndex = index;
        for (int i = 0; i < len; ++i) {
            Object element = ((Row)record).getField(this.keyPositions[i]);
            localIndex += this.comparators[i].extractKeys(element, target, localIndex);
        }
        return localIndex - index;
    }

    private Object[] instantiateDeserializationFields() {
        Object[] newFields = new Object[this.serializers.length];
        for (int i = 0; i < this.serializers.length; ++i) {
            newFields[i] = this.serializers[i].createInstance();
        }
        return newFields;
    }

    private static Tuple4<int[], Integer, Integer, Boolean> createAuxiliaryFields(int[] keyPositions, NullAwareComparator<Object>[] comparators) {
        int[] normalizedKeyLengths = new int[keyPositions.length];
        int numLeadingNormalizableKeys = 0;
        int normalizableKeyPrefixLen = 0;
        boolean inverted = false;
        for (int i = 0; i < keyPositions.length; ++i) {
            NullAwareComparator<Object> k = comparators[i];
            if (k.supportsNormalizedKey()) {
                if (i == 0) {
                    inverted = k.invertNormalizedKey();
                } else if (k.invertNormalizedKey() != inverted) {
                    return new Tuple4<int[], Integer, Integer, Boolean>(normalizedKeyLengths, numLeadingNormalizableKeys, normalizableKeyPrefixLen, inverted);
                }
                ++numLeadingNormalizableKeys;
                int len = k.getNormalizeKeyLen();
                if (len < 0) {
                    throw new RuntimeException("Comparator " + k.getClass().getName() + " specifies an invalid length for the normalized key: " + len);
                }
                normalizedKeyLengths[i] = len;
                if ((normalizableKeyPrefixLen += len) >= 0) continue;
                return new Tuple4<int[], Integer, Integer, Boolean>(normalizedKeyLengths, numLeadingNormalizableKeys, Integer.MAX_VALUE, inverted);
            }
            return new Tuple4<int[], Integer, Integer, Boolean>(normalizedKeyLengths, numLeadingNormalizableKeys, normalizableKeyPrefixLen, inverted);
        }
        return new Tuple4<int[], Integer, Integer, Boolean>(normalizedKeyLengths, numLeadingNormalizableKeys, normalizableKeyPrefixLen, inverted);
    }

    private static NullAwareComparator<Object>[] makeNullAware(TypeComparator<Object>[] comparators, boolean[] orders) {
        Preconditions.checkArgument(comparators.length == orders.length);
        NullAwareComparator[] result2 = new NullAwareComparator[comparators.length];
        for (int i = 0; i < comparators.length; ++i) {
            result2[i] = new NullAwareComparator<Object>(comparators[i], orders[i]);
        }
        return result2;
    }
}

