/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime.kryo;

import io.hops.hudi.com.esotericsoftware.kryo.Kryo;
import io.hops.hudi.com.esotericsoftware.kryo.Serializer;
import io.hops.hudi.com.esotericsoftware.kryo.io.Input;
import io.hops.hudi.com.esotericsoftware.kryo.io.Output;
import io.hops.hudi.com.esotericsoftware.kryo.serializers.CollectionSerializer;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializerConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.api.java.typeutils.AvroUtils;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractionUtils;

@Internal
public class Serializers {
    public static void recursivelyRegisterType(TypeInformation<?> typeInfo, SerializerConfig config, Set<Class<?>> alreadySeen) {
        if (typeInfo instanceof GenericTypeInfo) {
            GenericTypeInfo genericTypeInfo = (GenericTypeInfo)typeInfo;
            Serializers.recursivelyRegisterType(genericTypeInfo.getTypeClass(), config, alreadySeen);
        } else if (typeInfo instanceof CompositeType) {
            ArrayList genericTypesInComposite = new ArrayList();
            Serializers.getContainedGenericTypes((CompositeType)typeInfo, genericTypesInComposite);
            for (GenericTypeInfo genericTypeInfo : genericTypesInComposite) {
                Serializers.recursivelyRegisterType(genericTypeInfo.getTypeClass(), config, alreadySeen);
            }
        } else if (typeInfo instanceof ObjectArrayTypeInfo) {
            ObjectArrayTypeInfo objectArrayTypeInfo = (ObjectArrayTypeInfo)typeInfo;
            Serializers.recursivelyRegisterType(objectArrayTypeInfo.getComponentInfo(), config, alreadySeen);
        }
    }

    public static void recursivelyRegisterType(Class<?> type2, SerializerConfig config, Set<Class<?>> alreadySeen) {
        if (type2 == null || type2.isPrimitive() || type2 == Object.class) {
            return;
        }
        if (!alreadySeen.add(type2)) {
            return;
        }
        if (type2.isArray()) {
            Serializers.recursivelyRegisterType(type2.getComponentType(), config, alreadySeen);
        } else {
            Field[] fields2;
            config.registerKryoType(type2);
            AvroUtils.getAvroUtils().addAvroSerializersIfRequired(config, type2);
            for (Field field2 : fields2 = type2.getDeclaredFields()) {
                if (Modifier.isStatic(field2.getModifiers()) || Modifier.isTransient(field2.getModifiers())) continue;
                Type fieldType = field2.getGenericType();
                Serializers.recursivelyRegisterGenericType(fieldType, config, alreadySeen);
            }
        }
    }

    private static void recursivelyRegisterGenericType(Type fieldType, SerializerConfig config, Set<Class<?>> alreadySeen) {
        if (fieldType instanceof ParameterizedType) {
            ParameterizedType parameterizedFieldType = (ParameterizedType)fieldType;
            for (Type t : parameterizedFieldType.getActualTypeArguments()) {
                if (!TypeExtractionUtils.isClassType(t)) continue;
                Serializers.recursivelyRegisterType(TypeExtractionUtils.typeToClass(t), config, alreadySeen);
            }
            Serializers.recursivelyRegisterGenericType(parameterizedFieldType.getRawType(), config, alreadySeen);
        } else if (fieldType instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)fieldType;
            Serializers.recursivelyRegisterGenericType(genericArrayType.getGenericComponentType(), config, alreadySeen);
        } else if (fieldType instanceof Class) {
            Class clazz = (Class)fieldType;
            Serializers.recursivelyRegisterType(clazz, config, alreadySeen);
        }
    }

    private static void getContainedGenericTypes(CompositeType<?> typeInfo, List<GenericTypeInfo<?>> target) {
        for (int i = 0; i < typeInfo.getArity(); ++i) {
            TypeInformation type2 = typeInfo.getTypeAt(i);
            if (type2 instanceof CompositeType) {
                Serializers.getContainedGenericTypes((CompositeType)type2, target);
                continue;
            }
            if (!(type2 instanceof GenericTypeInfo) || target.contains(type2)) continue;
            target.add((GenericTypeInfo)type2);
        }
    }

    public static class SpecificInstanceCollectionSerializer<T extends Collection>
    extends CollectionSerializer
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Class<T> type;

        public SpecificInstanceCollectionSerializer(Class<T> type2) {
            this.type = type2;
        }

        @Override
        protected Collection create(Kryo kryo, Input input, Class<Collection> type2) {
            return (Collection)kryo.newInstance(this.type);
        }

        @Override
        protected Collection createCopy(Kryo kryo, Collection original) {
            return (Collection)kryo.newInstance(this.type);
        }
    }

    public static class SpecificInstanceCollectionSerializerForArrayList
    extends SpecificInstanceCollectionSerializer<ArrayList> {
        private static final long serialVersionUID = 1L;

        public SpecificInstanceCollectionSerializerForArrayList() {
            super(ArrayList.class);
        }
    }

    public static class DummyAvroKryoSerializerClass<T>
    extends Serializer<T> {
        @Override
        public void write(Kryo kryo, Output output, Object o) {
            throw new UnsupportedOperationException("Could not find required Avro dependency.");
        }

        @Override
        public T read(Kryo kryo, Input input, Class<T> aClass) {
            throw new UnsupportedOperationException("Could not find required Avro dependency.");
        }
    }

    public static class DummyAvroRegisteredClass {
    }
}

