/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.WritableConfig;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.FunctionWithException;

@Internal
public class ConfigUtils {
    public static <IN, OUT> void encodeArrayToConfig(WritableConfig configuration, ConfigOption<List<OUT>> key, @Nullable IN[] values2, Function<IN, OUT> mapper) {
        Preconditions.checkNotNull(configuration);
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(mapper);
        if (values2 == null) {
            return;
        }
        ConfigUtils.encodeCollectionToConfig(configuration, key, Arrays.asList(values2), mapper);
    }

    public static <IN, OUT> void encodeCollectionToConfig(WritableConfig configuration, ConfigOption<List<OUT>> key, @Nullable Collection<IN> values2, Function<IN, OUT> mapper) {
        Preconditions.checkNotNull(configuration);
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(mapper);
        if (values2 == null) {
            return;
        }
        List encodedOption = values2.stream().filter(Objects::nonNull).map(mapper).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
        configuration.set(key, encodedOption);
    }

    public static <IN, OUT, E extends Throwable> List<OUT> decodeListFromConfig(ReadableConfig configuration, ConfigOption<List<IN>> key, FunctionWithException<IN, OUT, E> mapper) throws E {
        Preconditions.checkNotNull(configuration);
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(mapper);
        List<IN> encodedString = configuration.get(key);
        if (encodedString == null || encodedString.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<Object> result2 = new ArrayList<Object>(encodedString.size());
        for (IN input : encodedString) {
            result2.add(mapper.apply(input));
        }
        return result2;
    }

    public static Set<ConfigOption<?>> getAllConfigOptions(Class<?> configOptionsClass) throws IllegalStateException {
        Field[] fields2;
        HashSet options = new HashSet();
        for (Field field2 : fields2 = configOptionsClass.getDeclaredFields()) {
            if (field2.getType() != ConfigOption.class) continue;
            try {
                options.add((ConfigOption)field2.get(configOptionsClass));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("The config option definition for field " + field2.getName() + " is not accessible.", e);
            }
        }
        return options;
    }

    private ConfigUtils() {
    }
}

