/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.time.Duration;
import java.util.Set;
import org.apache.commons.compress.utils.Sets;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.docs.ConfigGroup;
import org.apache.flink.annotation.docs.ConfigGroups;
import org.apache.flink.annotation.docs.Documentation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.configuration.description.InlineElement;
import org.apache.flink.configuration.description.LinkElement;
import org.apache.flink.configuration.description.TextElement;

@ConfigGroups(groups={@ConfigGroup(name="ExponentialDelayRestartStrategy", keyPrefix="restart-strategy.exponential-delay"), @ConfigGroup(name="FixedDelayRestartStrategy", keyPrefix="restart-strategy.fixed-delay"), @ConfigGroup(name="FailureRateRestartStrategy", keyPrefix="restart-strategy.failure-rate")})
@PublicEvolving
public class RestartStrategyOptions {
    @Internal
    public static final String RESTART_STRATEGY_CONFIG_PREFIX = "restart-strategy";
    public static final ConfigOption<String> RESTART_STRATEGY = ConfigOptions.key("restart-strategy.type").stringType().noDefaultValue().withDeprecatedKeys("restart-strategy").withDescription(Description.builder().text("Defines the restart strategy to use in case of job failures.").linebreak().text("Accepted values are:").list(TextElement.text("%s, %s, %s: No restart strategy.", RestartStrategyType.NO_RESTART_STRATEGY.getAllTextElement()), TextElement.text("%s, %s: Fixed delay restart strategy. More details can be found %s.", RestartStrategyOptions.concat(RestartStrategyType.FIXED_DELAY.getAllTextElement(), LinkElement.link("{{.Site.BaseURL}}{{.Site.LanguagePrefix}}/docs/ops/state/task_failure_recovery#fixed-delay-restart-strategy", "here"))), TextElement.text("%s, %s: Failure rate restart strategy. More details can be found %s.", RestartStrategyOptions.concat(RestartStrategyType.FAILURE_RATE.getAllTextElement(), LinkElement.link("{{.Site.BaseURL}}{{.Site.LanguagePrefix}}/docs/ops/state/task_failure_recovery#failure-rate-restart-strategy", "here"))), TextElement.text("%s, %s: Exponential delay restart strategy. More details can be found %s.", RestartStrategyOptions.concat(RestartStrategyType.EXPONENTIAL_DELAY.getAllTextElement(), LinkElement.link("{{.Site.BaseURL}}{{.Site.LanguagePrefix}}/docs/ops/state/task_failure_recovery#exponential-delay-restart-strategy", "here")))).text("If checkpointing is disabled, the default value is %s. If checkpointing is enabled, the default value is %s, and the default values of %s related config options will be used.", TextElement.code(RestartStrategyType.NO_RESTART_STRATEGY.getMainValue()), TextElement.code(RestartStrategyType.EXPONENTIAL_DELAY.getMainValue()), TextElement.code(RestartStrategyType.EXPONENTIAL_DELAY.getMainValue())).build());
    public static final ConfigOption<Integer> RESTART_STRATEGY_FIXED_DELAY_ATTEMPTS = ConfigOptions.key("restart-strategy.fixed-delay.attempts").intType().defaultValue(1).withDescription(Description.builder().text("The number of times that Flink retries the execution before the job is declared as failed if %s has been set to %s.", TextElement.code(RESTART_STRATEGY.key()), TextElement.code(RestartStrategyType.FIXED_DELAY.getMainValue())).build());
    public static final ConfigOption<Duration> RESTART_STRATEGY_FIXED_DELAY_DELAY = ConfigOptions.key("restart-strategy.fixed-delay.delay").durationType().defaultValue(Duration.ofSeconds(1L)).withDescription(Description.builder().text("Delay between two consecutive restart attempts if %s has been set to %s. Delaying the retries can be helpful when the program interacts with external systems where for example connections or pending transactions should reach a timeout before re-execution is attempted. It can be specified using notation: \"1 min\", \"20 s\"", TextElement.code(RESTART_STRATEGY.key()), TextElement.code(RestartStrategyType.FIXED_DELAY.getMainValue())).build());
    public static final ConfigOption<Integer> RESTART_STRATEGY_FAILURE_RATE_MAX_FAILURES_PER_INTERVAL = ConfigOptions.key("restart-strategy.failure-rate.max-failures-per-interval").intType().defaultValue(1).withDescription(Description.builder().text("Maximum number of restarts in given time interval before failing a job if %s has been set to %s.", TextElement.code(RESTART_STRATEGY.key()), TextElement.code(RestartStrategyType.FAILURE_RATE.getMainValue())).build());
    public static final ConfigOption<Duration> RESTART_STRATEGY_FAILURE_RATE_FAILURE_RATE_INTERVAL = ConfigOptions.key("restart-strategy.failure-rate.failure-rate-interval").durationType().defaultValue(Duration.ofMinutes(1L)).withDescription(Description.builder().text("Time interval for measuring failure rate if %s has been set to %s. It can be specified using notation: \"1 min\", \"20 s\"", TextElement.code(RESTART_STRATEGY.key()), TextElement.code(RestartStrategyType.FAILURE_RATE.getMainValue())).build());
    public static final ConfigOption<Duration> RESTART_STRATEGY_FAILURE_RATE_DELAY = ConfigOptions.key("restart-strategy.failure-rate.delay").durationType().defaultValue(Duration.ofSeconds(1L)).withDescription(Description.builder().text("Delay between two consecutive restart attempts if %s has been set to %s. It can be specified using notation: \"1 min\", \"20 s\"", TextElement.code(RESTART_STRATEGY.key()), TextElement.code(RestartStrategyType.FAILURE_RATE.getMainValue())).build());
    public static final ConfigOption<Duration> RESTART_STRATEGY_EXPONENTIAL_DELAY_INITIAL_BACKOFF = ConfigOptions.key("restart-strategy.exponential-delay.initial-backoff").durationType().defaultValue(Duration.ofSeconds(1L)).withDescription(Description.builder().text("Starting duration between restarts if %s has been set to %s. It can be specified using notation: \"1 min\", \"20 s\"", TextElement.code(RESTART_STRATEGY.key()), TextElement.code(RestartStrategyType.EXPONENTIAL_DELAY.getMainValue())).build());
    public static final ConfigOption<Duration> RESTART_STRATEGY_EXPONENTIAL_DELAY_MAX_BACKOFF = ConfigOptions.key("restart-strategy.exponential-delay.max-backoff").durationType().defaultValue(Duration.ofMinutes(1L)).withDescription(Description.builder().text("The highest possible duration between restarts if %s has been set to %s. It can be specified using notation: \"1 min\", \"20 s\"", TextElement.code(RESTART_STRATEGY.key()), TextElement.code(RestartStrategyType.EXPONENTIAL_DELAY.getMainValue())).build());
    public static final ConfigOption<Double> RESTART_STRATEGY_EXPONENTIAL_DELAY_BACKOFF_MULTIPLIER = ConfigOptions.key("restart-strategy.exponential-delay.backoff-multiplier").doubleType().defaultValue(1.5).withDescription(Description.builder().text("Backoff value is multiplied by this value after every failure,until max backoff is reached if %s has been set to %s.", TextElement.code(RESTART_STRATEGY.key()), TextElement.code(RestartStrategyType.EXPONENTIAL_DELAY.getMainValue())).build());
    public static final ConfigOption<Duration> RESTART_STRATEGY_EXPONENTIAL_DELAY_RESET_BACKOFF_THRESHOLD = ConfigOptions.key("restart-strategy.exponential-delay.reset-backoff-threshold").durationType().defaultValue(Duration.ofHours(1L)).withDescription(Description.builder().text("Threshold when the backoff is reset to its initial value if %s has been set to %s. It specifies how long the job must be running without failure to reset the exponentially increasing backoff to its initial value. It can be specified using notation: \"1 min\", \"20 s\"", TextElement.code(RESTART_STRATEGY.key()), TextElement.code(RestartStrategyType.EXPONENTIAL_DELAY.getMainValue())).build());
    public static final ConfigOption<Double> RESTART_STRATEGY_EXPONENTIAL_DELAY_JITTER_FACTOR = ConfigOptions.key("restart-strategy.exponential-delay.jitter-factor").doubleType().defaultValue(0.1).withDescription(Description.builder().text("Jitter specified as a portion of the backoff if %s has been set to %s. It represents how large random value will be added or subtracted to the backoff. Useful when you want to avoid restarting multiple jobs at the same time.", TextElement.code(RESTART_STRATEGY.key()), TextElement.code(RestartStrategyType.EXPONENTIAL_DELAY.getMainValue())).build());
    @Documentation.OverrideDefault(value="infinite")
    public static final ConfigOption<Integer> RESTART_STRATEGY_EXPONENTIAL_DELAY_ATTEMPTS = ConfigOptions.key("restart-strategy.exponential-delay.attempts-before-reset-backoff").intType().defaultValue(Integer.MAX_VALUE).withDescription(Description.builder().text("The number of times that Flink retries the execution before failing the job if %s has been set to %s. The number will be reset once the backoff is reset to its initial value.", TextElement.code(RESTART_STRATEGY.key()), TextElement.code(RestartStrategyType.EXPONENTIAL_DELAY.getMainValue())).build());

    private static InlineElement[] concat(InlineElement[] first, InlineElement ... second) {
        InlineElement[] result2 = new InlineElement[first.length + second.length];
        System.arraycopy(first, 0, result2, 0, first.length);
        System.arraycopy(second, 0, result2, first.length, second.length);
        return result2;
    }

    private RestartStrategyOptions() {
        throw new UnsupportedOperationException("This class should never be instantiated.");
    }

    @Internal
    public static enum RestartStrategyType {
        NO_RESTART_STRATEGY("disable", Sets.newHashSet((Object[])new String[]{"none", "off"})),
        FIXED_DELAY("fixed-delay", Sets.newHashSet((Object[])new String[]{"fixeddelay"})),
        FAILURE_RATE("failure-rate", Sets.newHashSet((Object[])new String[]{"failurerate"})),
        EXPONENTIAL_DELAY("exponential-delay", Sets.newHashSet((Object[])new String[]{"exponentialdelay"}));

        private final String mainValue;
        private final Set<String> allAvailableValues;

        private RestartStrategyType(String mainValue, Set<String> otherAvailableValues) {
            this.mainValue = mainValue;
            this.allAvailableValues = Sets.newHashSet((Object[])new String[]{mainValue});
            this.allAvailableValues.addAll(otherAvailableValues);
        }

        public static RestartStrategyType of(String value) {
            for (RestartStrategyType restartStrategyType : RestartStrategyType.values()) {
                if (!restartStrategyType.getAllAvailableValues().contains(value)) continue;
                return restartStrategyType;
            }
            throw new IllegalArgumentException(String.format("%s is an unknown value of RestartStrategyType.", value));
        }

        public String getMainValue() {
            return this.mainValue;
        }

        public Set<String> getAllAvailableValues() {
            return this.allAvailableValues;
        }

        public TextElement[] getAllTextElement() {
            return (TextElement[])this.allAvailableValues.stream().map(TextElement::code).toArray(TextElement[]::new);
        }
    }
}

