/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.classloading;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.shaded.guava31.com.google.common.collect.Iterators;
import org.apache.flink.util.function.FunctionWithException;

public class ComponentClassLoader
extends URLClassLoader {
    private static final ClassLoader PLATFORM_OR_BOOTSTRAP_LOADER;
    private final ClassLoader ownerClassLoader;
    private final String[] ownerFirstPackages;
    private final String[] componentFirstPackages;
    private final String[] ownerFirstResourcePrefixes;
    private final String[] componentFirstResourcePrefixes;
    private final Map<String, String> knownPackagePrefixesModuleAssociation;

    public ComponentClassLoader(URL[] classpath2, ClassLoader ownerClassLoader, String[] ownerFirstPackages, String[] componentFirstPackages, Map<String, String> knownPackagePrefixesModuleAssociation) {
        super(classpath2, PLATFORM_OR_BOOTSTRAP_LOADER);
        this.ownerClassLoader = ownerClassLoader;
        this.ownerFirstPackages = ownerFirstPackages;
        this.componentFirstPackages = componentFirstPackages;
        this.knownPackagePrefixesModuleAssociation = knownPackagePrefixesModuleAssociation;
        this.ownerFirstResourcePrefixes = ComponentClassLoader.convertPackagePrefixesToPathPrefixes(ownerFirstPackages);
        this.componentFirstResourcePrefixes = ComponentClassLoader.convertPackagePrefixesToPathPrefixes(componentFirstPackages);
    }

    @Override
    protected Class<?> loadClass(String name2, boolean resolve2) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name2);
        synchronized (object) {
            try {
                Class<?> loadedClass = this.findLoadedClass(name2);
                if (loadedClass != null) {
                    return this.resolveIfNeeded(resolve2, loadedClass);
                }
                if (this.isComponentFirstClass(name2)) {
                    return this.loadClassFromComponentFirst(name2, resolve2);
                }
                if (this.isOwnerFirstClass(name2)) {
                    return this.loadClassFromOwnerFirst(name2, resolve2);
                }
                return this.loadClassFromComponentOnly(name2, resolve2);
            }
            catch (ClassNotFoundException e) {
                Optional<String> foundAssociatedModule = this.knownPackagePrefixesModuleAssociation.entrySet().stream().filter(entry -> name2.startsWith((String)entry.getKey())).map(Map.Entry::getValue).findFirst();
                if (foundAssociatedModule.isPresent()) {
                    throw new ClassNotFoundException(String.format("Class '%s' not found. Perhaps you forgot to add the module '%s' to the classpath?", name2, foundAssociatedModule.get()), e);
                }
                throw e;
            }
        }
    }

    private Class<?> resolveIfNeeded(boolean resolve2, Class<?> loadedClass) {
        if (resolve2) {
            this.resolveClass(loadedClass);
        }
        return loadedClass;
    }

    private boolean isOwnerFirstClass(String name2) {
        return Arrays.stream(this.ownerFirstPackages).anyMatch(name2::startsWith);
    }

    private boolean isComponentFirstClass(String name2) {
        return Arrays.stream(this.componentFirstPackages).anyMatch(name2::startsWith);
    }

    private Class<?> loadClassFromComponentOnly(String name2, boolean resolve2) throws ClassNotFoundException {
        return super.loadClass(name2, resolve2);
    }

    private Class<?> loadClassFromComponentFirst(String name2, boolean resolve2) throws ClassNotFoundException {
        try {
            return this.loadClassFromComponentOnly(name2, resolve2);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return this.loadClassFromOwnerOnly(name2, resolve2);
        }
    }

    private Class<?> loadClassFromOwnerOnly(String name2, boolean resolve2) throws ClassNotFoundException {
        return this.resolveIfNeeded(resolve2, this.ownerClassLoader.loadClass(name2));
    }

    private Class<?> loadClassFromOwnerFirst(String name2, boolean resolve2) throws ClassNotFoundException {
        try {
            return this.loadClassFromOwnerOnly(name2, resolve2);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return this.loadClassFromComponentOnly(name2, resolve2);
        }
    }

    @Override
    public URL getResource(String name2) {
        try {
            Enumeration<URL> resources = this.getResources(name2);
            if (resources.hasMoreElements()) {
                return resources.nextElement();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name2) {
        if (this.isComponentFirstClass(name2)) {
            return super.getResourceAsStream(name2);
        }
        if (this.isOwnerFirstClass(name2)) {
            return this.ownerClassLoader.getResourceAsStream(name2);
        }
        return super.getResourceAsStream(name2);
    }

    @Override
    public Enumeration<URL> getResources(String name2) throws IOException {
        if (this.isComponentFirstResource(name2)) {
            return this.loadResourceFromComponentFirst(name2);
        }
        if (this.isOwnerFirstResource(name2)) {
            return this.loadResourceFromOwnerFirst(name2);
        }
        return this.loadResourceFromComponentOnly(name2);
    }

    private boolean isOwnerFirstResource(String name2) {
        return Arrays.stream(this.ownerFirstResourcePrefixes).anyMatch(name2::startsWith);
    }

    private boolean isComponentFirstResource(String name2) {
        return Arrays.stream(this.componentFirstResourcePrefixes).anyMatch(name2::startsWith);
    }

    private Enumeration<URL> loadResourceFromComponentOnly(String name2) throws IOException {
        return super.getResources(name2);
    }

    private Enumeration<URL> loadResourceFromComponentFirst(String name2) throws IOException {
        return this.loadResourcesInOrder(name2, this::loadResourceFromComponentOnly, this::loadResourceFromOwnerOnly);
    }

    private Enumeration<URL> loadResourceFromOwnerOnly(String name2) throws IOException {
        return this.ownerClassLoader.getResources(name2);
    }

    private Enumeration<URL> loadResourceFromOwnerFirst(String name2) throws IOException {
        return this.loadResourcesInOrder(name2, this::loadResourceFromOwnerOnly, this::loadResourceFromComponentOnly);
    }

    private Enumeration<URL> loadResourcesInOrder(String name2, ResourceLoadingFunction firstClassLoader, ResourceLoadingFunction secondClassLoader) throws IOException {
        Iterator iterator2 = Iterators.concat((Iterator)Iterators.forEnumeration((Enumeration)((Enumeration)firstClassLoader.apply(name2))), (Iterator)Iterators.forEnumeration((Enumeration)((Enumeration)secondClassLoader.apply(name2))));
        return new IteratorBackedEnumeration<URL>(iterator2);
    }

    private static String[] convertPackagePrefixesToPathPrefixes(String[] packagePrefixes) {
        return (String[])Arrays.stream(packagePrefixes).map(packageName -> packageName.replace('.', '/')).toArray(String[]::new);
    }

    static {
        ClassLoader platformLoader = null;
        try {
            platformLoader = (ClassLoader)ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot retrieve platform classloader on Java 9+", e);
        }
        PLATFORM_OR_BOOTSTRAP_LOADER = platformLoader;
        ClassLoader.registerAsParallelCapable();
    }

    @VisibleForTesting
    static class IteratorBackedEnumeration<T>
    implements Enumeration<T> {
        private final Iterator<T> backingIterator;

        public IteratorBackedEnumeration(Iterator<T> backingIterator) {
            this.backingIterator = backingIterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.backingIterator.hasNext();
        }

        @Override
        public T nextElement() {
            return this.backingIterator.next();
        }
    }

    private static interface ResourceLoadingFunction
    extends FunctionWithException<String, Enumeration<URL>, IOException> {
    }
}

