/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.ByteBufferReadable;
import org.apache.flink.core.fs.ByteBufferReadableClosingFSDataInputStream;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataInputStreamWrapper;
import org.apache.flink.core.fs.SafetyNetCloseableRegistry;
import org.apache.flink.core.fs.WrappingProxyCloseable;
import org.apache.flink.util.Preconditions;

@Internal
public class ClosingFSDataInputStream
extends FSDataInputStreamWrapper
implements WrappingProxyCloseable<FSDataInputStream> {
    private final SafetyNetCloseableRegistry registry;
    private final String debugInfo;
    private volatile boolean closed;

    protected ClosingFSDataInputStream(FSDataInputStream delegate, SafetyNetCloseableRegistry registry, String debugInfo2) throws IOException {
        super(delegate);
        this.registry = Preconditions.checkNotNull(registry);
        this.debugInfo = Preconditions.checkNotNull(debugInfo2);
        this.closed = false;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.registry.unregisterCloseable(this);
            this.inputStream.close();
        }
    }

    public int hashCode() {
        return this.inputStream.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClosingFSDataInputStream) {
            return this.inputStream.equals(((ClosingFSDataInputStream)obj).inputStream);
        }
        return false;
    }

    public String toString() {
        return "ClosingFSDataInputStream(" + this.inputStream.toString() + ") : " + this.debugInfo;
    }

    public static ClosingFSDataInputStream wrapSafe(FSDataInputStream delegate, SafetyNetCloseableRegistry registry) throws IOException {
        return ClosingFSDataInputStream.wrapSafe(delegate, registry, "");
    }

    public static ClosingFSDataInputStream wrapSafe(FSDataInputStream delegate, SafetyNetCloseableRegistry registry, String debugInfo2) throws IOException {
        ClosingFSDataInputStream inputStream = delegate instanceof ByteBufferReadable ? new ByteBufferReadableClosingFSDataInputStream(delegate, registry, debugInfo2) : new ClosingFSDataInputStream(delegate, registry, debugInfo2);
        registry.registerCloseable(inputStream);
        return inputStream;
    }
}

