/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FSDataOutputStreamWrapper;
import org.apache.flink.core.fs.SafetyNetCloseableRegistry;
import org.apache.flink.core.fs.WrappingProxyCloseable;
import org.apache.flink.util.Preconditions;

@Internal
public class ClosingFSDataOutputStream
extends FSDataOutputStreamWrapper
implements WrappingProxyCloseable<FSDataOutputStream> {
    private final SafetyNetCloseableRegistry registry;
    private final String debugString;
    private volatile boolean closed;

    public ClosingFSDataOutputStream(FSDataOutputStream delegate, SafetyNetCloseableRegistry registry) throws IOException {
        this(delegate, registry, "");
    }

    private ClosingFSDataOutputStream(FSDataOutputStream delegate, SafetyNetCloseableRegistry registry, String debugString) throws IOException {
        super(delegate);
        this.registry = Preconditions.checkNotNull(registry);
        this.debugString = Preconditions.checkNotNull(debugString);
        this.closed = false;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.registry.unregisterCloseable(this);
            this.outputStream.close();
        }
    }

    public int hashCode() {
        return this.outputStream.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClosingFSDataOutputStream) {
            return this.outputStream.equals(((ClosingFSDataOutputStream)obj).outputStream);
        }
        return false;
    }

    public String toString() {
        return "ClosingFSDataOutputStream(" + this.outputStream.toString() + ") : " + this.debugString;
    }

    public static ClosingFSDataOutputStream wrapSafe(FSDataOutputStream delegate, SafetyNetCloseableRegistry registry) throws IOException {
        return ClosingFSDataOutputStream.wrapSafe(delegate, registry, "");
    }

    public static ClosingFSDataOutputStream wrapSafe(FSDataOutputStream delegate, SafetyNetCloseableRegistry registry, String debugInfo2) throws IOException {
        ClosingFSDataOutputStream outputStream = new ClosingFSDataOutputStream(delegate, registry, debugInfo2);
        registry.registerCloseable(outputStream);
        return outputStream;
    }
}

