/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Public;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.StringUtils;

@Public
public class Path
implements IOReadableWritable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SEPARATOR = "/";
    public static final char SEPARATOR_CHAR = '/';
    public static final String CUR_DIR = ".";
    private static final Pattern WINDOWS_ROOT_DIR_REGEX = Pattern.compile("/\\p{Alpha}+:/");
    private static final Pattern DUPLICATE_CONSECUTIVE_SLASHES = Pattern.compile("/{2,}");
    private URI uri;

    public Path() {
    }

    public Path(URI uri2) {
        this.uri = uri2;
    }

    public Path(String parent, String child) {
        this(new Path(parent), new Path(child));
    }

    public Path(Path parent, String child) {
        this(parent, new Path(child));
    }

    public Path(String parent, Path child) {
        this(new Path(parent), child);
    }

    public Path(Path parent, Path child) {
        URI parentUri = parent.uri;
        String parentPath = parentUri.getPath();
        if (!parentPath.equals(SEPARATOR) && !parentPath.equals("")) {
            try {
                parentUri = new URI(parentUri.getScheme(), parentUri.getAuthority(), parentUri.getPath() + SEPARATOR, null, null);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (child.uri.getPath().startsWith(SEPARATOR)) {
            child = new Path(child.uri.getScheme(), child.uri.getAuthority(), child.uri.getPath().substring(1));
        }
        URI resolved = parentUri.resolve(child.uri);
        this.initialize(resolved.getScheme(), resolved.getAuthority(), resolved.getPath());
    }

    private String checkPathArg(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Can not create a Path from a null string");
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException("Can not create a Path from an empty string");
        }
        return path;
    }

    public Path(String pathString) {
        pathString = this.checkPathArg(pathString);
        if (this.hasWindowsDrive(pathString, false)) {
            pathString = SEPARATOR + pathString;
        }
        String scheme2 = null;
        String authority = null;
        int start2 = 0;
        int colon2 = pathString.indexOf(58);
        int slash = pathString.indexOf(47);
        if (colon2 != -1 && (slash == -1 || colon2 < slash)) {
            scheme2 = pathString.substring(0, colon2);
            start2 = colon2 + 1;
        }
        if (pathString.startsWith("//", start2) && pathString.length() - start2 > 2) {
            int nextSlash = pathString.indexOf(47, start2 + 2);
            int authEnd = nextSlash > 0 ? nextSlash : pathString.length();
            authority = pathString.substring(start2 + 2, authEnd);
            start2 = authEnd;
        }
        String path = pathString.substring(start2, pathString.length());
        this.initialize(scheme2, authority, path);
    }

    public Path(String scheme2, String authority, String path) {
        path = this.checkPathArg(path);
        this.initialize(scheme2, authority, path);
    }

    private void initialize(String scheme2, String authority, String path) {
        try {
            this.uri = new URI(scheme2, authority, this.normalizePath(path), null, null).normalize();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String normalizePath(String path) {
        if ((path = path.replace("\\", SEPARATOR)).contains("//")) {
            path = DUPLICATE_CONSECUTIVE_SLASHES.matcher(path).replaceAll(SEPARATOR);
        }
        if (path.endsWith(SEPARATOR) && !path.equals(SEPARATOR) && !WINDOWS_ROOT_DIR_REGEX.matcher(path).matches()) {
            path = path.substring(0, path.length() - SEPARATOR.length());
        }
        return path;
    }

    public URI toUri() {
        return this.uri;
    }

    public FileSystem getFileSystem() throws IOException {
        return FileSystem.get(this.toUri());
    }

    public boolean isAbsolute() {
        int start2 = this.hasWindowsDrive(this.uri.getPath(), true) ? 3 : 0;
        return this.uri.getPath().startsWith(SEPARATOR, start2);
    }

    public String getName() {
        String path = this.uri.getPath();
        int slash = path.lastIndexOf(SEPARATOR);
        return path.substring(slash + 1);
    }

    public String getPath() {
        return this.uri.getPath();
    }

    public Path getParent() {
        String parent;
        int start2;
        String path = this.uri.getPath();
        int lastSlash = path.lastIndexOf(47);
        int n = start2 = this.hasWindowsDrive(path, true) ? 3 : 0;
        if (path.length() == start2 || lastSlash == start2 && path.length() == start2 + 1) {
            return null;
        }
        if (lastSlash == -1) {
            parent = CUR_DIR;
        } else {
            int end = this.hasWindowsDrive(path, true) ? 3 : 0;
            parent = path.substring(0, lastSlash == end ? end + 1 : lastSlash);
        }
        return new Path(this.uri.getScheme(), this.uri.getAuthority(), parent);
    }

    public Path suffix(String suffix) {
        return new Path(this.getParent(), this.getName() + suffix);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.uri.getScheme() != null) {
            buffer.append(this.uri.getScheme());
            buffer.append(":");
        }
        if (this.uri.getAuthority() != null) {
            buffer.append("//");
            buffer.append(this.uri.getAuthority());
        }
        if (this.uri.getPath() != null) {
            String path = this.uri.getPath();
            if (path.indexOf(47) == 0 && this.hasWindowsDrive(path, true) && this.uri.getScheme() == null && this.uri.getAuthority() == null) {
                path = path.substring(1);
            }
            buffer.append(path);
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Path)) {
            return false;
        }
        Path that = (Path)o;
        return this.uri.equals(that.uri);
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public int compareTo(Object o) {
        Path that = (Path)o;
        return this.uri.compareTo(that.uri);
    }

    public int depth() {
        int slash;
        String path = this.uri.getPath();
        int depth = 0;
        int n = slash = path.length() == 1 && path.charAt(0) == '/' ? -1 : 0;
        while (slash != -1) {
            ++depth;
            slash = path.indexOf(SEPARATOR, slash + 1);
        }
        return depth;
    }

    public Path makeQualified(FileSystem fs) {
        Path path = this;
        if (!this.isAbsolute()) {
            path = new Path(fs.getWorkingDirectory(), this);
        }
        URI pathUri = path.toUri();
        URI fsUri = fs.getUri();
        String scheme2 = pathUri.getScheme();
        String authority = pathUri.getAuthority();
        if (scheme2 != null && (authority != null || fsUri.getAuthority() == null)) {
            return path;
        }
        if (scheme2 == null) {
            scheme2 = fsUri.getScheme();
        }
        if (authority == null && (authority = fsUri.getAuthority()) == null) {
            authority = "";
        }
        return new Path(scheme2 + "://" + authority + pathUri.getPath());
    }

    @Override
    @Deprecated
    public void read(DataInputView in) throws IOException {
        Path path = Path.deserializeFromDataInputView(in);
        if (path != null) {
            this.uri = path.toUri();
        }
    }

    @Override
    @Deprecated
    public void write(DataOutputView out) throws IOException {
        Path.serializeToDataOutputView(this, out);
    }

    public boolean hasWindowsDrive() {
        return this.hasWindowsDrive(this.uri.getPath(), true);
    }

    private boolean hasWindowsDrive(String path, boolean slashed) {
        int start2 = slashed ? 1 : 0;
        return path.length() >= start2 + 2 && (!slashed || path.charAt(0) == '/') && path.charAt(start2 + 1) == ':' && (path.charAt(start2) >= 'A' && path.charAt(start2) <= 'Z' || path.charAt(start2) >= 'a' && path.charAt(start2) <= 'z');
    }

    public static Path fromLocalFile(File file) {
        return new Path(file.toURI());
    }

    @Nullable
    public static Path deserializeFromDataInputView(DataInputView in) throws IOException {
        boolean isNotNull = in.readBoolean();
        Path result2 = null;
        if (isNotNull) {
            String scheme2 = StringUtils.readNullableString(in);
            String userInfo = StringUtils.readNullableString(in);
            String host2 = StringUtils.readNullableString(in);
            int port = in.readInt();
            String path = StringUtils.readNullableString(in);
            String query = StringUtils.readNullableString(in);
            String fragment = StringUtils.readNullableString(in);
            try {
                result2 = new Path(new URI(scheme2, userInfo, host2, port, path, query, fragment));
            }
            catch (URISyntaxException e) {
                throw new IOException("Error reconstructing URI", e);
            }
        }
        return result2;
    }

    public static void serializeToDataOutputView(Path path, DataOutputView out) throws IOException {
        URI uri2 = path.toUri();
        if (uri2 == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            StringUtils.writeNullableString(uri2.getScheme(), out);
            StringUtils.writeNullableString(uri2.getUserInfo(), out);
            StringUtils.writeNullableString(uri2.getHost(), out);
            out.writeInt(uri2.getPort());
            StringUtils.writeNullableString(uri2.getPath(), out);
            StringUtils.writeNullableString(uri2.getQuery(), out);
            StringUtils.writeNullableString(uri2.getFragment(), out);
        }
    }
}

