/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs;

import java.io.IOException;
import java.net.URI;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.BlockLocation;
import org.apache.flink.core.fs.ClosingFSDataInputStream;
import org.apache.flink.core.fs.ClosingFSDataOutputStream;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemKind;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.core.fs.SafetyNetCloseableRegistry;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.WrappingProxy;

@Internal
public class SafetyNetWrapperFileSystem
extends FileSystem
implements WrappingProxy<FileSystem> {
    private final SafetyNetCloseableRegistry registry;
    private final FileSystem unsafeFileSystem;

    public SafetyNetWrapperFileSystem(FileSystem unsafeFileSystem, SafetyNetCloseableRegistry registry) {
        this.registry = Preconditions.checkNotNull(registry);
        this.unsafeFileSystem = Preconditions.checkNotNull(unsafeFileSystem);
    }

    @Override
    public Path getWorkingDirectory() {
        return this.unsafeFileSystem.getWorkingDirectory();
    }

    @Override
    public Path getHomeDirectory() {
        return this.unsafeFileSystem.getHomeDirectory();
    }

    @Override
    public URI getUri() {
        return this.unsafeFileSystem.getUri();
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        return this.unsafeFileSystem.getFileStatus(f);
    }

    @Override
    public RecoverableWriter createRecoverableWriter() throws IOException {
        return this.unsafeFileSystem.createRecoverableWriter();
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus file, long start2, long len) throws IOException {
        return this.unsafeFileSystem.getFileBlockLocations(file, start2, len);
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        FSDataInputStream innerStream = this.unsafeFileSystem.open(f, bufferSize);
        return ClosingFSDataInputStream.wrapSafe(innerStream, this.registry, String.valueOf(f));
    }

    @Override
    public FSDataInputStream open(Path f) throws IOException {
        FSDataInputStream innerStream = this.unsafeFileSystem.open(f);
        return ClosingFSDataInputStream.wrapSafe(innerStream, this.registry, String.valueOf(f));
    }

    @Override
    public long getDefaultBlockSize() {
        return this.unsafeFileSystem.getDefaultBlockSize();
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        return this.unsafeFileSystem.listStatus(f);
    }

    @Override
    public boolean exists(Path f) throws IOException {
        return this.unsafeFileSystem.exists(f);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.unsafeFileSystem.delete(f, recursive);
    }

    @Override
    public boolean mkdirs(Path f) throws IOException {
        return this.unsafeFileSystem.mkdirs(f);
    }

    @Override
    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        FSDataOutputStream innerStream = this.unsafeFileSystem.create(f, overwrite, bufferSize, replication, blockSize);
        return ClosingFSDataOutputStream.wrapSafe(innerStream, this.registry, String.valueOf(f));
    }

    @Override
    public FSDataOutputStream create(Path f, FileSystem.WriteMode overwrite) throws IOException {
        FSDataOutputStream innerStream = this.unsafeFileSystem.create(f, overwrite);
        return ClosingFSDataOutputStream.wrapSafe(innerStream, this.registry, String.valueOf(f));
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        return this.unsafeFileSystem.rename(src, dst);
    }

    @Override
    public boolean initOutPathLocalFS(Path outPath, FileSystem.WriteMode writeMode, boolean createDirectory) throws IOException {
        return this.unsafeFileSystem.initOutPathLocalFS(outPath, writeMode, createDirectory);
    }

    @Override
    public boolean initOutPathDistFS(Path outPath, FileSystem.WriteMode writeMode, boolean createDirectory) throws IOException {
        return this.unsafeFileSystem.initOutPathDistFS(outPath, writeMode, createDirectory);
    }

    @Override
    public boolean isDistributedFS() {
        return this.unsafeFileSystem.isDistributedFS();
    }

    @Override
    public FileSystemKind getKind() {
        return this.unsafeFileSystem.getKind();
    }

    @Override
    public FileSystem getWrappedDelegate() {
        return this.unsafeFileSystem;
    }
}

